"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const browser_1 = require("@sentry/browser");
const core_1 = require("@sentry/core");
const electron_1 = require("electron");
const common_1 = require("../common");
const backend_1 = require("./backend");
/** Frontend implementation for Electron renderer backends. */
class RendererClient extends core_1.BaseClient {
    /**
     * Creates a new Electron SDK instance.
     * @param options Configuration options for this SDK.
     */
    constructor(options) {
        super(backend_1.RendererBackend, options);
        this.inner = new browser_1.BrowserClient(options);
    }
    /**
     * @inheritDoc
     */
    prepareEvent(event, scope, hint) {
        const _super = Object.create(null, {
            prepareEvent: { get: () => super.prepareEvent }
        });
        return __awaiter(this, void 0, void 0, function* () {
            event.platform = event.platform || 'javascript';
            return _super.prepareEvent.call(this, event, scope, hint);
        });
    }
    /**
     * Uploads a native crash dump (Minidump) to Sentry.
     *
     * @param path The relative or absolute path to the minidump.
     * @param event Optional event payload to attach to the minidump.
     * @param scope The SDK scope used to upload.
     */
    captureMinidump(_path, _event, _scope) {
        return __awaiter(this, void 0, void 0, function* () {
            // Noop
        });
    }
    /**
     * @inheritDoc
     */
    addBreadcrumb(breadcrumb, _hint, _scope) {
        return __awaiter(this, void 0, void 0, function* () {
            electron_1.ipcRenderer.send(common_1.IPC_CRUMB, breadcrumb);
        });
    }
    /**
     * Basically calling {@link BrowserClient.showReportDialog}
     * @inheritdoc
     */
    showReportDialog(options = {}) {
        if (!options.eventId) {
            options.eventId = core_1.getCurrentHub().lastEventId();
        }
        this.inner.showReportDialog(options);
    }
}
exports.RendererClient = RendererClient;
//# sourceMappingURL=client.js.map