const path = require('path');
const {
    ipcRenderer,
    remote,
    shell
} = require('electron');

const { BrowserWindow } = remote;

const currentWindow = remote.getCurrentWindow();
const BrowserWin = require('../browser_window_new/browser_window.render.js');

let configInfo;

try {
    configInfo = remote.require('./config.js');
} catch (err) {
    configInfo = null;
}

// 浏览器环境
const window = global;

window.RongDesktop = {
    shell,
    ipcRenderer,
    configInfo,
    require,
    remote,
    platform: process.platform,
    child_process: require('child_process'),
    workAppsPreloadPath: path.join(__dirname, '../browser_window/preload.js'),
    Win: {
        max() {
            currentWindow.maximize();
        },
        unmax() {
            currentWindow.unmaximize();
        },
        min() {
            currentWindow.minimize();
        },
        restore() {
            currentWindow.restore();
        },
        close() {
            currentWindow.close();
        },
        bringFront() {
            currentWindow.setAlwaysOnTop(false);
        },
        focus() {
            currentWindow.focus();
        },
        showInactive() {
            currentWindow.showInactive();
        },
        show(show) {
            if (show) {
                currentWindow.show();
            } else {
                currentWindow.hide();
            }
        },
        onClose(callback) {
            currentWindow.on('close', callback);
        },
    },
    Extra: {
        enableVueDevtool(toolPath) {
            if (configInfo.DEBUG) {
                BrowserWindow.addDevToolsExtension(toolPath);
            }
        },
    },
    BrowserWin,
    // Inter-Process Communication，进程间通信
    Ipc: {
        register: (key, callback) => {
            ipcRenderer.on(key, (event, ...args) => {
                callback(...args);
            });
        },
        /*
        opt 类型为: String 或 Object
        为Object时: opt.key 表示 发送标识, opt.windowId 表示发送给哪个窗口
        为String时: opt = key
         */
        send: (opt, ...args) => {
            ipcRenderer.send('browser_window_message', opt, ...args);
        },
    },
};