const { remote } = require('electron');
const path = require('path');

let remoteLibUrl;

let remoteLib;
const RemoteType = {
    public: 'public',
    private: 'private',
};
const RemoteStatus = {
    0: 'IDLE', // 空闲
    IDLE: 0,
    1: 'CONTROL', // 控制另一端
    CONTROL: 1,
    2: 'CHAIN', // 被控制
    CHAIN: 2,
};
let remoteStatus = RemoteStatus.IDLE;

const init = (option) => {
    const isPublic = option.type === RemoteType.public;
    let remoteNodeName = 'remotecontrol';
    remoteNodeName += (isPublic ? '_public' : '_private');
    remoteLibUrl = path.join(__dirname, remoteNodeName);
    remoteLib = remote.require(remoteLibUrl);
};

const handleAcceptMsg = (status, sessionStatus, error, arg, callback) => {
    console.log('accept receive', status, sessionStatus, error);
    callback = callback || {};
    if (error) {
        if (callback.onError) callback.onError();
        return;
    }
    // eslint-disable-next-line eqeqeq
    if (sessionStatus == 2) {
        if (callback.onEnd) callback.onEnd();
        return;
    }
    switch (status) {
    case 0:
        if (callback.onConnect) callback.onConnect();
        break;
    case 1:
        if (callback.onDisconnected) callback.onDisconnected();
        break;
    case 2:
        if (callback.onLogin) {
            callback.onLogin({
                address: arg[0],
                sessionName: arg[1],
            });
        }
        break;
    case 3:
        if (callback.onLoginFail) callback.onLoginFail();
        break;
    case 1000:
        if (remoteStatus !== RemoteStatus.IDLE && callback.onClose) callback.onClose();
        break;
    default:
        break;
    }
};

const handleJoinMsg = (status, error, arg, callback) => {
    console.log('join receive', status, error);
    callback = callback || {};
    if (error) {
        if (callback.onError) callback.onError();
        return;
    }
    switch (status) {
    case 1:
        if (callback.onConnected) callback.onConnected();
        break;
    case 2:
        if (callback.onDisconnected) callback.onDisconnected();
        break;
    case 3:
        if (callback.onDisplayChanged) callback.onDisplayChanged();
        break;
    case 1000:
        if (remoteStatus !== RemoteStatus.IDLE && callback.onClose) callback.onClose();
        break;
    default:
        break;
    }
    if (arg.length === 2 && arg[0] === 1 && arg[1] === 0) {
        if (remoteStatus !== RemoteStatus.IDLE && callback.onClose) callback.onClose();
    }
};

const joinRemoteControl = (address, name, callback) => {
    remoteLib.startService(address, name, (...args) => {
        const argLen = args.length;
        let status;
        let error;
        if (argLen > 2) {
            status = args[argLen - 2];
            error = args[argLen - 1];
        }
        handleJoinMsg(status, error, args, callback);
    });
    remoteStatus = RemoteStatus.CONTROL;
};

const acceptRemoteControl = (openId, openKey, callback) => {
    // node 模块出错, 暂时在该位置做错误处理, c++处理后, 删除该部分
    let connectCount = 0;
    const fixMsgRepeat = (status) => {
        if (status !== 2) {
            return status;
        }
        connectCount += 1;
        if (connectCount > 1) {
            status = 0;
            connectCount = 0;
        }
        return status;
    };
    openKey = openKey || '';
    openId = openId || '';
    remoteLib.startClient(openKey, openId, (...args) => {
        const argLen = args.length;
        let status; let sessionStatus; let
            error;
        if (argLen > 3) {
            status = args[argLen - 3];
            sessionStatus = args[argLen - 2];
            error = args[argLen - 1];
        }
        status = fixMsgRepeat(status);
        handleAcceptMsg(status, sessionStatus, error, args, callback);
    });
    remoteStatus = RemoteStatus.CHAIN;
};

const hangupRemoteControl = () => {
    if (remoteStatus === RemoteStatus.IDLE) {
        return;
    }
    const isControl = remoteStatus === RemoteStatus.CONTROL;
    const hangup = isControl ? remoteLib.stopService : remoteLib.stopClient;
    hangup();
    remoteStatus = RemoteStatus.IDLE;
};

module.exports = {
    init,
    join: joinRemoteControl,
    accept: acceptRemoteControl,
    hangup: hangupRemoteControl,
};
