
const {
    app,
    BrowserWindow,
    ipcMain,
} = require('electron');
const { platform } = require('../../utils');

ipcMain.on('badge-changed', (event, unreadCount, showCount) => {
    if (platform.darwin) {
        setBadge(showCount);
    } else if (platform.win32) {
        BrowserWindow.tray.showBlink(unreadCount);
    }
});

ipcMain.on('display-balloon', (event, title, content) => {
    BrowserWindow.tray.displayBalloon(title, content);
});

ipcMain.on('flash-frame', (event, enabled) => {
    // if (platform.win32 && BrowserWindow.mainWindow) {
    if (BrowserWindow.mainWindow) {
        BrowserWindow.mainWindow.flashFrame(enabled);
    }
});

ipcMain.on('shake-window', (event, config) => {
    const currentWindow = BrowserWindow.mainWindow;
    if (currentWindow) {
        currentWindow.shakeWindow(config);
    }
});

ipcMain.on('quit', () => {
    app.quit();
});

function setBadge(showCount) {
    app.dock.setBadge(`${showCount}`);
    BrowserWindow.tray.setTitle(showCount);
}
