// zhkxUrl: 'http://111.203.146.54:8080/default/taskcenter/index.html#/zhkx/home', // 测试(废弃)
// zhkxUrl: 'https://xh.cast.org.cn/default/taskcenter/index.html#/zhkx/home', // 正式（废弃）
'use strict';

(function (win, setting) {
    var recallMessageTimeout = setting.recallMessageTimeout || 5;// 消息撤回设置，单位分钟
    var recallEditTimeout = setting.recallEditTimeout || 5;// 消息撤回可编辑，单位分钟
    var config = {
        // loginServer: 'http://219.142.112.199',//测试
        // loginServer: "http://111.203.146.111:8081", // UAT环境
        // loginServer: 'http://111.203.146.54',//测试
        // loginServer: 'http://111.203.146.82',//测试
        loginServer: 'https://sso.cast.org.cn',//正式
        // pubHomeUrl: 'http://111.203.146.111:8080/default/portlet/home/publicHome1.jsp',// UAT环境
        // pubHomeUrl: 'http://111.203.146.54:8080/default/portlet/home/newEdition/publicHome1.jsp',//测试
        pubHomeUrl: 'https://xh.cast.org.cn/default/portlet/home/newEdition/publicHome1.jsp',//正式
        // zhkxUrl: 'http://111.203.146.54:8080/default/zhkx/zhkx/home', // 测试2.0
        // zhkxUrl: 'http://111.203.146.54:8080/default/zhkx/zhkx2.0pc/home', // 测试2.0(新)
        zhkxUrl: 'https://xh.cast.org.cn/default/zhkx/zhkx/home', // 正式2.0
        debug: true,
        locale: setting.locale,
        dataModel: {
            server: setting.server,
            serverOA: setting.serverOA
        },
        sdk: {
            protobuf: 'lib/protobuf-2.3.1.min.js'
        },
        sdkVersion: '2.6.0', // pc不影响 做数据统计用
        emoji: {
            sizePX: 16,
            url: 'modules/emoji/emoji-48.png'
        },
        voice: {
            swfobject: 'lib/swfobject-2.0.0.min.js',
            player: 'lib/player-2.0.2.swf'
        },
        upload: setting.upload || {
            file: {
                imageSize: 5 * 1024 * 1024, // 图片上限，到达上限后且小于文件上限转文件发送
                chunkSize: 1 * 1024 * 1024
            },
            base64: {
                size: 5 * 1024 * 1024 // base64大小, 私有云服务器需设置,默认5M
            },
            timeout: 60000
        },
        recallMessageTimeout: recallMessageTimeout * 60 * 1000, // 单位毫秒
        recallEditTimeout: recallEditTimeout * 60 * 1000, // 单位毫秒
        product: setting.product,
        layout: {
            rongList: {
                width: {
                    max: 280,
                    min: 230
                }
            },
            main: {
                margin: {
                    left: 300
                }
            },
            messageInput: {
                height: {
                    max: 246,
                    min: 120
                }
            },
            navBar: {
                width: {
                    min: 70,
                    max: 70
                }
            }
        },
        conversationList: {
            pageNum: 30 // 会话列表每页显示数量
        },
        search: {
            pageNum: 50 // 搜索每页显示数量
        },
        profile: {
            pageNum: 50 // 通讯录每页显示数量
        },
        groupSetting: {
            pageNum: 50 // 群成员每页显示数量,一行5个
        },
        ack: {
            pageNum: 63 // 已读状态每页显示数量，一行9个
        },
        maxGroupMemberNum: 3000, // 群组人数上限，若 server 不下发，则生效
        syncDelayTime: 1000, // 延时 1000 ms 防止大量接受离线消息重复更新
        modules: {
            // qrcodeLogin friend 使用的 server 返回结果 /configuration/all
            forgetPwd: setting.forgetPwd,
            // remoteControl.enable 使用的 server 返回结果 /configuration/all
            remoteControl: setting.remoteControl || { overtime: 60000 },
            star: setting.star || true, // 星标联系人入口，若要关闭，需设置 false
            collect: false, // 收藏功能入口
            upgrade: true, // 设置中是否显示版本说明
            zkxLoginType: '1'
        },
        zip: '+86'
    };

    // 桌面端通过 RongDesktop 定义 version、versionCode、应用名和 server 地址
    var RongDesktop = window.RongDesktop;
    console.log("RongDesktop", window);
    if (RongDesktop) {
        if (RongDesktop.configInfo) {
            config.dataModel.server = RongDesktop.configInfo.APP_SERVER;
            config.product.name = {
                zh: RongDesktop.configInfo.PRODUCT_NAME_ZH,
                en: RongDesktop.configInfo.PRODUCT_NAME_EN
            };
            config.product.version = RongDesktop.configInfo.APP_VERSION;
            config.product.versionCode = RongDesktop.configInfo.APP_VERSION_CODE;
        }
        // 多个窗口引用此文件，但 builder 中的 preload 未必对所有内容进行了挂载，故需要添加判断
        if (RongDesktop.system) {
            config.locale = RongDesktop.system.locale.split('-')[0];
        }
    }

    win.RongIM = {
        locale: {},
        dialog: {},
        components: {},
        config: config,
        debug: {}
    };
}(window, window.config));
