(function (RongIM, dependencies, components) {
  'use strict';

  var common = RongIM.common;
  var $ = dependencies.jQuery;
  var dataModel = RongIM.dataModel;
  var pinApi = dataModel.Pin;
  var im;

  RongIM.dialog.addReceiversDialog = function (defaultMembers, pinDetail) {

    im = RongIM.instance;
    var maxReceiverCount = im.serverConfig.pin.max_receiver_count;
    var options = {
          name: 'add-receivers-dialog',
          template: 'templates/blish/add-receivers-dialog.html',
          data: function () {
              return {
                  showDialog: true,
                  //config tab Title
                  configTabTitle:[{
                      name: RongIM.locale.zh.blish.orgContact,
                      id: 'org'
                  },{
                      name: RongIM.locale.zh.blish.friend,
                      id: 'follow'
                  },{
                    name: RongIM.locale.zh.blish.myMailList,
                    id: 'phone'
                  }],
                  // config selected list
                  configSeleList:[{
                    name: RongIM.locale.zh.blish.dropDownAll,
                    type: 'all',
                    id: '3'
                  },{
                      name: RongIM.locale.zh.blish.dropDownCompany,
                      type: 'company',
                      id: '2'
                  },{
                      name: RongIM.locale.zh.blish.dropDownDepart,
                      type: 'depart',
                      id: '0'
                  },{
                      name: RongIM.locale.zh.blish.dropDownWorkingGroup,
                      type: 'staff',
                      id: '1'
                  }],
                  treeTitle: RongIM.locale.zh.blish.orgContact,
                  // 当前选中的头部tab
                  itemTabParam: {},
                  // 当前选中的下拉
                  itemSeleParam: {
                    index: 0,
                    item: {}
                  },
                  selectedTreeItemParams: null,
                  // 弹窗入口区分
                  dialogEntry: "",
                  // 搜索关键字
                  searchKey: "",
                  // 搜索状态： star 搜索中 end 搜索结束 empty 搜索没结果
                  searchStatus: "",
                  // 选中人员集合
                  selected: $.extend(true, [], defaultMembers),
                  defaultSelected: $.extend(true, [], defaultMembers),
                  //是否保存为群聊
                  isStorge: false,
                  // 群组名称
                  groupName: ''
                  
              };
          },
          components: {
              'tab-title': components.tabTitle,
              'search-deprt': components.searchDeprt,
              "dialog-tree-list": components.dialogTreeList,
              dialogRight: components.dialogRight
          },
          computed: {
            defaultCount: function () {
              return defaultMembers.length;
            }
          },
          created: function () {
              this.itemTabParam = this.configTabTitle[0];
              this.itemSeleParam.item= this.configSeleList[0];
          },
          mounted: function () {},
          methods: getMethods(defaultMembers, pinDetail)
      };
      common.mountDialog(options, function (instance) {
        RongIM._groupInstance = instance;
      });
  };

  function getMethods(defaultMembers, pinDetail) {
      return {
        /**是否保存为群聊 */
        storeDayGroup(){
          this.isStorge = !this.isStorge;
        },
        // 当前选中人员
        allSeleChange(newVal) {
          // this.selected= newVal;
          this.selected= this.defaultSelected.concat(newVal);
        },
        //当前点击的树形item
        itemMember(item,target){
          this.selectedTreeItemParams = item;
          if(item.nodeType){
            this.$refs.treeItem.getMailList(item)
          }else {
            this.$refs.treeItem.getItemList(item,{
              type: 'staff',
              scope: 'name,duty,mobile,staff_no',
              keyword: this.searchKey
            });
          }
        },
        //搜索关键字
        searchChange(val,sources,searchType){
          // this.searchStatus = type;
          this.searchKey = val;
          let params = {
            type: 'staff',
            tabId: this.itemTabParam.id,
            orgtype: this.itemSeleParam.item.id,
            keyword: this.searchKey,
            scope: 'name,duty,mobile,staff_no'
          };
          this.$refs.treeItem.getItemList(null,params,sources,searchType);
        },
        //当前选中的tab
        currentAvtive(tabItem){
          this.itemTabParam= tabItem;
          this.$refs.treeItem.resetParams();
          this.$refs.treeItem.clickItemTreeParam= null;
        },
        //当前选中的下拉
        seleChange(seleItem){
          this.itemSeleParam= seleItem;
        },
        // 当前点击的tree节点
        itemMember(item,target){
          if(item.nodeType){
            this.$refs.treeItem.getMailList(item)
          }else {
            this.$refs.treeItem.getItemList(item,{
              type: 'staff',
              scope: 'name,duty,mobile,staff_no',
              keyword: this.searchKey
            });
          }
        },
        /**将创建的群添加到群聊 */
        addDayGroup(groupId,groupApi){
          groupApi.addToFav(groupId,function(errorCode){
            if (errorCode) {
              common.toastError(errorCode);
              return;
            }
          })
        },
        close() { 
          this.showDialog = false;
        },
        addReceivers: function () {
          addReceivers(this, pinDetail, defaultMembers);
        },
      };
    /*
    说明： 发送名片消息
    */
    function sendCardMessage(messageApi, params) {
      if (sendCardMessage.busy) {
          return;
      }
      sendCardMessage.busy = true;
      messageApi.sendCard(params, function (errorCode) {
          sendCardMessage.busy = false;
          if (errorCode) {
              common.toastError(errorCode);
          }
      });
    }
  }
  function addReceivers(context, pinContext, defaultMembers) {
    var defaultIdList = defaultMembers.map(function (item) {
        return item.id;
    });
    var newReciverIds = context.selected.map(function (item) {
        return item.id;
    });
    newReciverIds = newReciverIds.filter(function (id) {
        return defaultIdList.indexOf(id) === -1;
    });
    pinApi.addReceivers(pinContext.pinUid, newReciverIds, function (errorCode) {
        if (errorCode) {
            context.toastError(errorCode);
            context.close();
            return;
        }
        sendNewReceiverMessage(pinContext.pinUid);
        context.close();
    });
  }
  function sendNewReceiverMessage(uid) {
    var message = {
        messageType: pinApi.MessageType.PinNewReciverMessage,
        content: { pinUid: uid }
    };
    pinApi.observerList.notify(message);
  }
}(RongIM, {
  jQuery: jQuery,
  UploadClient: UploadClient
}, RongIM.components));