(function (RongIM, dependencies, components) {
  'use strict';

  var common = RongIM.common;
  var utils = RongIM.utils;
  var $ = dependencies.jQuery;
  var pageNum = RongIM.config.profile.pageNum;
  var im;

  RongIM.dialog.forwardDialog = function (message,entryType) {

    im = RongIM.instance;
    var dataModel = im.dataModel;
    var groupPermission = utils.groupPermission;

    // 模块化屏蔽入口
    // 好友
    var modules = im.config.modules;
    var enabledFriend = modules.friend;
    var serverConfig = im.serverConfig;
    var maxCount = serverConfig.group.max_member_count || im.config.maxGroupMemberNum;
    // 星标联系人
    var enabledStar = modules.star;
      var options = {
          name: 'forward-dialog',
          template: 'templates/blish/forward-dialog.html',
          data: function () {
              return {
                  showDialog: true,
                  //config tab Title
                  configTabTitle:[{
                    name: RongIM.locale.zh.blish.recent,
                    id: 'recentContacts',
                    index:3
                  },{
                      name: RongIM.locale.zh.blish.orgContact,
                      id: 'org',
                      index: 0
                  },{
                      name: RongIM.locale.zh.blish.friend,
                      id: 'follow',
                      index: 1
                  },{
                    name: RongIM.locale.zh.blish.myMailList,
                    id: 'phone',
                    index: 2
                  }],
                  // config selected list
                  configSeleList:[{
                    name: RongIM.locale.zh.blish.dropDownAll,
                    type: 'all',
                    id: '3'
                  },{
                      name: RongIM.locale.zh.blish.dropDownCompany,
                      type: 'company',
                      id: '2'
                  },{
                      name: RongIM.locale.zh.blish.dropDownDepart,
                      type: 'depart',
                      id: '0'
                  },{
                      name: RongIM.locale.zh.blish.dropDownWorkingGroup,
                      type: 'staff',
                      id: '1'
                  }],
                  treeTitle: RongIM.locale.zh.blish.orgContact,
                  // 当前选中的头部tab
                  itemTabParam: {},
                  // 当前选中的下拉
                  itemSeleParam: {
                    index: 0,
                    item: {}
                  },
                  selectedTreeItemParams: null,
                  // 弹窗入口区分
                  dialogEntry: entryType,
                  // 搜索关键字
                  searchKey: "",
                  // 搜索状态： star 搜索中 end 搜索结束 empty 搜索没结果
                  searchStatus: "",
                  // 选中人员集合
                  selected: [],
                  //是否保存为群聊
                  isStorge: false,
                  // 群组名称
                  groupName: '',
                  defaultSelected: [],
                  // 转发二维码图片上传后的下载链接
                  downloadUrl: '',
                  
              };
          },
          components: {
              'tab-title': components.tabTitle,
              'search-deprt': components.searchDeprt,
              "dialog-tree-list": components.dialogTreeList,
              dialogRight: components.dialogRight
          },
          computed: {
            groupIdExisted: function () {
              return !utils.isEmpty(this.groupId);
            },
          },
          created: function () {
              this.itemTabParam = this.configTabTitle[0];
              this.itemSeleParam.item= this.configSeleList[0];
          },
          mounted: function () {
            var context = this;
            var messageApi = dataModel.Message;
            messageApi.watch(function (newMessage) {
                if (newMessage.content && newMessage.messageType === 'RecallCommandMessage') {
                    if (message.messageUId === newMessage.content.messageUId) {
                        // 转发的消息被撤回
                        var tip = context.locale.forwardedFailed;
                        context.showMessage({
                            type: 'error',
                            message: tip,
                            callback: function () {
                                context.busy = false;
                                context.close();
                            }
                        });
                    }
                }
            });
          },
          methods: getMethods(dataModel, im, message)
      };
      common.mountDialog(options, function (instance) {
        RongIM._groupInstance = instance;
      });
  };

  function getMethods(dataModel, im, message) {
      return {
        /**是否保存为群聊 */
        storeDayGroup(){
          this.isStorge = !this.isStorge;
        },
        // 当前选中人员
        allSeleChange(newVal) {
          this.selected= newVal;
          this.defaultConcatSeleArr= this.defaultSelected.concat(newVal);
        },
        //搜索关键字
        searchChange(val,sources,searchType){
          // this.searchStatus = type;
          this.searchKey = val;
          let params = {
            type: 'staff',
            tabId: this.itemTabParam.id,
            orgtype: this.itemSeleParam.item.id,
            keyword: this.searchKey,
            scope: 'name,duty,mobile,staff_no'
          };
          this.$refs.treeItem.getItemList(null,params,sources,searchType);
        },
        //当前选中的tab
        currentAvtive(tabItem){
          console.log(tabItem)
          this.itemTabParam= tabItem;
          this.$refs.treeItem.resetParams();
          this.$refs.treeItem.clickItemTreeParam= null;
          this.$refs.searchIpt.resetLastSearch();
        },
        //当前选中的下拉
        seleChange(seleItem){
          this.itemSeleParam= seleItem;
        },
        // 当前点击的tree节点
        itemMember(item,target){
          if(item.nodeType){
            this.$refs.treeItem.getMailList(item)
          }else {
            this.$refs.treeItem.getItemList(item,{
              type: 'staff',
              scope: 'name,duty,mobile,staff_no',
              keyword: this.searchKey
            });
          }
        },
        /**将创建的群添加到群聊 */
        addDayGroup(groupId,groupApi){
          groupApi.addToFav(groupId,function(errorCode){
            if (errorCode) {
              common.toastError(errorCode);
              return;
            }
          })
        },
        close() {
          this.showDialog = false;
        },
        showMessage: function (params) {
          var context = this;
          params.el = context.$el.firstChild;
          common.messageToast(params);
        },
        isGroup: function (item) {
          return item.id.startsWith('group_');
        },
        submit: function () {
          var context = this;
          var params = {
              context: {
                  selected: this.selected,
                  isGroup: this.isGroup,
                  locale: this.locale,
                  close: this.close,
                  showMessage: context.showMessage,
                  busy: this.busy,
                  downloadUrl: this.downloadUrl,
                  thumbnail: this.thumbnail
              },
              api: {
                  message: dataModel.Message
              }
          };
          console.log(params)
          context.hackReset = false;
            context.$nextTick(() => {
              context.hackReset = true
            })
            if (message.length) {
              for (let i = 0; i < message.length; i++) {
                  (function (i) { 
                      setTimeout(function() { 
                        submit(params, message[i].content, context);
                          console.log(i); 
                      }, 200 * i); 
                  })(i); 
              
               
              }
            }else{
              submit(params, message.content, context);
            }   
        },
      };
    /*
    说明： 根据选择的会话转发消息， 客户端限制每秒最多发送 5 条消息，需要限制发送频率。
    */
    function submit(params, content, forwardComponent) {
      var context = params.context;
      var messageApi = params.api.message;
      // if (forwardComponent.busy) {
      //   return;
      // }
      // forwardComponent.busy = true;
        if (content.isForwaed) {
        // 转发群组二维码图片，需要上传文件服务器
          var base64Str = content.content || '';
          forwardGroupQRcode(context, base64Str, function (forwordContent) {
            sendForwardMsg(forwordContent, messageApi, context, forwardComponent);
          });
          return;
      }
      sendForwardMsg(content, messageApi, context, forwardComponent);
    }
    // 转发之前，上传群二维码
    function forwardGroupQRcode(context, base64Str, callback) {
      var getContent = function (thumbnail, url) {
          var content = {
              content: thumbnail,
              imageUri: url,
              messageName: utils.messageType.ImageMessage,
              thumbnailPath: ''
          };
          return content;
      };
      if (context.downloadUrl && context.thumbnail) {
          var forwordContent = getContent(context.thumbnail, context.downloadUrl);
          callback(forwordContent);
          return;
      }
      upload('base64', base64Str, function (errorCode, result) {
          if (errorCode) {
              console.warn('upload failed', errorCode);
              return;
          }
          context.downloadUrl = result.imageUrl;
          context.thumbnail = result.thumbnail;
          callback(getContent(result.thumbnail, result.imageUrl));
      });
    }
     // 发送转发的消息
    function sendForwardMsg(content, messageApi, context, forwardComponent) {
      var message = messageApi.create({
          messageType: content.messageName,
          content: content
      });
      if (message.messageName === utils.messageType.FileMessage) {
          message.localPath = content.localPath;
      }
      var paramList = context.selected.map(function (item) {
          var conversationType = utils.conversationType.PRIVATE;
          var targetId = item.id;
          if (item.itemNodeType && item.itemNodeType == "group") {
              conversationType = utils.conversationType.GROUP;
              targetId = targetId.replace('group_', '');
          }
          return {
              conversationType: conversationType,
              targetId: targetId,
              content: message
          };
      });
      var index = 0;
      var timer = setInterval(function () {
          if (index < paramList.length) {
              try {
                  messageApi.send(paramList[index], function (errorCode, msg) {
                      // 群组被禁言
                      if (errorCode === 'lib-22408') {
                          messageApi.addForwardFaildMessage(msg);
                      }
                  });
              } catch (error) {
                  clearInterval(timer);
              }
              index += 1;
          } else {
              clearInterval(timer);
          }
      }, 1000 / 5);
      context.showMessage({
          message: context.locale.forwarded || '已转发',
          callback: function () {
              forwardComponent.busy = false;
              context.close();
          }
      });
    }
    /**
     * 上传图片到文件服务器
     * @param type - 'file' or 'image' or 'base64'
     * @param fileData
     * @param callback
     */
    function upload(type, fileData, callback) {
      var config = RongIM.config.upload[type] || RongIM.config.upload.file;
      var dataType = RongIMLib.FileType.IMAGE;
      var thumbnail = '';
      config.data = UploadClient.dataType.data;
      config.getToken = function (done) {
          var dataModel = RongIM.instance.dataModel;
          dataModel.File.getFileToken(function (token) {
              done(token);
          }, dataType);
      };
      var uploadCallback = {
          onBeforeUpload: function (data) {
              thumbnail = data;
          },
          onProgress: function () {
          },
          onCompleted: function (data) {
              var url = common.getDownloadUrl(RongIM.config, data);

              if (url) {
                  callback(null, { imageUrl: url, thumbnail: thumbnail });
                  return;
              }
              RongIMClient.getInstance().getFileUrl(dataType, data.filename, data.name, {
                  onSuccess: function (result) {
                      var imageUrl = result.downloadUrl;
                      callback(null, { imageUrl: imageUrl, thumbnail: thumbnail });
                  },
                  onError: function () {
                      utils.console.log('获取URL失败');
                  }
              });

              // url = url || location.protocol + '//' + domain + '/' + data.key;
              // callback(null, url);
          },
          onError: callback
      };
      UploadClient.initImgBase64(config, function (uploadFile) {
          uploadFile.upload(fileData, uploadCallback);
      });
    }
  }
}(RongIM, {
  jQuery: jQuery,
  UploadClient: UploadClient
}, RongIM.components));