(function (RongIM, dependencies, components) {
    'use strict';

    var common = RongIM.common;
    var utils = RongIM.utils;
    var $ = dependencies.jQuery;
    var pageNum = RongIM.config.profile.pageNum;
    var im;

    RongIM.dialog.newDialogBox = function (groupInfo, members, entryType) {
        members = members.map(function (item) {
            return common.unifyUser(item);
        });
        im = RongIM.instance;
        var userApi = im.dataModel.User;
        var dataModel = im.dataModel;
        var conversationApi = dataModel.Conversation;
        var groupPermission = utils.groupPermission;

        // 模块化屏蔽入口
        // 好友
        var modules = im.config.modules;
        var enabledFriend = modules.friend;
        var serverConfig = im.serverConfig;
        var maxCount = serverConfig.group.max_member_count || im.config.maxGroupMemberNum;

        // 星标联系人
        var enabledStar = modules.star;
        var options = {
            name: 'new-dialog',
            template: 'templates/blish/new-dialog.html',
            data: function () {
                return {
                    showDialog: true,
                    //config tab Title
                    configTabTitle: [{
                        name: RongIM.locale.zh.blish.orgContact,
                        id: 'org'
                    }, {
                        name: RongIM.locale.zh.blish.friend,
                        id: 'follow'
                    }, {
                        name: RongIM.locale.zh.blish.myMailList,
                        id: 'phone'
                    }],
                    // config selected list
                    configSeleList: [{
                        name: RongIM.locale.zh.blish.dropDownAll,
                        type: 'all',
                        id: '3'
                    }, {
                        name: RongIM.locale.zh.blish.dropDownCompany,
                        type: 'company',
                        id: '2'
                    }, {
                        name: RongIM.locale.zh.blish.dropDownDepart,
                        type: 'depart',
                        id: '0'
                    }, {
                        name: RongIM.locale.zh.blish.dropDownWorkingGroup,
                        type: 'staff',
                        id: '1'
                    }],
                    treeTitle: RongIM.locale.zh.blish.orgContact,
                    // 当前选中的头部tab
                    itemTabParam: {},
                    // 当前选中的下拉
                    itemSeleParam: {
                        index: 0,
                        item: {}
                    },
                    selectedTreeItemParams: null,
                    // 弹窗入口区分
                    dialogEntry: "",
                    // 搜索关键字
                    searchKey: "",
                    // 搜索状态： star 搜索中 end 搜索结束 empty 搜索没结果
                    searchStatus: "",
                    // 入口区分
                    entryType: entryType,
                    // 选中人员集合
                    selected: [],
                    //是否保存为群聊
                    isStorge: true,
                    // 群组名称
                    groupName: '',
                    // 默认选中和已选中合并之后的数组
                    defaultConcatSeleArr: $.extend(true, [], members),
                    busy: false,
                    defaultSelected: $.extend(true, [], members),
                    group: groupInfo,
                    groupId: groupInfo ? groupInfo.id : null,
                    // 群组成员
                    groupsUser: [],
                    //开启邀请群聊的成员
                    openInvitaState: [],
                    // 同意邀请开启群聊验证群员
                    IncludeEnableVerification: '',
                    GroupMessageName: '',
                    groupOneInfo:''
                };
            },
            components: {
                'tab-title': components.tabTitle,
                'search-deprt': components.searchDeprt,
                "dialog-tree-list": components.dialogTreeList,
                dialogRight: components.dialogRight
            },
            computed: {
                groupIdExisted: function () {
                    return !utils.isEmpty(this.groupId);
                },
            },
            created: function () {
                // if (members && members.length > 0) {
                //     this.busy = false
                // }
                this.itemTabParam = this.configTabTitle[0];
                this.itemSeleParam.item = this.configSeleList[0];
            },
            methods: getMethods(dataModel, RongIM)
        };
        common.mountDialog(options, function (instance) {
            RongIM._groupInstance = instance;
        });
    };

    function getMethods(dataModel, RongIM) {
        var publicTreeView = RongIM.treeView;
        return {
            /**是否保存为群聊 */
            storeDayGroup() {
                this.isStorge = !this.isStorge;
            },
            // 当前选中人员
            allSeleChange(newVal) {
                this.selected = newVal;
                this.defaultConcatSeleArr = publicTreeView.combine(this.defaultSelected.concat(newVal));
                console.log(this.defaultConcatSeleArr.length)
            },
            //当前点击的树形item
            itemMember(item, target) {
                this.selectedTreeItemParams = item;
                if (item.nodeType || item.rootType == "distributionGroup") {
                    this.$refs.treeItem.getMailList(item)
                } else {
                    this.$refs.treeItem.getItemList(item, {
                        type: 'staff',
                        scope: 'name,duty,mobile,staff_no',
                        keyword: this.searchKey
                    });
                }
            },
            //搜索关键字
            searchChange(val, sources, searchType) {
                // this.searchStatus = type;
                this.searchKey = val;
                let params = {
                    type: 'staff',
                    tabId: this.itemTabParam.id,
                    orgtype: this.itemSeleParam.item.id,
                    keyword: this.searchKey,
                    scope: 'name,duty,mobile,staff_no'
                };
                this.$refs.treeItem.getItemList(null, params, sources, searchType);
            },
            //当前选中的tab
            currentAvtive(tabItem) {
                this.itemTabParam = tabItem;
                this.$refs.treeItem.resetParams();
                this.$refs.treeItem.clickItemTreeParam = null;
                this.$refs.searchDeprt.resetLastSearch();
            },
            //当前选中的下拉
            seleChange(seleItem) {
                this.itemSeleParam = seleItem;
            },
            // // 当前点击的tree节点
            // itemMember(item,target){
            //   
            //   if(item.nodeType){
            //     this.$refs.treeItem.getMailList(item)
            //   }else {
            //     this.$refs.treeItem.getItemList(item,{
            //       type: 'staff',
            //       scope: 'name,duty,mobile,staff_no',
            //       keyword: this.searchKey
            //     });
            //   }
            // },
            /**将创建的群添加到群聊 */
            addDayGroup(groupId, groupApi) {
                groupApi.addToFav(groupId, function (errorCode) {
                    if (errorCode) {
                        common.toastError(errorCode);
                        return;
                    }
                })
            },
            toastError: function (errorCode) {
                common.toastError(errorCode, this.$el.firstChild);
            },
            close() {
                this.showDialog = false;
            },
            getGroupName() {
                console.log(common)
                return getGroupName(this);
            },
            createGroup: function () {
                var api = {
                    group: dataModel.Group,
                    conversation: dataModel.Conversation
                };
                createGroup(this, api);
            },
            addMembers: function () {
                addMembers(this, dataModel.Group, this.groupId);
            },
        };
    }

    /*
    说明：已经存在的群，群设置中添加新的群组成员
    参数：
        @param {object}           context       群组信息
        @param {object}           groupApi      群组 API 接口
        @param {sring}            groupId       群组 ID
    */
    function addMembers(context, groupApi, groupId) {
        if (context.busy) {
            return;
        }
        if (context.isOwnerManage && !context.group.is_creator) {
            context.toast({
                message: context.locale.onlyOwnerManageTips,
                type: 'error'
            });
            return;
        }
        var memberIdList = common.without(context.defaultConcatSeleArr, context.defaultSelected)
            .map(function (item) {
                return item.id;
            });
        if (memberIdList.length < 1) {
            context.close();
            return;
        }
        var auth = im.auth || {};
        var group = getGroupDetail(groupId);
        var loginId = auth.id;
        var adminId = group.admin_id;
        var needJoinPermit = group.need_join_permit;
        var isAdmin = adminId === loginId;
        var isSuccess = isAdmin || !needJoinPermit;
        var toast = isSuccess ? context.locale.addMemberSuccess : context.locale.addMemberPermit;
        var locale = context.locale.createNotice;
        var api = {
            group: im.dataModel.Group,
            conversation: im.dataModel.Conversation
        };
        var CreateOrInvite = 'invite'
        var callback = function () {
            context.busy = true;
            console.log("快来进群啊-----???");
            batchFromServer(context, memberIdList, api, CreateOrInvite, groupId)

        };

        if (isSuccess) {
            checkMemberLength(context, context.defaultConcatSeleArr, callback);
        } else {
            common.messagebox(({
                message: locale,
                type: 'confirm',
                callback: callback
            }));
        }
    }

    function checkMemberLength(context, memberIdList, cb) {
        if (memberIdList.length > 99) {
            common.messagebox({
                type: 'confirm',
                message: context.locale.message.confirmLargeGroup,
                callback: cb,
                hashchangeClose: false
            });
        } else {
            cb();
        }
    }
    /*
    说明：获取群组名称
    参数：
      @param {object}           context       群组信息
    */
    function getGroupName(context) {
        var groupName;
        if (context.groupName) {
            groupName = context.groupName;
        } else {
            var MAX_LENGTH = 16;
            var memberNames = context.defaultConcatSeleArr;
            memberNames = memberNames.slice(0, MAX_LENGTH).map(function (item) {
                return item.name;
            });
            var group = {
                member_names: memberNames
            };
            groupName = common.getGroupName(group);
        }
        return groupName;
    }
    /*
    说明：创建群组
    参数：
        @param {object}           context
        @param {object}           api       ·
    */
    function createGroup(context, api) {
        var groupApi = api.group;
        var conversationApi = api.conversation;
        var CreateOrInvite = 'creat'
        if (context.busy) {
            return;
        }
        // var removeId = common.without(context.defaultConcatSeleArr, context.defaultSelected)
        // var memberIdList  = [...context.defaultConcatSeleArr].filter(x => [...removeId].every(y => y.id !== x.id)).map(obj=>obj.id);
        var memberIdList = context.defaultConcatSeleArr.map(obj => obj.id)

        console.log(memberIdList)

        if (memberIdList.length === 2) {
            var targetId = memberIdList[1];
            var conversationType = utils.conversationType.PRIVATE;
            var params = {
                targetId: targetId,
                conversationType: conversationType
            };
            im.$router.push({
                name: 'conversation',
                params: params
            });
            conversationApi.add(params);
            context.close();
            return;
        }
        var groupNameLength = context.groupName.length;
        if (groupNameLength > 0 && groupNameLength < 2) {
            common.messageToast({
                type: 'error',
                // message: context.locale.groupNameErr
                message: "群名称不得少于两个字"
            });
            return;
        }

        console.log("我正在创建群聊===>",RongIM.dataModel.config.dataModel);
        batchFromServer(context, memberIdList, api, CreateOrInvite)
    }
    function IncludeEnableVer(context, api, CreateOrInvite, groupId) {
        var groupApi = api.group;
        var conversationApi = api.conversation;
        var memberIdList = context.defaultConcatSeleArr.map(obj => obj.id)

        if (context.openInvitaState.length >= 4) {
            context.GroupMessageName = context.openInvitaState[0].name + '、' + context.openInvitaState[1].name + '、' + context.openInvitaState[2].name + '...'
        } else if (context.openInvitaState.length == 3) {
            context.GroupMessageName = context.openInvitaState[0].name + '、' + context.openInvitaState[1].name + '、' + context.openInvitaState[2].name
        } else if (context.openInvitaState.length == 2) {
            context.GroupMessageName = context.openInvitaState[0].name + '、' + context.openInvitaState[1].name
        } else if (context.openInvitaState.length == 1) {
            context.GroupMessageName = context.openInvitaState[0].name
        }
        if (context.openInvitaState.length > 0) {
            return common.messagebox({
                type: 'confirm',
                message: `${context.GroupMessageName}已经开启了群聊邀请验证，需要对方同意后才会进入群聊，是否邀请？`,
                submitText: "邀请",
                callback: function () {
                    if (CreateOrInvite == 'creat') {
                        creatGroup(context, memberIdList, api)
                    } else if (CreateOrInvite == 'invite') {
                        invite(context, groupId, memberIdList, api)
                    }
                },
                hashchangeClose: function () {
                    context.IncludeEnableVerification = false;
                }
            });
        } else {
            if (CreateOrInvite == 'creat') {
                creatGroup(context, memberIdList, api)
            } else if (CreateOrInvite == 'invite') {
                invite(context, groupId, memberIdList, api)
            }
        }
    }
    function invite(context, groupId, memberIdList, api) {
        var groupApi = api.group;
        groupApi.addMembers(groupId, memberIdList, function (errorCode) {
            context.busy = false;
            if (errorCode) {
                common.toastError(errorCode);
                return;
            }
            common.messageToast({
                message: "添加群成员成功", // toast
                type: 'success'
            });
            console.log('memberIdList-------->',groupId );
            context.openInvitaState.forEach(e => {
                GroupsendUser(context, e.id, context.group)
            });

        });
        context.close();
    }
    function creatGroup(context, memberIdList, api) {
        var group = {
            // 0: 自建群, 1: 官方群
            type: 0,
            name: context.getGroupName(),
            member_ids: memberIdList
        };
        var groupApi = api.group;
        context.IncludeEnableVerification = true;
        checkMemberLength(context, memberIdList, function () {
            context.busy = true;
            if (!context.IncludeEnableVerification) {
                return;
            }
            groupApi.create(group, function (errorCode, result) {
                context.busy = false;
                if (errorCode) {
                    RongIM.system.appLogger('error', '创建群组失败 ' + JSON.stringify(errorCode));
                    context.toastError(errorCode);
                    return;
                }
                context.show = false;
                var path = {
                    name: 'conversation',
                    params: {
                        targetId: result.id,
                        conversationType: utils.conversationType.GROUP
                    }
                };
                RongIM.system.appLogger('info', '创建群组成功 ' + result.id);
                context.hackReset = false;
                context.$nextTick(() => {
                    context.hackReset = true;
                });
                if (context.isStorge) {
                    context.addDayGroup(result.id, groupApi);
                }
                im.$router.push(path);
                common.messageToast({
                    message: "创建群成功",
                    type: 'success'
                });

                context.openInvitaState.forEach(e => {
                    GroupsendUser(context, e.id, result)
                });

            });
        })
    }
    function GroupsendUser(context, uid, Group) {
        let server =RongIM.dataModel.config.dataModel.server;
        let serverOA = server.slice(0,server.length-4);
        console.log("serverOA",serverOA);
        let message = {
            content: `"${im.loginUser.name}"邀请加入群聊"${Group.name}"，进入可查看详情`,
            imageUri: Group.portrait_url,
            messageName: "RichContentMessage",
            title: "邀请你加入群聊",
            url: `${serverOA}/mobile/#/contactsGroup/groupChatVal?sendId=${im.loginUser.id}&groupId=${Group.id}`,
        }
        console.log("url---->",message.url);
        let content = message.content;
        let title = message.title;
        let imageUri = message.imageUri
        let url = message.url
        let messageApi = RongIM.instance.dataModel.Message
        let msg = new RongIMLib.RichContentMessage({ title: title, content: content, imageUri: imageUri, url: url });
        let conversationType = RongIMLib.ConversationType.PRIVATE;
        var targetId = uid; // 目标 Id
        // context.$emit("sendGroupMessage", message)
        messageApi.send({
            conversationType: conversationType,
            targetId: targetId,
            content: msg
        })
    }
    function getGroupDetail(groupId) {
        var dataModel = RongIM.dataModel;
        var cache = dataModel._Cache;
        var group = cache.group;
        return group[groupId];
    }
    function batchFromServer(context, ids, api, CreateOrInvite, groupId) {
        im = RongIM.instance;
        var userApi = im.dataModel.User;
        context.openInvitaState = [];
        userApi.batchFromServer(ids, function (err, res) {
            if (res) {
                console.log(111, res.data);
                let userInfoUid = im.auth.id
                console.log("userinfoUid---->", userInfoUid, im);
                context.groupsUser = res.data;
                context.groupsUser.forEach(e => {
                    if (e.invita_state == 1 && e.id !== userInfoUid) {
                        context.openInvitaState.push(e)
                        console.log("context.openInvitaState-------->", context.openInvitaState);
                    }
                });
                IncludeEnableVer(context, api, CreateOrInvite, groupId)
            }

        })

    }
}(RongIM, {
    jQuery: jQuery,
    UploadClient: UploadClient
}, RongIM.components));