(function (RongIM, dependencies, components) {
    'use strict';

    var common = RongIM.common;
    var utils = RongIM.utils;
    var $ = dependencies.jQuery;
    var dialog = RongIM.dialog;
    var dataModel = RongIM.dataModel;
    var pinApi = dataModel.Pin;
    var immediately = 'Immediately';
    var im;

    RongIM.dialog.newForwardPin = function (pin) {
        var msg = {
            messageType: 'ReferenceMessage',
            content: {
                text: pin.content
            }
        }
        if (pin.attachment_count > 0) {
            pinApi.getAttachments(pin.uid, function (errorCode, result) {
                msg.attachments = result;
                dialog.pinDialogBox(msg);
            });
        } else {
            this.pinDialogBox(msg);
        }
    };
    RongIM.dialog.pinDialogBox = function (msg, callback) {

        var im = RongIM.instance;
        var enabledSms = im.serverConfig.sms.verification_state;
        var maxReceiverCount = im.serverConfig.pin.max_receiver_count;
        var publicTreeView = RongIM.treeView;
        var options = {
            name: 'pin-dialog',
            template: 'templates/blish/pin-dialog.html',
            data: function () {
                function getMsgUser() {
                    if (msg) {
                        if (msg.groupMembers) {
                            return msg.groupMembers.filter(function (member) {
                                return member.id !== im.loginUser.id;
                            })
                        }
                        var usr = msg.targetUser || msg.user;
                        if (usr && usr.id !== im.loginUser.id) {
                            return [usr];
                        }
                    }
                    return [];
                }

                function getMsgFile() {
                    if (msg) {
                        if (msg.attachments) {
                            return msg.attachments.map(function (attach) {
                                return {
                                    data: {
                                        name: attach.name,
                                        size: attach.size,
                                        type: attach.mime_type,
                                        path: attach.url
                                    },
                                    url: attach.url,
                                    progress: 100,
                                };
                            });
                        }
                        if (msg.content) {
                            var uri = msg.content.fileUrl || msg.content.imageUri;
                            if (uri) {
                                return [{
                                    data: {
                                        name: msg.content.name || uri.substr(uri.lastIndexOf('/') + 1),
                                        size: msg.content.size || msg.content.content.length * 0.75,
                                        type: msg.content.type || uri.substr(uri.lastIndexOf('.') + 1),
                                        path: uri
                                    },
                                    url: uri,
                                    progress: 100,
                                }];
                            }
                        }
                    }
                    return [];
                }

                function getMsgText() {
                    if (msg && msg.content) {
                        if (msg.messageType === 'ReferenceMessage') {
                            return msg.content.text;
                        }
                        if (typeof msg.content.content === 'string') {
                            var isInvalidType = [
                                'ImageMessage',
                                'LocationMessage',
                                'VoiceMessage',
                                'SightMessage'
                            ].some(function (invalidType) {
                                return msg.messageType === invalidType;
                            });

                            if (!isInvalidType) {
                                return msg.content.content;
                            }
                        }
                    }
                    return '';
                }

                function getSelect() {
                    if (msg && msg.selectlist) {
                        return msg.selectlist;
                    } else {
                        return []
                    }
                }

                function delDefauleSelected() {
                    if (msg && msg.isAddReceiver) {
                        return true
                    } else {
                        return false
                    }
                }
                return {
                    showDialog: true,
                    departMaxId: 0,
                    staffMaxId: 0,
                    listPage: 1,
                    //config tab Title
                    configTabTitle: [
                        // {
                        //   name: RongIM.locale.zh.contact.recent,
                        //   id: 'recent'
                        // },
                        {
                            name: RongIM.locale.zh.blish.orgContact,
                            id: 'org'
                        }, {
                            name: RongIM.locale.zh.blish.friend,
                            id: 'follow'
                        }, {
                            name: RongIM.locale.zh.blish.myMailList,
                            id: 'phone'
                        }
                    ],
                    // config selected list
                    configSeleList: [{
                        name: RongIM.locale.zh.blish.dropDownAll,
                        type: 'all',
                        id: '3'
                    }, {
                        name: RongIM.locale.zh.blish.dropDownCompany,
                        type: 'company',
                        id: '2'
                    }, {
                        name: RongIM.locale.zh.blish.dropDownDepart,
                        type: 'depart',
                        id: '0'
                    }, {
                        name: RongIM.locale.zh.blish.dropDownWorkingGroup,
                        type: 'staff',
                        id: '1'
                    }],
                    treeTitle: RongIM.locale.zh.blish.orgContact,
                    // 当前选中的头部tab
                    itemTabParam: {},
                    // 当前选中的下拉
                    itemSeleParam: {
                        index: 0,
                        item: {}
                    },
                    selectedTreeItemParams: null,
                    // 弹窗入口区分
                    dialogEntry: "",
                    // 搜索关键字
                    searchKey: "",
                    // 搜索状态： star 搜索中 end 搜索结束 empty 搜索没结果
                    searchStatus: "",
                    // 选中人员集合
                    selected: [],
                    //是否保存为群聊
                    isStorge: false,
                    // 群组名称
                    groupName: '',
                    // 默认选中和已选中合并之后的数组
                    defaultConcatSeleArr: [],
                    busy: false,
                    defaultSelected: getMsgUser(),
                    attachments: getMsgFile(),
                    content: getMsgText(),
                    isTimeSelecting: false,
                    isSpecificTimeSelecting: false,
                    isTypeSelecting: false,
                    selectedTime: immediately,
                    isSending: false,
                    enabledSms: enabledSms,
                    showSendMail: false,
                    selectedSendMail: false,
                    isOpen: this.defaultSelected ? this.defaultSelected.length > 0 : false, //是否显示已选择的联系人
                    delDefauleSelected: delDefauleSelected(), //是否可删除默认选中人员
                    isAddReceiver: msg.isAddReceiver || false,//是否是详情页面进来的
                    isTxz: msg.isTxz || false,
                    isSend: true
                };
            },
            components: {
                'tab-title': components.tabTitle,
                'search-deprt': components.searchDeprt,
                "dialog-tree-list": components.dialogTreeList,
                dialogRight: components.dialogRight
            },
            computed: {
                isAttachFull: function () {
                    var serverConfig = RongIM.serverConfig;
                    var maxAttachCount = serverConfig.pin.max_attachment_count;
                    return this.attachments.length >= maxAttachCount;
                },
                isShowTimeSelect: function () {
                    return this.isTimeSelecting && !this.isSpecificTimeSelecting;
                },
                isAbleSend: function () {
                    let length = this.selected.length;
                    return length > 0 && this.content;
                },
            },
            created: function () {
                this.itemTabParam = this.configTabTitle[0];
                this.itemSeleParam.item = this.configSeleList[0];
                console.log(this.defaultSelected)
            },
            mounted: function () {
                // this.staffMaxId = 0
                this.listPage = 1
                this.selected = [].concat(this.defaultSelected);
            },
            methods: getMethods(im, publicTreeView, callback)
        };
        common.mountDialog(options, function (instance) {
            RongIM._groupInstance = instance;
        });
    };

    function getMethods(im, publicTreeView, callback) {
        return {
            /**是否保存为群聊 */
            storeDayGroup() {
                this.isStorge = !this.isStorge;
            },
            allSeleDefaulrChange(newVal) {
                let arr = newVal.map((element, index) => {
                    if (element.itemNodeType && element.itemNodeType == "group") {
                        return element.group
                    }
                    return element
                })
                this.selected = publicTreeView.combine(arr.flat(Infinity));
            },
            //搜索关键字
            searchChange(val, sources, searchType) {
                // this.searchStatus = type;
                this.searchKey = val;
                let params = {
                    type: 'staff',
                    tabId: this.itemTabParam.id,
                    orgtype: this.itemSeleParam.item.id,
                    keyword: this.searchKey,
                    scope: 'name,duty,mobile,staff_no'
                };
                this.$refs.treeItem.getItemList(null, params, sources, searchType);
            },
            //当前选中的tab
            currentAvtive(tabItem) {
                this.itemTabParam = tabItem;
                this.$refs.treeItem.resetParams();
                this.$refs.treeItem.clickItemTreeParam = null;
                this.isOpen = false;
                this.$refs.searchDeprt.resetLastSearch();
            },
            //当前选中的下拉
            seleChange(seleItem) {
                this.itemSeleParam = seleItem;
            },
            memberResult(data) {
                console.log('djsljfdlsakjfldsakjflkadsjflkadsjf', data)
                this.staffMaxId = data.maxId
            },
            nextPage() {
                this.listPage++
                this.$refs.treeItem.getItemList(this.selectedTreeItemParams, {
                    type: 'staff',
                    scope: 'name,duty,mobile,staff_no',
                    maxId: this.staffMaxId,
                    page: this.listPage,
                    // maxId: 0,
                    limit: 8,
                    offset: 1,
                    keyword: this.searchKey
                }, null, null, true);
            },
            // 当前点击的tree节点
            itemMember(item, target) {
                this.listPage = 1
                this.staffMaxId = 0
                this.selectedTreeItemParams = item;
                // this.$refs.treeItem.resetParams();
                if (item.nodeType) {
                    this.$refs.treeItem.getMailList(item)
                } else {
                    this.$refs.treeItem.getItemList(item, {
                        type: 'staff',
                        scope: 'name,duty,mobile,staff_no',
                        page: 1,
                        maxId: 0,
                        // maxId: 0,
                        limit: 8,
                        offset: 1,
                        keyword: this.searchKey
                    });
                }
                // console.log(immediately)
                // console.log("选择时间 ===",new Date(this.selectedTime).toLocaleDateString().replace(/\//g, "-") + " " + new Date(this.selectedTime).toTimeString().substr(0, 8))
                // console.log("点击时间 ===",new Date(nowTime).toLocaleDateString().replace(/\//g, "-") + " " + new Date(nowTime).toTimeString().substr(0, 8))
            },
            close() {
                this.showDialog = false;
            },
            calcDate: calcDate,
            clickAddAttachment: function () {
                dialog.addAttachment(this);
            },
            toast: function (params) {
                params.el = this.$el.firstChild;
                common.messageToast(params);
            },
            sendPin: function () {
                if (!this.isAbleSend) return
                var nowTime = new Date();
                nowTime = nowTime.setSeconds(0);
                var isInvalidTime = this.selectedTime !== immediately && nowTime > this.selectedTime;
                if (isInvalidTime) {
                    this.toast({
                        type: 'error',
                        message: im.locale.components.newPin.pastTime
                    });
                    this.selectedTime = new Date(nowTime).setSeconds(60);
                    return;
                }
                var isAttachmentsComplete = true;
                this.$forceUpdate();
                this.attachments.forEach(function (atta) {
                    if (atta.progress < 100) {
                        isAttachmentsComplete = false;
                    }
                });
                if (!isAttachmentsComplete) {
                    this.toast({
                        type: 'error',
                        message: im.locale.components.newPin.failSend
                    });
                    return;
                }
                this.hackReset = false;
                this.$nextTick(() => {
                    this.hackReset = true;
                })
                var isValidContent = this.selected.length && this.content;
                if (isValidContent) sendPin(this, im);
            },
            enterContent: function () {
                var context = this;
                var length = this.content.length;
                if (length > 5000) {
                    context.toast({
                        type: 'error',
                        message: context.locale.components.newPin.mostContent
                    });
                    context.content = context.content.substring(0, 5000);
                }
            },
            showSendTime: function () {
                this.isTimeSelecting = !this.isTimeSelecting;
                this.isSpecificTimeSelecting = false;
                this.isTypeSelecting = false;
            },
            showSendType: function () {
                this.isTypeSelecting = !this.isTypeSelecting;
                this.isTimeSelecting = false;
                this.isSpecificTimeSelecting = false;
            },
            showSendMailType: function () {
                this.showSendMail = !this.showSendMail;
                this.isTimeSelecting = false;
                this.isSpecificTimeSelecting = false;
            },
            selectSendMailType: function (isSms) {
                console.log(isSms)
                this.selectedSendMail = isSms;
                this.showSendMail = false;
                this.isSpecificTimeSelecting = false;
            },
            selectSendType: function (isSms) {
                this.isSendSms = isSms;
                this.isTypeSelecting = false;
            },
            selectImmediately: function () {
                this.selectedTime = immediately;
                this.isTimeSelecting = false;
            },
            selectSpecificTime: function () {
                if ((Object.prototype.toString.call(this.selectedTime) !== '[object Number]')) {
                    var date = new Date();
                    date.setMilliseconds(0);
                    date.setSeconds(60);
                    this.selectedTime = date.getTime();
                }
                this.isSpecificTimeSelecting = true;
            },
            getDateItems: function () {
                var locale = im.locale.components.newPin;
                return [locale.year, locale.month, locale.day, locale.hour, locale.minute];
            },
            getSelectedTime: function () {
                if (this.selectedTime === immediately) {
                    return im.locale.components.newPin.immediatelySend;
                }
                var date = new Date(this.selectedTime);
                return formatDate(null, date);
            },
            getFormatDate: function (type) {
                var date = new Date(this.selectedTime);
                return formatDate(type, date);
            },
            getSelectedType: function () {
                var localeNewPin = im.locale.components.newPin;
                return this.isSendSms ? localeNewPin.sms : localeNewPin.app;
            },
            addAttachment: function (event) {
                var context = this;
                var fileSize = RongIM.serverConfig.media.max_file_size * 1024 * 1024;
                var fileMaxSize = fileSize ? utils.formatFileSize(fileSize) : '';
                var message = fileMaxSize ? utils.templateFormat(context.locale.tips.overSize, fileMaxSize) : '';

                var fileList = event.target.files;
                if (!checkAttachInBound(context, fileList)) {
                    context.toast({
                        type: 'error',
                        message: context.locale.components.newPin.mostAtta
                    });
                    return;
                }
                var sizeState = checkAttachSize(fileList, fileSize);
                if (sizeState === 1 || sizeState === 2) {
                    var showMsg = sizeState === 1 ? context.locale.tips.zeroSize : message;
                    this.toast({
                        type: 'error',
                        message: showMsg
                    });
                }
                var uploadCount = 0;
                for (var i = 0; i < fileList.length; i += 1) {
                    var file = fileList[i];
                    if (file.size > 0 && file.size <= fileSize) {
                        upload(file, context);
                        uploadCount += 1;
                    }
                }
                if (uploadCount === 0) {
                    return;
                }
                dialog.addAttachment(context);
                resetInputFileValue('rongAddAttachment');
            },
            executiveLimit: function (item) {
                if (item.isFriend || im.auth.isExecutive || this.disableExecutive) {
                    return false;
                }
                var isExecutive = !!item.isExecutive;
                return isExecutive;
            },
            toastError: function (errorCode) {
                common.toastError(errorCode, this.$el.firstChild);
            },
            getSelectedContact: function () {
                var context = this;
                var selLen = context.selected.filter(function (item) {
                    return !context.executiveLimit(item);
                }).length;
                var selectedContactFormat = im.locale.components.newPin.selectedContact;
                return this.localeFormat(selectedContactFormat, selLen);
            },
            selectContracts: function () {
                let allSelecteds = this.$refs.treeItem.allSelecteds;
                let defaultSeleList = this.$refs.treeItem.defaultSeleList;
                let list = allSelecteds.concat(defaultSeleList)
                // localStorage.setItem('selectContracts',list)
                this.showDialog = false;
                callback('selectContracts', list)

                // context.close();

            }
        };

        function resetInputFileValue(inputId) {
            var $inputFile = $('#' + inputId);
            $inputFile.val('');
        }

        function saveLocalAttach(attach, localPath) {
            var im = RongIM.instance;
            im.dataModel.Pin.addPinLocalAttach(attach.name, localPath);
        }

        function upload(file, context) {
            var models = RongIM.instance.dataModel;
            var pin = models.Pin;
            var getFileType = utils.getFileType;
            var fileType = getFileType(file.name);
            var attach = {
                data: file,
                progress: 0,
                url: null,
                uploadId: Date.now(),
                uploadStatus: utils.uploadStatus.READY,
                rawSize: file.size
            };
            context.attachments.push(attach);
            pin.uploadAttach(fileType, file, attach, function (err) {
                if (err) {
                    utils.console.warn('上传失败');
                    return;
                }
                saveLocalAttach(attach.data, attach.data.path);
            });
        }

        function checkAttachSize(fileList, fileSize) {
            var hasZero = 0;
            /* eslint-disable no-restricted-syntax */
            // eslint-disable-next-line guard-for-in
            for (var key in fileList) {
                if (fileList[key].size === 0) {
                    hasZero = 1;
                    break;
                }
                if (fileList[key].size > fileSize) {
                    hasZero = 2;
                    break;
                }
            }
            /* eslint-enable no-restricted-syntax */
            return hasZero;
        }

        function sendPin(context, im) {
            if (context.isSending || hasUploadingFile(context)) {
                context.toast({
                    type: 'error',
                    message: context.locale.components.newPin.uploading
                });
                return;
            }
            var sendParams = getSendParams(context);
            if (context.receivers.length > 99) {
                common.messagebox({
                    type: 'confirm',
                    message: context.locale.pin.willSend,
                    callback: function () {
                        createPin(context, im, sendParams);
                    },
                    hashchangeClose: false
                });
            } else {
                createPin(context, im, sendParams);
            }
        }

        function createPin(context, im, sendParams) {
            context.isSending = true;
            pinApi.create(sendParams, function (errorCode, result) {
                context.isSending = false;
                if (errorCode) {
                    context.toastError(errorCode);
                    return;
                }
                sendMessageWhenInSendpinPage(im, result);
                afterCreatePin(context);
            });
        }

        function afterCreatePin(context) {
            common.messagebox({
                message: context.locale.components.newPin.success,
                callback: function () {
                    context.close();
                },
                closeCallback: function () {
                    context.close();
                },
                hashchangeClose: false
            });
        }

        function sendMessageWhenInSendpinPage(im, result) {
            if (im.$route.name !== 'pin-sent') {
                return;
            }
            // content = $.extend(content, { creatorUid: content.creator_uid, timestamp: content.create_dt });
            var message = {
                messageType: pinApi.MessageType.PinNotifyMessage,
                content: {
                    pinUid: result.uid,
                    creatorUid: result.creatorUid,
                    timestamp: result.timestamp,
                    content: result.content
                }
            };
            pinApi.observerList.notify(message);
        }

        function getSendParams(context) {
            context.receivers = context.selected.filter(function (item) {
                return !context.executiveLimit(item);
            });
            var receiverIds = context.receivers.map(function (receiver) {
                return receiver.id;
            });
            var receiverNames = context.receivers[0].name;
            for (var i = 1; i < 3 && i < context.receivers.length; ++i) {
                receiverNames = receiverNames + '、' + context.receivers[i].name;
            }
            if (context.receivers.length > 3) {
                receiverNames = receiverNames + '...';
            }
            var attachments = context.attachments.filter(function (atta) {
                return atta.progress !== -1;
            });
            attachments = attachments.map(function (atta) {
                return {
                    name: atta.data.name,
                    size: atta.data.size,
                    mime_type: atta.data.type || 'unknown',
                    url: atta.url
                };
            });
            var delayed = (Object.prototype.toString.call(context.selectedTime) === '[object Number]');
            var params = {
                title: receiverNames,
                content: context.content,
                receiver_ids: receiverIds,
                delayed: delayed,
                attachments: attachments,
                send_sms: context.isSendSms,
                send_email: context.selectedSendMail
            };
            params.delayed_send_time = delayed ? context.selectedTime : '';
            return params;
        }

        function hasUploadingFile(context) {
            var attachments = context.attachments.filter(function (atta) {
                return atta.progress !== 100 && atta.progress !== -1;
            });
            return attachments.length !== 0;
        }

        function checkAttachInBound(context, fileList) {
            // PIN 携带的附件最大数
            var serverConfig = RongIM.serverConfig;
            var maxAttachCount = serverConfig.pin.max_attachment_count;
            // 附件个数设置
            var attachCount = context.attachments.length + fileList.length;
            var isBeyond = attachCount > maxAttachCount;

            return !isBeyond;
        }

        function formatDate(type, date) {
            var year = date.getFullYear();
            var month = date.getMonth() + 1;
            var day = date.getDate();
            var hour = date.getHours();
            var minute = date.getMinutes();
            switch (type) {
                case 0:
                    return year;
                case 1:
                    return month;
                case 2:
                    return day;
                case 3:
                    return hour;
                case 4:
                    return minute;
                default:
                    var addZeroWhenSingle = function (number) {
                        return (number + '').length > 1 ? number : ('0' + number);
                    };
                    var hourMark = addZeroWhenSingle(hour);
                    var minuteMark = addZeroWhenSingle(minute);
                    return year + '/' + month + '/' + day + ' ' + hourMark + ':' + minuteMark;
            }
        }

        function calcDate(dateType, addNumber) {
            var im = RongIM.instance;
            var date = new Date(this.selectedTime);
            switch (dateType) {
                case 0:
                    var year = date.getFullYear();
                    date.setFullYear(year + addNumber);
                    break;
                case 1:
                    var month = date.getMonth();
                    date.setMonth(month + addNumber);
                    break;
                case 2:
                    var day = date.getDate();
                    date.setDate(day + addNumber);
                    break;
                case 3:
                    var hour = date.getHours();
                    date.setHours(hour + addNumber);
                    break;
                case 4:
                    var minute = date.getMinutes();
                    date.setMinutes(minute + addNumber);
                    break;
                default:
                    break;
            }
            var thisTime = new Date().getTime();
            if (thisTime > date.getTime()) {
                this.toast({
                    type: 'error',
                    message: im.locale.components.newPin.pastTime
                });
                return;
            }
            date.setSeconds(0);
            date.setMilliseconds(0);
            this.selectedTime = date.getTime();
        }
    }
}(RongIM, {
    jQuery: jQuery,
    UploadClient: UploadClient
}, RongIM.components));