(function (RongIM, dependencies, components) {
    'use strict';
    var common = RongIM.common;
    var utils = RongIM.utils;
    var $ = dependencies.jQuery;
    var pageNum = RongIM.config.profile.pageNum;
    var im;
    
    /*
    说明：创建群组
    功能：通过企业通讯录、星标联系人、我的好友选择联系人创建群组
    参数：
        @param {string}           groupId       群组Id
        @param {array<object>}    members
    */
    RongIM.dialog.followReason = function (item, callback) {
        var options = {
            name: 'follow-reason',
            template: 'templates/components/follow-reason.html',
            data: function () {
                return {
                    content: '',
                    isShow: true,
                    alias: item.name,
                    localeTips: RongIM.locale.zh.blish,
                };
            },
            components: {},
            computed: {},
            created: function () {},
            methods: {
                clean(){
                    this.isShow = !this.isShow
                    callback('clean')
                },
                addContent(){
                  if(this.alias.trim() != ''){
                    this.isShow = !this.isShow
                  }
                    callback('determine',{
                      remark: this.content,
                      alias: this.alias.trim()
                    })
                }
            },
        };
        common.mountDialog(options, function (instance) {
            RongIM._groupInstance = instance;
        });
    };
    }(RongIM, {
        jQuery: jQuery
    }, RongIM.components));
    