(function (RongIM, dependencies, components) {
    'use strict';
    
    var utils = RongIM.utils;
    var common = RongIM.common;
    function transUrl(url) {
        return common.trans2Localfile(url, 'icons');
    }
    
    function imgLoaded(src, callback, onerror) {
        if (!src) {
            return;
        }
        var img = new Image();
        img.onload = callback;
        img.onerror = function () {
            if (typeof onerror === 'function') {
                onerror();
            }
        };
        img.src = transUrl(src);
    }
    
    /**
     * 搜索下拉 组件
     * @params dataList 下拉列表数组
     * @params isShow 是否显示title组件
     * @params currentAvtive 向外部传递当前点击项
     */
    
    components.searchDeprt = function (resolve, reject) {
        var im = RongIM.instance;
        var dataModel = im.dataModel;
        var userApi = dataModel.User;
        var options = {
            name: 'search-deprt',
            template: '#search-deprt',
            inject: ['reload'],
            props: {
                //下拉列表数组
                dataList: {
                    type: Array,
                    default: () => [
                        {name: "选项一"},
                        {name: "选项二"}
                    ]
                },
                //是否显示下拉列表搜索框
                isShow: {
                    type: Boolean,
                    default: true
                },
                showList: {
                  type: Boolean,
                  default: true
                },
                labelProperty:{
                    type:String,
                    default(){ return "name" }
                },
                //搜索框默认提示
                iptDefaultText: {
                    type: String,
                    default: '输入关键字'
                }
            },
            directives:{
                dpl:{
                    bind(el){
                        el.style.display = "none";
                    }
                }
            },
            data: function () {
                return {
                    activeIndex: 0,
                    showLi: false,
                    keyWord: '',
                    timeout: null,
                    lastSearch: ''
                };
            },
            computed: {
                dplLable(){
                    return this.dataList[this.activeIndex][this.labelProperty]
                }
            },
            filters: {},
            watch: {
                keyWord(newVal,oldVal){
                  clearTimeout(this.timeout)
                  if(newVal) {
                    this.timeout = setTimeout(() => {
                      this.$emit('searchChange',newVal,"search","conduct")
                    }, 1500)
                    // 开始搜索(用来展示文案提示)
                    this.$emit('searchChange',newVal,"search","star")
                  }else {
                    // 结束搜索
                    this.$emit('searchChange',newVal,"search","end")
                  }
                }
            },
            created(){ },
            mounted: function () {},

            methods: {
                /**
                 * 是否显示下拉列表
                 */
                showSelect(){
                    this.showLi = !this.showLi
                    if(this.showLi){
                        this.$refs.ul.style.display = "block";
                    }else{
                        this.$refs.ul.style.display = "none";
                    }
                },
                /**
                 * 当前点击的select每一项
                 * @param {Object} item  当前点击项
                 * @param {Number} index 点击项下标
                 */
                onLiClick(item,index){
                    this.$refs.ul.style.display = "none";
                    this.activeIndex = index;
                    this.$emit("change", {
                        item: item,
                        index: index
                    })
                },

                // 处理按下回车搜索
                handleSearch() {
                    let {keyWord, lastSearch, timeout} = this;

                    if (keyWord && (keyWord !== lastSearch)) {
                        this.lastSearch = keyWord;
                        clearInterval(timeout);
                        this.$emit('searchChange',keyWord,"search","conduct");
                    }
                },

                resetLastSearch() {
                    this.lastSearch = '';
                }
            },
            destroyed: function () {}
        };
        utils.asyncComponent(options, resolve, reject);
    };
    }(RongIM, null, RongIM.components));
    
