(function (RongIM, dependencies, components) {
    'use strict';
    
    var utils = RongIM.utils;
    var common = RongIM.common;
    function transUrl(url) {
        return common.trans2Localfile(url, 'icons');
    }
    
    function imgLoaded(src, callback, onerror) {
        if (!src) {
            return;
        }
        var img = new Image();
        img.onload = callback;
        img.onerror = function () {
            if (typeof onerror === 'function') {
                onerror();
            }
        };
        img.src = transUrl(src);
    }
    
    /**
     * title 组件
     * @params titleList 设置title的内容
     * @params isShow 是否显示title组件
     * @params currentAvtive 向外部传递当前点击项
     */
    
    components.tabTitle = function (resolve, reject) {
        var im = RongIM.instance;
        var dataModel = im.dataModel;
        var userApi = dataModel.User;
        var options = {
            name: 'tab-title',
            template: '#tab-title',
            inject: ['reload'],
            props: {
                titleList: {
                    type: Array,
                    default: () => []
                },
                isShow: {
                    type: Boolean,
                    default: true
                }
            },
            data: function () {
                return {
                    itemIndex : 0
                };
            },
            computed: {},
            filters: {},
            watch: {},
            created(){ },
            mounted: function () {},

            methods: {
                itemActive(item,index){
                    this.itemIndex = index;
                    this.$emit('currentAvtive',item)
                }
            },
            destroyed: function () {}
        };
        utils.asyncComponent(options, resolve, reject);
    };
    }(RongIM, null, RongIM.components));
    