(function (RongIM, dependencies, components) {
    'use strict';

    var utils = RongIM.utils;
    var common = RongIM.common;

    function transUrl(url) {
        return common.trans2Localfile(url, 'icons');
    }

    function imgLoaded(src, callback, onerror) {
        if (!src) {
            return;
        }
        var img = new Image();
        img.onload = callback;
        img.onerror = function () {
            if (typeof onerror === 'function') {
                onerror();
            }
        };
        img.src = transUrl(src);
    }

    /*
    说明：头像组件，用于显示头像，包括用户头像、群组头像、文件助手头像等
    */

    components.treeView = function (resolve, reject) {
        var im = RongIM.instance;
        var dataModel = im.dataModel;
        var userApi = dataModel.User;
        var options = {
            name: 'tree-view',
            template: '#tree-view',
            props: {
                dataList: {
                    type: Array,
                    default: () => []
                },
                showListType: {
                    type: Boolean,
                    default: false
                }
            },
            data: function () {
                return {
                    //当前点击的item
                    items: null,
                    isClick: true
                };
            },
            computed: {},
            filters: {},
            watch: {
                dataList: {
                    handler(newVal, oldVal) {
                        this.exampleTreeView(newVal)
                    },
                    // immediate: true,
                    deep: true
                }
            },
            created() {
                // console.log(this.dataList)
            },
            mounted: function () {
                this.exampleTreeView(this.dataList)
            },

            methods: {
                getAllParentNode(parentNode) {
                    var arry = [];
                    arry.push(parentNode);
                    //boolean i = true;
                    while (true) {
                        parentNode = $("#treeView").treeview("getNode", parentNode.parentId);
                        if (parentNode.nodes) {
                            arry.push(parentNode);
                        } else {
                            break;
                        }
                    }
                    return arry;
                },
                closeOtherNode(node) {
                    var arry = [];
                    var p = this.getAllParentNode(node);
                },
                addNextNode(event, node) {},
                /**
                 * 展开某个节点
                 * @param {Object} event 事件源
                 */
                openNodes(event) {
                    let tree = $('#treeView');
                    let nodeid = $(event.target).attr('data-nodeid');
                    //获取当前节点对象
                    let node = tree.treeview('getNode', nodeid);
                    tree.treeview('expandNode', node.nodeId);
                },
                //清除当前选中new-selected-node class
                removeSeleClass() {
                    let allClassList = $('.new-node-selected');
                    for (let i of allClassList) {
                        $(i).removeClass('new-node-selected')
                    }
                },
                //设置当前背景色
                setItemBgc(node) {
                    $('.' + node.onlyId).addClass('new-node-selected')
                    //选中当前点击
                    node.state.selected = true;
                },
                
                //设置根节点背景色
                setRootNode(node) {
                    let tree = $('#treeView');
                    let parentNode = tree.treeview('getParent', node.nodeId);
                    if (node.root) {
                        $('.' + node.onlyId).addClass('new-node-selected')
                        return true
                    } else if (parentNode.root) {
                        // parentNode.state.selected = true;
                        $('.' + parentNode.onlyId).addClass('new-node-selected')
                        return true
                    } else {
                        this.setRootNode(parentNode)
                    }
                },
                //修改右边三角形状态
                itemRightIconType(itemTarget, itemNode) {
                    let itemDom = $(itemTarget.target).children('.fa')
                    if (itemNode.state.expanded) {
                        itemDom.removeClass('fa-angle-right')
                        itemDom.addClass('fa-angle-down')
                    } else {
                        itemDom.removeClass('fa-angle-down')
                        itemDom.addClass('fa-angle-right')
                    }
                },
                /**
                 * 收起某个节点
                 * @param {Object} event 事件源
                 */
                retractNodes(event) {
                    let tree = $('#treeView');
                    let nodeid = $(event.target).attr('data-nodeid');
                    //获取当前节点对象
                    let node = tree.treeview('getNode', nodeid);
                    tree.treeview('collapseNode', node.nodeId);
                },
                //实例化treeView
                exampleTreeView(treeViewParams) {
                    let that = this;
                    $('#treeView').treeview({
                        showCheckbox: true,
                        onNodeExpanded: that.addNextNode,
                        data: treeViewParams, // 树形菜单数据
                        emptyIcon: "icon-circle",
                        //enableLinks: false,
                        levels: 1, // 展开层级
                        //backColor: "transparent",// 背景
                        color: "black", // 文本颜色
                        // selectable: false,
                        selectedBackColor: "", // 选中时的背景色
                        selectedColor: '', //选中时的文本颜色
                        onhoverColor: "", // hover时的颜色
                        // showBorder: false,
                        expandIcon: 'fa fa-angle-right', // 展开图标
                        collapseIcon: 'fa fa-angle-down', // 收缩图标
                        onNodeSelected: function (target, data) { // 选中事件
                        },
                        onItemClick: function (target, data) {
                            let tree = $('#treeView');
                            let nodeid = $(target.target).attr('data-nodeid');
                            let node = tree.treeview('getNode', nodeid);
                            if (item.isDefaultSele) $("." + item.onlyId).addClass('selectedColor')
                            //节点添加或删除成功后在执行
                            if (that.isClick) {
                                //联系人不需要控制展开收起'
                                if (item.rootType != "KXY" && (item.rootType != "myMailList" || (item.rootType == "myMailList" && item.root) || (item.rootType == "distributionGroup" && item.root))) {
                                    that.isClick = false;
                                    node.state.expanded = !node.state.expanded;
                                }
                            
                                that.$emit('itemActive', item, target, function (res) {
                                    if (res != undefined) {
                                        tree.treeview("deleteChildrenNode", [item.nodeId, {
                                            node: res,
                                            silent: true
                                        }, false]);
                                        tree.treeview("addNode", [item.nodeId, {
                                            node: res,
                                            silent: true
                                        }, target.target, node]);
                                        if (item.rootType == 'distributionGroup') {
                                            res.forEach(obj => {
                                                let flag = $("li[class*='" + obj.id + "']")
                                                // 置顶
                                                if (obj.mainly && flag) {
                                                    flag[0].style.background = '#F4F3F3'
                                                    var child = document.createElement('div');
                                                    child.className = 'mainly-dot'
                                                    console.log(flag[0])
                                                    flag[0].appendChild(child);
                                                }
                                            })

                                        }
                                    } else {
                                        that.isClick = true;
                                    }
                                })
                            }
                            that.removeSeleClass()
                            that.setItemBgc(node)
                        },
                        nodeItemDialogClick: function (target, item) { //当前点击事件
                            let tree = $('#treeView');
                            let nodeid = $(target.target).attr('data-nodeid');
                            let node = tree.treeview('getNode', nodeid);
                            if (item.isDefaultSele) $("." + item.onlyId).addClass('selectedColor')
                            //节点添加或删除成功后在执行
                            if (that.isClick) {
                                //联系人不需要控制展开收起'
                                if (item.rootType != "KXY" && (item.rootType != "myMailList" || (item.rootType == "myMailList" && item.root) || (item.rootType == "distributionGroup" && item.root))) {
                                    that.isClick = false;
                                    node.state.expanded = !node.state.expanded;
                                }
                                if (item.rootType == "distributionGroup" && item.id == 'pinGroup' && item.nodes.length == 0) {
                                    that.isClick = true;
                                }
                                that.$emit('itemActive', item, target, function (res) {
                                    // tree.treeview("deleteChildrenNode", [item, { node: res,silent: true},false]);
                                    // tree.treeview("addNode", [item.nodeId, { node: res,silent: true},target.target,node]);
                                    if (res != undefined) {
                                        tree.treeview("deleteChildrenNode", [item.nodeId, {
                                            node: res,
                                            silent: true
                                        }, false]);
                                        tree.treeview("addNode", [item.nodeId, {
                                            node: res,
                                            silent: true
                                        }, target.target, node]);
                                        if (item.rootType == 'distributionGroup') {
                                            res.forEach(obj => {
                                                let flag = $("li[class*='" + obj.id + "']")
                                                // 置顶
                                                if (obj.mainly && flag) {
                                                    flag[0].style.background = '#F4F3F3'
                                                    var child = document.createElement('div');
                                                    child.className = 'mainly-dot'
                                                    console.log(flag[0])
                                                    flag[0].appendChild(child);
                                                }
                                            })

                                        }
                                    } else {
                                        that.isClick = true;
                                    }

                                })
                            }
                            that.removeSeleClass()
                            that.itemRightIconType(target, node)
                            that.setItemBgc(node);
                            that.setRootNode(node);
                        },
                        // 节点添加完成或者删除完成后通知
                        diaLogAddNodeSuccessCallBack: function () {
                            that.isClick = true
                        }
                    });
                    console.log(treeViewParams)
                    $('#treeView').treeview('expandNode', [0, {
                        levels: 0,
                        silent: false
                    }]);
                    $("#treeView").treeview('selectNode', [0, {
                        silent: false
                    }]); //默认选中
                    // if(treeViewParams[0] && treeViewParams[0].nodes && treeViewParams[0].nodes.length > 0) {
                    //   treeViewParams[0].nodes.forEach((element,index) => {
                    //     if(element.isDefaultSele) {
                    //       let tree = $('#treeView');
                    //       $("."+element.id).toArray()
                    //       ($("."+element.id)[0]);
                    //       console.log($("."+element.id).toArray());
                    //       console.log($("."+element.id)[0]);
                    //       console.log($("."+element.id)[0].attr("data-nodeid"));
                    //       // let node = tree.treeview('getNode', $("."+element.id).dataset.nodeid);
                    //       // console.log(node)
                    //       // that.$emit('itemActive',item,target)
                    //     }
                    //   });
                    // }
                }
            },
            destroyed: function () {}
        };
        utils.asyncComponent(options, resolve, reject);
    };
}(RongIM, null, RongIM.components));