(function (RongIM, dependencies, components) {
    'use strict';

    var common = RongIM.common;
    var utils = RongIM.utils;
    var $ = dependencies.jQuery;
    var dialog = RongIM.dialog;
    var dataModel = RongIM.dataModel;
    var orgApi = dataModel.Organization;
    var groupApi = dataModel.Group;
    var immediately = 'Immediately';

    RongIM.dialog.addContact = function (msg,callback) {
        var im = RongIM.instance;
        var enabledSms = im.serverConfig.sms.verification_state;
        var maxReceiverCount = im.serverConfig.pin.max_receiver_count;
        var options = {
            name: 'add-contact',
            template: '/templates/contact/add-contact.html',
            data: function () {
                return {
                    show: true,
                    contact: {
                        pinGroup_name: '',
                        receiver_ids: []
                    },
                    selectContractList: [],
                    isHas: false, //名称重复
                    hasTitle: '',
                    selectReceiverExpand:true,
                };
            },
            components: {
                avatar: components.getAvatar,

            },
            inject: ['reload'], //刷新页面不闪烁
            computed: {
                ifSent: function () {
                    return this.contact.pinGroup_name.trim() != '' && this.contact.receiver_ids.length > 0 && !this.isHas && this.contact.pinGroup_name.length < 16
                },
                 //是否显示超长提示
                 showErrorText: function () {
                    return this.contact.pinGroup_name.length > 15
                }
            },
            created: function () {

            },
            methods: getMethods(im,callback),
            watch: {
                "contact.pinGroup_name": {
                    handler: function () {
                        this.isHas = false
                    }
                }
            }
        };
        common.mountDialog(options);
    };

    function getMethods(im,callback) {
        return {
            close: function () {
                this.show = false;
            },
            toastError: function (errorCode) {
                common.toastError(errorCode, this.$el.firstChild);
            },
            selectContracts: function () {
                let _that = this
                dialog.pinDialogBox({
                    groupMembers: _that.contact.receiver_ids
                }, (tips, content) => {
                    let list = content
                    _that.contact.receiver_ids = _that.unique(list);
                });
            },
            unique(arr) {
                const res = new Map();
                return arr.filter((arr) => !res.has(arr.id) && res.set(arr.id, 1));
            },
            //创建通讯录
            async addPinGroup() {
                let that = this
                //校验为一项
                // let flag = await this.checkPinGroupName();
                groupApi.checkPinGroupName(this.contact.pinGroup_name, function (result) {
                    let param = {
                        pinGroup_name: that.contact.pinGroup_name,
                        receiver_ids: that.contact.receiver_ids.map(obj => {
                            return obj.id;
                        })
                    }
                    //没有重复
                    if (result == undefined) {
                        groupApi.createContact(param, function (errorCode, result) {
                            if (errorCode) {
                                that.toastError(errorCode);
                                return;
                            } else {
                                common.messagebox({
                                    message: '创建通讯组成功',
                                    callback: function () {
                                        that.close();
                                        callback(result)
                                    },
                                    closeCallback: function () {
                                        that.close();
                                    },
                                });
                            }

                        })
                    } else { //名称重复
                        that.isHas = true
                    }

                })
            }
        };
    }


}(RongIM, {
    jQuery: jQuery,
    UploadClient: UploadClient
}, RongIM.components));