(function (RongIM, dependencies, components) {
    'use strict';

    var utils = RongIM.utils;
    var dialog = RongIM.dialog;
    var common = RongIM.common;
    var fileApi = RongIM.dataModel.File;

    components.getContactDetail = function (resolve, reject) {
        var im = RongIM.instance;
        var dataModel = im.dataModel;
        var options = {
            name: 'contactDetail',
            template: 'templates/contact/contact-detail.html',
            props: ['contactDetail', 'memberList', 'fromTxz'],
            data: function () {
                return {
                    editName: false, //是否修改通讯组名称
                    detail: this.contactDetail,
                    receiverList: this.memberList,
                    plusTitle: this.fromTxz ? '修改组成员' : '增加接收人',
                    show: false
                };
            },
            components: {
                avatar: components.getAvatar
            },
            directives: {},
            computed: {

            },
            methods: getMethods(dataModel, im),
            created: function () {
                created(this, dataModel, im);
            },
            destroyed: function () {},
            watch: {
                'detail.mainly' () {
                    this.setPinGroup()
                },
                receiverList() {
                    this.setPinGroup()
                }
            }
        };
        utils.asyncComponent(options, resolve, reject);
    };

    function created(context, dataModel, im) {
        hidePanel(context, im);
    }

    function getMethods(dataModel, im) {
        var orgApi = dataModel.Organization;
        var groupApi = dataModel.Group;
        return {
            closeDetail() {
                this.$emit('closeDetail')
            },
            userProfile: function (userId) {
                var that = this;
                that.isClicking = true;
                dialog.user(userId, null,null,null,function (val,id) {
                    that.isClicking = false;
                    that.receiverList = that.receiverList.filter(obj=>obj.id != id)
                });
            },
            getUsername: function (pin) {
                return pin.name;
            },
            contactAvatar: function () {
                return this.detail.member;
            },
            setEdit: function () {
                this.editName = true;
                this.$nextTick((x) => { //正确写法
                    this.$refs.name.focus();
                })
            },
            unique(arr) {
                const res = new Map();
                return arr.filter((arr) => !res.has(arr.id) && res.set(arr.id, 1));
            },
            addReceivers: function () {
                let _that = this
                if (!_that.receiverList) {
                    return;
                }
                var defaultSelected = _that.receiverList
                dialog.pinDialogBox({
                    groupMembers: this.receiverList,
                    isTxz:true
                }, (tips, content) => {
                    let list = content
                    _that.receiverList = _that.unique(list);
                    _that.setPinGroup()
                });
                // dialog.addReceivers(defaultSelected, this);
                // dialog.addReceiversDialog(defaultSelected, this);
            },
            close: function () {
                this.show = false;
            },
            //设置通讯组
            setPinGroup: function () {
                let that = this;
                let param = {
                    pinGroup_uid: that.detail.id,
                    pinGroup_name: that.detail.name,
                    mainly: that.detail.mainly ? 1 : 0,
                    receiver_ids: that.receiverList.map(obj => obj.id)
                }
                if (that.detail.name == '') {
                    common.messagebox({
                        message: '名称不能为空',
                        callback: function () {
                            that.close();
                            that.$refs.name.focus()
                        },
                        closeCallback: function () {
                            that.close();
                        },
                    });
                    return;
                }
                if (that.detail.name.length > 15) {
                    common.messagebox({
                        message: '名称过长，最多为15个字',
                        callback: function () {
                            that.close();
                            that.$refs.name.focus()
                        },
                        closeCallback: function () {
                            that.close();
                        },
                    });
                    return;
                }
                orgApi.setPinGroup(param, function (errorcode, result) {
                    if (errorcode) {
                        common.toastError(errorCode);
                        return;
                    } else {
                        that.editName = false;
                        that.$emit('changeGroup', that.detail.name + "("+that.receiverList.length+"人)")
                    }
                })
            },
            //删除当前通讯组
            deletePinGroup: function () {
                let that = this;
                common.messagebox({
                    message: '确定要删除通讯组‘' + that.detail.name + '’吗？',
                    type: 'confirm',
                    callback: function () {
                        orgApi.deletePinGroup(that.detail.id, function (errorCode, result) {
                            if (errorCode) {
                                return;
                            }
                            that.$emit('delete-pin-group')
                            common.messageToast({
                                type: 'success',
                                message: "删除成功"
                            });
                            // that.$emit('changeGroup',that.detail.name)
                        })
                    }
                });
            },
              // 打开删除群成员面板
            removeMembers: function () {
                let that = this;
                dialog.groupRemoveMembers(that.detail.id,true,that.receiverList,function(content){
                    let list = content
                    that.receiverList = common.without(that.receiverList,list)
                   
                    that.setPinGroup()
                });
            },
        };
    }

    function hidePanel(context, im) {
        im.$on('imclick', function (event) {
            var $target = $(event.target);
            var wrap = '.rong-pin-detail, .rong-pin-item, .rong-dialog';
            var inBody = $target.closest('body').length > 0;
            var inWrap = $target.closest(wrap).length < 1;
            var isOuter = inBody && inWrap;
            if (isOuter) context.$emit('hidepanel');
        });
    }

}(RongIM, {
    jQuery: jQuery
}, RongIM.components));