(function (RongIM, dependencies, components) {
'use strict';

var utils = RongIM.utils;
var dialog = RongIM.dialog;
var common = RongIM.common;
var $ = dependencies.jQuery;
var pageNum = RongIM.config.profile.pageNum;

function getOrg(resolve, reject) {
    var im = RongIM.instance;
    var orgApi = im.dataModel.Organization;
    var options = {
        name: 'contact-org',
        template: 'templates/contact/org.html',
        data: function () {
            return {
                deptName: '',
                company: {},
                breadcrumb: [],
                allMembers: [],
                allDepts: [],
                allCompanies: [],
                loadingNextPage: false,
                lastIndex: 0,
                allList: []
            };
        },
        computed: {
            coId: function () {
                var coId = this.$route.params.coId;
                return coId;
            },
            orgId: function () {
                var coId = this.$route.params.coId;
                var orgId = this.$route.params.orgId;
                return orgId || coId;
            },
            type: function () {
                var coType = common.OrgType.COMPANY;
                var orgType = +this.$route.params.type;
                return orgType || coType;
            },
            members: function () {
                if (this.allMembers.length < this.lastIndex) {
                    return this.allMembers;
                }
                return this.allMembers.slice(0, this.lastIndex);
            },
            depts: function () {
                var length = this.allMembers.length + this.allDepts.length;
                if (this.lastIndex < this.allMembers.length) {
                    return [];
                } if (this.lastIndex > this.allMembers.length && this.lastIndex < length) {
                    return this.allDepts.slice(0, this.lastIndex - this.allMembers.length);
                }
                return this.allDepts;
            },
            companies: function () {
                var _length = this.allMembers.length + this.allDepts.length;
                if (this.lastIndex < _length) {
                    return [];
                }
                return this.allCompanies.slice(0, this.lastIndex - _length);
            }
        },
        mounted: function () {
            var context = this;
            initData(context, orgApi);

            context.deptWatch = function () {
                // getDept(context, orgApi);
            };
            orgApi.watch(context.deptWatch);
        },
        watch: {
            $route: function () {
                initData(this, orgApi);
            }
        },
        methods: {
            userProfile: dialog.user,
            getUsername: common.getUsername,
            getRoute: getRoute,
            getTypeName: common.getGroupType,
            departIconClass: function(item) {
                return (item.vchar_p3 == 1) ? 'rong-dept-blue-icon' : 'rong-dept-icon';
            },
            getDutyName: function (item) {
                return (item.extDuties && this.orgId) ? item.extDuties[this.orgId] : item.dutyName;
            },
            memberCount: function (item) {
                var format = this.locale.contact.person;
                if (item.member_count === 1) {
                    format = this.locale.contact.personSingle;
                }
                return this.localeFormat(format, item.member_count);
            },
            isAutonomyCompany: function (item) {
                return orgApi.isAutonomyCompany(item.id);
            },
            loadMore: function () {
                loadMore(this);
            }
        },
        components: {
            avatar: components.getAvatar
        },
        destroy: function () {
            orgApi.unwatch(this.deptWatch);
        }
    };
    utils.asyncComponent(options, resolve, reject);
}

function getOrgBranch(uid, orgApi, callback) {
    orgApi.getBranch(uid, function (errorCode, result) {
        if (errorCode) {
            common.toastError(errorCode);
            return;
        }
        callback(result);
    });
}

/*
说明：路由改变时，组件加载时，根据路由参数，组织机构 id 和类型 (orgId, type) 初始化页面数据
    context.members = [];       成员列表
    context.depts = [];         部门列表
    context.companies = [];     公司列表
    context.breadcrumb = [];    面包屑导航
    context.company = {};       当前公司，如果在独立子公司下则显示独立子公司
    context.deptName = '';      当前部门名称
*/
function initData(context, orgApi) {
    var orgId = context.orgId;
    context.allMembers = [];
    context.allDepts = [];
    context.allCompanies = [];
    context.breadcrumb = [];
    context.company = {};
    context.deptName = '';

    // 获取当前组织机构的直属子节点
    getOrgBranch(orgId, orgApi, function (data) {
        context.allMembers = data.staffs;
        context.allDepts = data.depts;
        context.allCompanies = data.companies.filter(function (co) {
            return !orgApi.isAutonomyCompany(co.id);
        });
        var _callback = function () {
            // 获取所有list的总和
            context.allList = context.allMembers.concat(context.allDepts).concat(context.allCompanies);
            context.lastIndex = context.allList.length > pageNum ? pageNum : context.allList.length;
        };
        /*
        获取部门 path 和公司信息 如果有 独立子部门直接显示独立子部门
        */
        var orgTree = orgApi.getLocalDept(orgId);
        var pathList = orgTree.pathList || [];
        var autonomy = pathList[1];
        if (autonomy && orgApi.isAutonomyCompany(autonomy.id)) {
            pathList.shift();
        }
        // 根据类型 type 获取公司或部门信息
        if (context.type === common.OrgType.COMPANY) {
            orgApi.getCompanyById(orgId, function(err, company) {
                if (orgApi.isAutonomyCompany(orgId)) {
                    pathList = [];
                    context.company = company;
                } else {
                    context.company = pathList[0] || company;
                }
                context.deptName = company.name;
                _callback();
            });
        } else if (context.type === common.OrgType.DEPT) {
            context.company = pathList[0] || { name: '' };
            orgApi.getDept(orgId, function (errorCode, dept) {
                context.deptName = dept.deptName;
                _callback();
            }, true);
        }
        context.breadcrumb = pathList;
    });
}

function getRoute(item) {
    var coId = this.coId;
    return {
        name: 'organization',
        params: {
            coId: coId,
            orgId: item.id,
            type: item.type
        }
    };
}

function loadMore(context) {
    context.loadingNextPage = true;
    var totalNum = context.allList.length;
    var end = context.lastIndex + pageNum;
    var adjust = function (index) {
        return index > totalNum ? totalNum : index;
    };
    end = adjust(end);
    if (end === context.lastIndex) {
        context.loadingNextPage = false;
        return;
    }
    setTimeout(function () {
        context.lastIndex = end;
        context.loadingNextPage = false;
    }, 500);
}

$.extend(true, components, {
    contact: {
        getOrg: getOrg
    }
});
}(RongIM, {
    jQuery: jQuery
}, RongIM.components));
