(function (RongIM, components) {
'use strict';

var common = RongIM.common;
/*
说明： 选择用户信息发送已选用户名片消息
参数：
    @param {string} targetUserId 排除当前用户 id (单聊发送名片时不显示对方的名片)
*/
RongIM.dialog.card = function (targetUserId) {
    var im = RongIM.instance;
    var dataModel = im.dataModel;
    var options = {
        name: 'card',
        template: 'templates/conversation/card.html',
        data: function () {
            var canNotSelected = [];
            if (targetUserId) {
                canNotSelected = [{
                    id: targetUserId
                }];
            }
            return {
                show: true,

                // 'star' or 'org'
                tab: 'org',
                tip: '',
                selected: [],
                onlyStaff: true,
                canNotSelected: canNotSelected,
                isStaff: im.auth.isStaff
            };
        },
        components: {
            avatar: components.getAvatar,
            star: components.group.getStar,
            org: components.group.getOrg,
            friend: components.group.getFriend
        },
        watch: {
            selected: function (newValue, oldValue) {
                limitCount(this, newValue, oldValue);
            }
        },
        created: function () {
            // 登录用户非组织机构人员默认显示 'friend' 面板
            if (!this.isStaff) {
                this.tab = 'friend';
            }
        },
        methods: getMethods(dataModel, im)
    };

    common.mountDialog(options);
};

/*
说明： 限制选择成员个数
*/
function limitCount(context, newValue, oldValue) {
    // 最多选择成员个数
    var MAX = 1;
    // 已选择成员个数
    var length = context.selected.length;
    if (length > MAX) {
        context.$nextTick(function () {
            context.selected = oldValue;
        });
        // tip 错误提示
        clearTimeout(limitCount.timer);
        context.tip = common.getErrorMessage('card-limit');
        limitCount.timer = setTimeout(function () {
            context.tip = '';
            context.selected = oldValue;
        }, 1500);
    }
}

function getMethods(dataModel, im) {
    return {
        close: function () {
            this.show = false;
        },
        setTab: function (tab) {
            this.tab = tab;
        },
        removeMembers: function (members) {
            members = [].concat(members);
            var idList = members.map(function (item) {
                return item.id;
            });
            this.selected = this.selected.filter(function (item) {
                return idList.indexOf(item.id) < 0;
            });
        },
        added: function (members) {
            var selectedIdList = this.selected.map(function (item) {
                return item.id;
            });
            var addedList = members.filter(function (item) {
                return selectedIdList.indexOf(item.id) < 0;
            });
            this.selected = this.selected.concat(addedList);
        },
        removed: function (members) {
            var idList = members.map(function (item) {
                return item.id;
            });
            this.selected = this.selected.filter(function (item) {
                return idList.indexOf(item.id) < 0;
            });
        },
        getUsername: common.getUsername,
        submit: function () {
            var routeParams = im.$route.params;
            var conversationType = parseInt(routeParams.conversationType);
            var targetId = routeParams.targetId;
            // 已选用户信息，名片只允许选择 1 个取数组第一个即可
            var user = this.selected[0];
            var params = {
                conversationType: conversationType,
                targetId: targetId,
                user: {
                    userId: user.id,
                    name: user.name,
                    portraitUri: user.avatar,
                    sendUserId: im.loginUser.id,
                    sendUserName: im.loginUser.name,
                    extra: '',
                    type: user.type
                }
            };
            sendCardMessage(dataModel.Message, params);
            this.close();
        }
    };
}
/*
说明： 发送名片消息
*/
function sendCardMessage(messageApi, params) {
    if (sendCardMessage.busy) {
        return;
    }
    sendCardMessage.busy = true;
    messageApi.sendCard(params, function (errorCode) {
        sendCardMessage.busy = false;
        if (errorCode) {
            common.toastError(errorCode);
        }
    });
}
}(RongIM, RongIM.components));
