/**
TODO:
    1、更新contextmenu中context的命名
    2、完善conversation数据模型,增加conversationId、isGroup、isPrivate等
    3、lastIndex优化
* */
(function (RongIM, dependencies, components) {
'use strict';

var common = RongIM.common;
var utils = RongIM.utils;
var $ = dependencies.jQuery;
var browserWindow = RongIM.browserWindow;
var dataModel = RongIM.dataModel;
var conversationAPI = dataModel.Conversation;
// 会话列表每页加载个数
var pageNum = RongIM.config.conversationList.pageNum;
var RemoteControlStatus = common.RemoteControlStatus;
var RemoteControlHangupReason = common.RemoteControlHangupReason;

/*
说明： 会话列表 getConversationList ， 会话列表右键菜单 getContextMenu
*/
components.getConversationList = function (resolve, reject) {
    var im = RongIM.instance;
    var options = {
        name: 'conversation-list',
        template: '#rong-template-conversation-list',
        data: function () {
            var params = im.$route.params;
            return {
                busy: true,
                auth: im.auth,
                conversation: {
                    conversationType: params.conversationType,
                    targetId: params.targetId
                },
                list: [],
                hasMore: true,
                listBusy: {},
                bound: {
                    width: {
                        min: 0,
                        max: 0
                    }
                },
                isResizing: false,
                // 当前会话列表最后一条的索引值
                lastIndex: 0,
                loadingNextPage: false,
                isFirst: true
            };
        },
        mounted: function () {
            var conversationList = this;
            // 收到消息时更新会话列表,延时500ms,页面平滑过渡 （最后一条消息，未读数）
            var messagechanged = utils.debounce(function () {
                pageRefresh(conversationList);
            }, 500);
            im.$on('messagechange', messagechanged);
            // 会话列表改变时更新到页面。
            conversationList.watch = function (list) {
                pageRefresh(conversationList, list);
            };
            // 监听会话列表改变
            conversationAPI.watch(conversationList.watch);
            // 初始化会话列表获取第一页
            conversationList.getInit();
            // 会话列表可拖拽（增加拖拽事件）
            common.resizeNavNode(conversationList, im);
            // 搜索会话跳转时，加载并滚动到指定会话
            im.$on('loadSearch', function (index) {
                index += 1;
                if (index > conversationList.lastIndex) {
                    conversationList.lastIndex = index;
                    pageRefresh(conversationList);
                }
            });
            // 发送消息时滚动到最 "顶部"
            im.$on('sendMessage', function () {
                scrollToTop($(conversationList.$refs.list));
            });

            // 文件上传时监听同步文件的状态
            im.$on('uploadStatusChange', function (message, status) {
                // 找到消息,改变状态
                var list = conversationList.list;
                for (var i = 0; i < list.length; i += 1) {
                    var item = list[i];
                    if (item.conversationType === message.conversationType
                        && item.targetId === message.targetId
                    ) {
                        var latestMessage = item.latestMessage;
                        if (latestMessage.messageId !== message.messageId) {
                            break;
                        }
                        // TODO: 代码需优化，暂时没找到更好的方法同步会话列表发送状态
                        latestMessage.content.status = status;
                        if (status === 1) {
                            latestMessage.sentStatus = RongIM.utils.sentStatus.SENDING;
                        }
                        break;
                    }
                }
            });
        },
        created: function () {
            var conversationList = this;
            // 注册 "Ctrl + F" 搜索快捷键事件
            im.client.regSearch(function () {
                var searchBox = conversationList.$refs.searchBox;
                if (searchBox) {
                    searchBox.focus();
                }
            });

            // 设置公众号信息监听
            browserWindow.enterPublic(im.$router, function (router, app) {
                var params = {
                    conversationType: utils.conversationType.APP_PUBLIC_SERVICE,
                    targetId: app.id
                };
                router.push({
                    name: 'conversation',
                    params: params
                });
                conversationAPI.add(params);
                var itemId = ['conversation', params.conversationType, params.targetId].join('-');
                var item = document.getElementById(itemId);
                if (item) {
                    var parentHeight = item.parentNode.offsetHeight;
                    var offsetTop = item.offsetTop;
                    var alginWithTop = offsetTop > parentHeight;
                    item.scrollIntoView(alginWithTop);
                }
            });
        },
        destroyed: function () {
            conversationAPI.unwatch(this.watch);
            // 删除监听 "Ctrl + F" 搜索快捷键事件
            im.client.unregSearch();
        },
        computed: {
            status: function () {
                return im.status;
            },
            width: function () {
                // 会话列表的宽度
                var node = im.resizeNode.rongList;
                return node.width;
            },
            resizeDirection: function () {
                // 当前可拖动的方向
                return im.resizeDirection.use;
            }
        },
        watch: {
            status: function () {
                // 页面刷新时等待连接成功再获取会话列表
                this.getInit();
            },
            $route: function (route) {
                console.log("***********************************")
                var params = route.params;
                this.conversation = {
                    conversationType: params.conversationType,
                    targetId: params.targetId
                };
                // 绑定拖动方法
                common.resizeNavNode(this, im);
            }
        },
        mixins: [getContextMenu()],
        components: {
            search: components.getSearch,
            'latest-message': components.getLatestMessage,
            avatar: components.getAvatar
        },
        methods: getMethods(im)
    };
    utils.asyncComponent(options, resolve, reject);
};

/**
会话列表右键菜单
与context-menu.js混合应用
context为showContextmenu()方法中传入的第二个参数
* */
function getContextMenu() {
    var options = {
        template: '#rong-template-conversation-contextmenu',
        computed: {
            isTop: function () {
                return this.context.conversation.isTop;
            },
            isMute: function () {
                return this.context.conversation.notificationStatus;
            }
        },
        methods: {
            top: function () {
                this.$emit('top', this.context.conversation);
            },
            untop: function () {
                this.$emit('untop', this.context.conversation);
            },
            mute: function () {
                this.$emit('mute', this.context.conversation);
            },
            unmute: function () {
                this.$emit('unmute', this.context.conversation);
            },
            remove: function () {
                this.$emit('remove', this.context.conversation);
            },
            close: function () {
                this.$emit('close');
            }
        }
    };
    return components.getContextMenu(options);
}

function getMethods(im) {
    return {
        /**
         * 修改会话列表
         * @param {Array} arrConversation 会话列表内容
         */
        setList: function (arrConversation) {
            var idCount = {};
            // console.debug(`arrConversation.length => ${arrConversation.length}`)
            var tmpList = arrConversation.filter(function (item) {
                var id = 'conversation-' + item.conversationType + '-' + item.targetId;
                var count = idCount[id] = (idCount[id] || 0) + 1;
                if (count > 1) {
                    RongIM.system.appLogger('error', new Error('multiple conversation id: ' + id).stack);
                    return false;
                }
                var key = item.conversationType + item.targetId;
                item.viewId = id;
                item.viewKey = key;
                return true;
            });
            this.list = tmpList;
        },
        // 绘制 UI 使用， 获取会话列表最后一条消息时间的字符串在页面渲染的宽度（为保证会话名称最大长度展示）
        getTimeRenderWidth: function (item) {
            var fontSize = 12;
            var timeString = this.dateFormat(item.latestMessage.sentTime);
            return common.getTextRenderWidth(timeString, fontSize);
        },
        getHtmlUsername: common.getHtmlUsername,
        getHtmlGroupName: common.getHtmlGroupName,
        getUsername: common.getUsername,
        getGroupUsername: common.getGroupUsername,
        getHtmlGroupUsername: common.getHtmlGroupUsername,
        getGroupName: common.getGroupName,
        getGroupType: common.getGroupType,
        dateFormat: utils.dateFormat,
        scroll: function () {
            // 滚动的时候搜索框失去焦点
            im.$emit('searchBlur');
        },
        getInit: function () {
            // 初始化会话列表，获取第一页
            var conversationList = this;
            if (conversationList.status === utils.status.CONNECTED) {
                conversationList.busy = true;
                conversationAPI.getInitList(pageNum, function (errorCode, list) {
                    if (errorCode) {
                        common.toastError(errorCode);
                        return;
                    }
                    // 仅当有数据时再更新会话列表
                    if (list.length > 0) {
                        conversationList.setList(list);
                        conversationList.lastIndex = list.length > pageNum ? list.length : pageNum;
                    }
                    conversationList.busy = false;
                });
            }
        },
        get: function () {
            var conversationList = this;
            if (conversationList.status === utils.status.CONNECTED) {
                conversationList.busy = true;
                conversationAPI.getList(function (errorCode, list) {
                    if (errorCode) {
                        common.toastError(errorCode);
                        return;
                    }
                    // 仅当有数据时再更新会话列表
                    if (list.length > 0) {
                        conversationList.allList = list;
                    }
                    if (conversationList.lastIndex === 0) {
                        var totalNum = conversationList.allList.length + 1;
                        conversationList.lastIndex = totalNum > pageNum ? pageNum : totalNum;
                    }
                    conversationList.busy = false;
                });
            }
        },
        // 最后一条消息展示样式
        isRichText: function (message) {
            if (message.messageType !== 'TextMessage') {
                return false;
            }
            var textContent = message.content.content;
            var content = common.convertMessage(textContent);
            return textContent !== content;
        },
        isFailed: function (message) {
            return message.sentStatus === utils.sentStatus.FAILED;
        },
        isSending: function (message) {
            return message.sentStatus === utils.sentStatus.SENDING;
        },
        isCanceled: function (message) {
            return common.isCanceled(message);
        },
        // 是否是无效消息,比如历史消息全部删除后会有一条 messageId=-1 的消息
        isInvalid: function (message) {
            return message.messageId === -1;
        },
        isPrivate: function (item) {
            return item.conversationType === 1 || item.conversationType === 7;
        },
        isGroup: function (item) {
            return item.conversationType === 3 && item.group;
        },
        isEqual: sameConversaton,
        isShowGroupType: function (group) {
            return group && +group.type !== 0;
        },
        getMessageType: function (message) {
            return (message.messageType || '').toLowerCase();
        },
        isFromMe: function (message) {
            return message.messageDirection === 1;
        },
        getSentStatus: function (message) {
            var sentStatus = utils.sentStatus[message.sentStatus] || '';
            return sentStatus.toLowerCase();
        },
        getRecievedStatus: function (message) {
            var status = utils.receivedStatus[message.receivedStatus] || '';
            return status.toLowerCase();
        },
        // 消息状态 "已读" "未读"
        isOtherRead: function (message) {
      
                if (utils.isEmpty(message.sentStatus)) {
                    // web 不支持存储消息状态默认置为已读
                    message.sentStatus = utils.sentStatus.READ;
                }
                return message.sentStatus === utils.sentStatus.READ;
          
           
        },
        // 是否显示消息状态："已读" "未读"
        showSentStatus: function (message, conversation) {
            if (message.senderUserId !==message.targetId) { 
                var isPrivate = this.isPrivate(message);
                var isFromMe = this.isFromMe(message);
                var messageTypes = [
                    utils.messageType.TextMessage,
                    utils.messageType.ImageMessage,
                    utils.messageType.FileMessage,
                    utils.messageType.VoiceMessage,
                    utils.messageType.CardMessage,
                    utils.messageType.LocationMessage,
                    utils.messageType.ReferenceMessage
                ];
                var existed = messageTypes.indexOf(message.messageType) >= 0;
                var user = conversation.user;
                var isNotFileHelper = user && user.type !== 3;
                var isPublic = message.conversationType === 7;
                return isPrivate && isFromMe && existed && isNotFileHelper && !isPublic;
             }else{
                return false
            }
        
        },
        top: function (conversation) {
            var conversationList = this;
            var conversationType = conversation.conversationType;
            var targetId = conversation.targetId;
            var key = conversationType + '_' + targetId;
            if (conversationList.listBusy[key]) {
                conversationList.closeContextmenu();
                return;
            }
            conversationList.listBusy[key] = true;
            conversationAPI.top(conversationType, targetId, function () {
                conversationList.listBusy[key] = false;
            });
            conversationList.closeContextmenu();
        },
        untop: function (conversation) {
            var conversationType = conversation.conversationType;
            var targetId = conversation.targetId;
            conversationAPI.untop(conversationType, targetId);
            this.closeContextmenu();
        },
        mute: function (conversation) {
            var conversationType = conversation.conversationType;
            var targetId = conversation.targetId;
            conversationAPI.mute(conversationType, targetId);
            this.closeContextmenu();
        },
        unmute: function (conversation) {
            var conversationType = conversation.conversationType;
            var targetId = conversation.targetId;
            conversationAPI.unmute(conversationType, targetId);
            this.closeContextmenu();
        },
        remove: function (conversation) {
            var conversationList = this;
            var conversationType = conversation.conversationType;
            var targetId = conversation.targetId;
            var removeFuc = function () {
                conversationAPI.remove(conversationType, targetId);
                conversationList.closeContextmenu();
                // 删除的是当前会话则跳转到"主页"
                var params = conversationList.$route.params;
                if (common.sameConversaton(params, conversation)) {
                    conversationList.$router.push({
                        name: 'conversation',
                        query: {
                            force: 1
                        }
                    });
                }
            };
            checkRemoteControlWhenRemove(conversation, removeFuc, this);
        },
        showConversaton: function (conversation) {
            var conversationType = conversation.conversationType;
            var targetId = conversation.targetId;
            if (conversation.unreadMessageCount > 0) {
                conversationAPI.clearUnReadCount(conversationType, targetId);
            }
            // im.$emit('conversationchange', conversation);
            this.$router.push({
                name: 'conversation',
                params: {
                    targetId: targetId,
                    conversationType: conversationType
                }
            });
            this.conversation = conversation;
          
        },
        convertMessage: common.convertMessage,
        isShowName: function (conversation) {
            return isShowName(this.auth.id, conversation);
        },
        // 判断 '@' 消息中是否包含自己
        mentionMsgHasSelf: function (conversation) {
            var mentionMsg = conversation.mentionedMsg;

            // 判读这条@消息是谁发的如果是自己发的则不显示，暂用有无未读消息
            var hasUnRead = conversation.unreadMessageCount !== 0;
            if ($.isEmptyObject(mentionMsg)) {
                return false;
            }

            if (mentionMsg.mentionedInfo.type === utils.mentionedType.ALL) {
                return hasUnRead;
            }
            var userIdList = mentionMsg.mentionedInfo.userIdList;
            return userIdList.indexOf(im.auth.id) !== -1 && hasUnRead;
        },
        getId: function (conversation) {
            var items = ['conversation', conversation.conversationType, conversation.targetId];
            return items.join('-');
        },
        // 文字最后是emoji, 且在mac 非高清屏下, emoji 会被覆盖一部分
        // 原因: chrome对emoji的渲染造成的. 解决: 判断, 加padding-right
        isCoverName: function (text) {
            var RongIMEmoji = RongIMLib.RongIMEmoji;
            var nativeTagReg = RongIMEmoji.emojiNativeReg;
            var emojis = text ? text.match(nativeTagReg) : text;
            var notIncludeEmoji = !emojis || !emojis.length;
            if (notIncludeEmoji || !utils.isEmojiOverlap()) {
                return false;
            }
            var matchContent = emojis[emojis.length - 1];
            var index = text.lastIndexOf(matchContent);
            return matchContent.length + index === text.length;
        },
        isGroupNameCover: function (text) {
            var name = this.getGroupName(text);
            return this.isCoverName(name);
        },
        isUserNameCover: function (text) {
            var name = this.getUsername(text);
            return this.isCoverName(name);
        },
        // 获取拖拽方向
        getResizeDirection: function () {
            var direction = common.getResizeDirection({
                range: this.width,
                bound: this.bound.width,
                directions: ['left', 'right']
            });
            if (this.isResizing) {
                im.resizeDirection.temp = direction;
            }
            return direction;
        },
        loadMore: function () {
            loadMore(this);
        }
    };
}

// 当删除会话时, 提示是否关闭远程控制
function checkRemoteControlWhenRemove(conversation, confirm, conversationList) {
    var remoteApi = RongIM.dataModel.RemoteControl;
    var targetId = conversation.targetId;
    var remote = remoteApi.get(targetId);
    var remoteStatus = remote.status;
    if (remoteStatus && remoteStatus !== RemoteControlStatus.Idle) {
        conversationList.closeContextmenu();
        common.messagebox({
            message: '如果删除, 将会终止远程桌面. 是否删除',
            type: 'confirm',
            callback: function () {
                var reason = getRemoteHangupReason(remote);
                var sessionId = remote.message.content.sessionId;
                var remoteWindowHandler = browserWindow.remoteWindowHandler;
                remoteWindowHandler.restore();
                browserWindow.closeRemoteControl();
                remoteApi.hangup(conversation, sessionId, reason);
                confirm();
            }
        });
    } else {
        confirm();
    }
}

function getRemoteHangupReason(remote) {
    var reason = RemoteControlHangupReason.Hangup;
    var status = remote.status;
    var cancelStatus = [RemoteControlStatus.Request, RemoteControlStatus.Invite];
    var declineStatus = [RemoteControlStatus.ReceiveRequest, RemoteControlStatus.ReceiveInvite];
    if (cancelStatus.indexOf(status) !== -1) {
        reason = RemoteControlHangupReason.Cancel;
    } else if (declineStatus.indexOf(status) !== -1) {
        reason = RemoteControlHangupReason.Reject;
    }
    return reason;
}

function sameConversaton(one, another) {
    var oneConversationType = +one.conversationType;
    var anotherConversationType = +another.conversationType;
    var sameConversationType = oneConversationType === anotherConversationType;
    var sameTargetId = one.targetId === another.targetId;
    return sameConversationType && sameTargetId;
}

function isShowName(authId, conversation) {
    var groupType = utils.conversationType.GROUP;
    var isGroup = conversation.conversationType === groupType;

    // SDK消息未解析 messageType 为 undefined 此处要判断
    var isNotificationMessage = true;
    var notNotificationMessages = [
        'InformationNotificationMessage',
        'JrmfRedPacketOpenedMessage',
        'JrmfRedPacketMessage',
        'GroupMemChangedNotifyMessage',
        'GroupNotifyMessage',
        'GroupCmdMessage'
    ];
    var messageType = conversation.latestMessage.messageType;
    if (!utils.isEmpty(messageType)) {
        isNotificationMessage = notNotificationMessages.indexOf(messageType) !== -1;
    }
    var user = conversation.latestMessage.user || {};
    var isOther = authId !== user.id;
    var username = !utils.isEmpty(common.getUsername(user));
    var notReCall = messageType !== 'RecallCommandMessage';
    var isShow = isGroup && !isNotificationMessage && isOther && username && notReCall;
    return isShow;
}

function scrollToTop(listContent) {
    listContent.scrollTop(0);
}

// 根据 lastIndex: 显示条数 更新会话列表 isMore: 是否加载更多
function pageRefresh(context, list, isMore) {
    var end = context.lastIndex || pageNum;
    if (list) {
        context.setList(list);
        context.lastIndex = list.length > pageNum ? list.length : pageNum;
        return;
    }
    conversationAPI.getInitList(end, function (errorCode, conversationList) {
        if (errorCode) {
            common.toastError(errorCode);
            return;
        }
        setTimeout(function () {
            context.loadingNextPage = false;
            // 仅当有数据时再更新会话列表
            if (conversationList.length > 0) {
                context.setList(conversationList);
            }
            if (conversationList.length < end && isMore) {
                context.hasMore = false;
            }
        }, 1000);
    });
}

// 分页加载会话列表获取下一页
function loadMore(conversationList) {
    if (!conversationList.isFirst && !conversationList.hasMore) {
        return;
    }
    if (conversationList.loadingNextPage) {
        return;
    }
    conversationList.isFirst = false;
    conversationList.loadingNextPage = true;
    var end = conversationList.lastIndex + pageNum;
    conversationList.lastIndex = end;
    pageRefresh(conversationList, null, true);
}
}(RongIM, {
    jQuery: jQuery
}, RongIM.components));
