/*
说明： emoji 选择面板
       支持显示 emoji 原生字符时返回原生字符 否则返回 emoji 对应文字标记字符 e.g. [微笑]
*/
(function (RongIM, dependencies, components) {
'use strict';

var utils = RongIM.utils;
var $ = dependencies.jQuery;
var RongIMEmoji = dependencies.RongIMLib.RongIMEmoji;
var common = RongIM.common;

components.getEmojiPanel = function (resolve, reject) {
    var timer;
    var options = {
        name: 'emoji-panel',
        template: '#rong-template-emoji-panel',
        data: function () {
            return {
                list: []
            };
        },
        mounted: function () {
            this.list = getEmojiList();
        },
        computed: {
            // 如果是 Mac 则显示 emoji 字符
            isShowEmojiSymbol: function () {
                var platform = RongIM.system.platform;
                var hasOSMark = platform.indexOf('darwin') !== -1;
                return hasOSMark && RongIMEmoji.isSupportEmoji;
            }
        },
        methods: {
            show: function () {
                clearTimeout(timer);
            },
            // hide: function () {
            //     var context = this;
            //     timer = setTimeout(function () {
            //         context.$emit('hideEmojiPanel');
            //     }, 200);
            // },
            selectEmoji: function (emoji) {
                var output;
                // 支持显示 emoji 字符则返回 emoji 字符
                if (RongIMEmoji.isSupportEmoji) {
                    // 在 Mac 非高分屏 Chrome 浏览器下, emoji 会出现与文字重叠现象。拼接空格避免重叠
                    var mark = utils.isEmojiOverlap() ? ' ' : '';
                    output = emoji.emoji + mark;
                } else {
                    output = emoji.symbol;
                }
                this.$emit('selectedEmoji', output);
                this.$emit('hideEmojiPanel');
            }
        },
        watch: {
            locale: function () {
                this.list = RongIMEmoji.list;
            }
        },
        destroyed: function () {
            $(window).off('click.emojiPanel');
        }
    };
    utils.asyncComponent(options, resolve, reject);
};

function getEmojiList() {
    var list = [];
    var hasEmojiUrl = RongIM.client.getEmojiUrl;
    var platform = RongIM.system.platform;
    var isInMac = platform.indexOf('darwin') !== -1;
    list = RongIMEmoji.list;
    if (isInMac || !hasEmojiUrl) {
        return list;
    }
    list.forEach(function (item) {
        var html = common.emojiConvertHTML(item.emoji);
        var div = document.createElement('div');
        div.innerHTML = html;
        item.node = div.childNodes[0];
    });
    return list;
}
}(RongIM, {
    jQuery: jQuery,
    RongIMLib: RongIMLib
}, RongIM.components));
