(function (RongIM, dependencies, components) {
'use strict';

// 选人下拉菜单组件
components.customSelect = function (resolve, reject) {
    var utils = RongIM.utils;
    var im = RongIM.instance;
    var options = {
        name: 'custom-select',
        template: '../../templates/custom-select.html',
        data: function () {
            return {
                isShowOption: false
            };
        },
        props: {
            owner: im,
            value: {
                type: String,
                required: true
            },
            list: {
                type: Array,
                required: true
            },
            valueKey: {
                type: String,
                default: 'value'
            },
            nameKey: {
                type: String,
                default: 'name'
            }
        },
        mounted: function () {
            var context = this;
            context.hideOption = function () {
                context.isShowOption = false;
            };
            if (this.owner) {
                this.owner.$on('imclick', context.hideOption);
            }
        },
        methods: {
            toggleOption: function () {
                this.isShowOption = !this.isShowOption;
            },
            getItemName: function (item) {
                return item[this.nameKey];
            },
            getItemValue: function (item) {
                return item[this.valueKey];
            },
            getSelected: function (value) {
                var context = this;
                var item = {};
                this.list.forEach(function (i) {
                    if (context.getItemValue(i) === value) {
                        item = i;
                    }
                });
                return context.getItemName(item);
            },
            select: function (item) {
                var value = this.getItemValue(item);
                this.$emit('input', value);
                this.isShowOption = false;
            }
        },
        destroyed: function () {
            if (this.owner) {
                this.owner.$off('imclick', this.hideOption);
            }
        }
    };
    utils.asyncComponent(options, resolve, reject);
};
}(RongIM, null, RongIM.components));
