(function (RongIM) {
'use strict';

var groupApi = null;
var userApi = null;

var Contact = {};

Contact.loadApi = function () {
    groupApi = RongIM.dataModel.Group;
    userApi = RongIM.dataModel.User;
};

/*
    消息转发时,选择最近联系人用
    最近联系人包括用户,群组
 */
Contact.get = function (ids, callback) {
    callback = callback || $.noop;
    var idList = [];
    var groupList = [];
    var userList = [];
    idList = idList.concat(ids);
    idList.forEach(function (item) {
        if (item.startsWith('group_')) {
            groupList.push(item.replace('group_', ''));
        } else {
            userList.push(item);
        }
    });
    userApi.getUsers(userList, function (errorCode, list) {
        if (errorCode) {
            callback(errorCode);
            return;
        }
        groupApi.getGroups(groupList, function (error, listGroup) {
            if (error) {
                callback(error);
                return;
            }
            var contacts = formateContact(list, false);
            contacts = contacts.concat(formateContact(listGroup, true));
            callback(null, sortContact(ids, contacts));
        });
    });
};

function formateContact(contacts, isGroup) {
    return contacts.map(function (item) {
        return {
            id: isGroup ? 'group_' + item.id : item.id,
            name: item.name,
            avatar: item.avatar,
            member_avatars: isGroup ? item.member_avatars : '',
            member_names: isGroup ? item.member_names : '',
            member_id_list: isGroup ? item.member_id_list : '',
            isFriend: isGroup ? true : item.isFriend
        };
    });
}

function sortContact(idList, contacts) {
    var objContacts = {};
    contacts.forEach(function (contact) {
        objContacts[contact.id] = contact;
    });
    var sortList = [];
    for (var i = 0; i < idList.length; i += 1) {
        sortList.push(objContacts[idList[i]]);
    }
    return sortList;
}

RongIM.dataModel.Contact = Contact;
}(RongIM));
