/* 群公告 */
(function (RongIM, dependencies) {
'use strict';

var Http = RongIM.dataModel._Http;
var RongIMClient = dependencies.RongIMClient;
var RongIMLib = dependencies.RongIMLib;
var utils = RongIM.utils;

var userApi = null;

var GroupNotice = {};

GroupNotice.loadApi = function () {
    userApi = RongIM.dataModel.User;
    utils = RongIM.utils;
};

GroupNotice.registerMessage = function () {
    // 群公告
    var messageName = 'GroupNoticeNotifyMessage';
    var objectName = 'RCE:GrpNoticeNtfy';
    var messageTag = new RongIMLib.MessageTag(true, true);
    var properties = ['action', 'mentionedInfo', 'content', 'targetGroup', 'operatorUser'];
    var searchProp = ['content'];
    RongIMClient.registerMessageType(messageName, objectName, messageTag, properties, searchProp);
};

GroupNotice.get = function (params, callback) {
    var groupId = params.id;
    var url = '/groups/' + groupId + '/notice';
    Http.get(url).done(function (notice) {
        userApi.get(notice.creator_id, function (error, user) {
            utils.console.log(error);
            user = user || {};
            notice.user = user;
            callback(error, notice);
        });
    }).fail(callback);
};

/*
    params.content
    params.id
*/
GroupNotice.publish = function (params, callback) {
    var groupId = params.id;
    var url = '/groups/' + groupId + '/notice/publish';
    Http.post(url, params)
        .then(function (result) {
            callback(null, result);
        }).fail(callback);
};

GroupNotice.remove = function (params, callback) {
    var id = params.id;
    var url = '/groups/' + id + '/notice/delete';
    Http.post(url, params)
        .then(function (result) {
            callback(null, result);
        }).fail(callback);
};

RongIM.dataModel.GroupNotice = GroupNotice;
}(RongIM, {
    RongIMClient: RongIMClient,
    RongIMLib: RongIMLib
}));
