(function(RongIM, dependencies) {
    'use strict';

    var $ = dependencies.jQuery;
    var Http = RongIM.dataModel._Http;
    var Cache = RongIM.dataModel._Cache;
    var ObserverList = RongIM.dataModel._ObserverList;
    var utils = RongIM.utils;
    var request = RongIM.dataModel._request;
    var common = RongIM.common;

    var userApi = RongIM.dataModel.User;
    console.log(RongIM)
    var Organization = {
        observerList: new ObserverList()
    };

    Cache.orgTree = {};
    // 多公司缓存公司信息
    Cache.company = {};

    Organization.cleanCache = function() {
        Cache.orgTree = {};
        Cache.company = {};
        delete Organization.getRoot.cache;
    };

    Organization.loadApi = function() {
        userApi = RongIM.dataModel.User;
    };

    /*
    说明：多部门修改，模拟之前部门树结构
    */
    Organization.getOrgTree = function() {
        var tree = {};

        function createTree(result) {
            var deptList = result.data.filter(function(item) {
                return item.member_type !== common.OrgType.STAFF;
            });
            deptList.forEach(function(item) {
                var pathIdString = item.path.map(function(pathItem) {
                    return pathItem.id;
                }).join(',');
                tree[item.member_uid] = {
                    id: item.member_uid,
                    type: item.member_type,
                    parentId: item.parent_uid,
                    path: pathIdString,
                    pathList: item.path
                };
            });
        }
        var coPromise = request('/organization', 'GET', {
            type: 'company'
        }).then(createTree);
        var deptPromise = request('/organization', 'GET', {
            type: 'depart'
        }).then(createTree);
        return $.when(coPromise, deptPromise).then(function() {
            return tree;
        });
    };

    Organization.getAllCompany = function() {
        return request('/companies/diff/0', 'GET').then(function(result) {
            return result.data;
        });
    };

    function getMydeptByCompany(company) {
        var orgInfo = null;
        if (!RongIM.instance.auth.orgsInfo) {
            return {};
        }
        common.getFullOrgInfo(RongIM.instance.auth.orgsInfo).forEach(function(org, index) {
            if (company.id === org.companyId) {
                if (!orgInfo) {
                    orgInfo = {
                        index: index,
                        deptList: []
                    };
                }
                var info = $.extend({}, org);
                orgInfo.deptList.push(info);
            }
        });
        return orgInfo;
    }
    Organization.getAutocephalyCompanyWithMydept = function(callback) {
        Organization.getAll({
            type: 'company'
        }, function(error, list) {
            if (!list) {
                callback(error);
                return;
            }
            var ordersMap = {};
            var idList = list.map(function(item) {
                var id = item.member_uid;
                ordersMap[id] = item.order;
                // parent_uid 空为集团（总公司）
                if (item.parent_uid === '') {
                    ordersMap[id] = 0;
                }
                return id;
            });
            Organization.getCompanyBatch(idList, function(errorCode, companyList) {
                if (!companyList) {
                    callback(errorCode);
                    return;
                }
                var autonomyCompany = companyList.filter(function(item) {
                    return item.type === common.CompanyType.AUTONOMY || item.parent_id === '';
                }).map(function(item) {
                    var myDept = getMydeptByCompany(item);
                    var memberCount = item.member_count;
                    if (item.parent_id === '' && Cache.rootCompanyMemberCount) {
                        memberCount = Cache.rootCompanyMemberCount;
                    }
                    return {
                        id: item.id,
                        name: item.name,
                        logoUrl: item.logo_url,
                        member_count: memberCount,
                        myDept: myDept,
                        order: ordersMap[item.id]
                    };
                });
                callback(null, autonomyCompany);
            });
        });
    };

    var BrancheType = {
        Dept: 1,
        Member: 0
    };

    function formatDept(dept) {
        var path = (Cache.orgTree[dept.id] || {}).path || '';
        return {
            id: dept.id,
            deptName: dept.name,
            path: path,
            avatar: '',
            member_count: dept.member_count
        };
    }

    function branchesGetMemberId(branches) {
        return branches.filter(function(item) {
            return +item.type === BrancheType.Member;
        }).map(function(item) {
            return item.id;
        });
    }

    function branchesGetDept(branches) {
        return branches.filter(function(item) {
            return +item.type === BrancheType.Dept;
        }).map(function(item) {
            return formatDept(item);
        });
    }

    Organization.watch = function(handle) {
        Organization.observerList.add(handle);
    };

    Organization.unwatch = function(handle) {
        Organization.observerList.remove(handle);
    };

    Organization.getLocalCompany = function(id) {
        return Cache.company[id] || {};
    };

    Organization.getCompanyById = function(id, callback) {
        var cacheCompany = Cache.company[id];
        if (!RongIM.utils.isEmpty(cacheCompany)) {
            callback(null, cacheCompany);
            return;
        }
        Http.get('/companies/' + id, function(errorCode, company) {
            if (!company) {
                callback(errorCode);
                return;
            }
            Cache.company[company.id] = company;
            callback(null, company);
        }).fail(callback);
    };

    Organization.getCompanyBatch = function(idList, callback) {
        if (idList.length === 0) {
            callback('params error');
            return;
        }
        var requestIdList = [];
        var companyList = [];
        idList.forEach(function(id) {
            var cacheCompany = Cache.company[id];
            if (RongIM.utils.isEmpty(cacheCompany)) {
                requestIdList.push(id);
            } else {
                companyList.push(cacheCompany);
            }
        });
        if (requestIdList.length === 0) {
            callback(null, companyList);
            return;
        }
        Http.post('/companies/batch', {
            ids: requestIdList
        }, function(errorCode, result) {
            if (!result.data) {
                callback(errorCode);
                return;
            }
            var list = result.data.filter(function(item) {
                if (item.state !== 2) {
                    Cache.company[item.id] = item;
                    return true;
                }
                return false;
            });
            callback(null, companyList.concat(list));
        }).fail(callback);
    };

    // 更新cache.company
    Organization.updateCompany = function(callback) {
        Cache.company = {};
        request('/companies/diff/0', 'GET').then(function(result) {
            result.data.forEach(function(company) {
                if (company.state !== 2) {
                    Cache.company[company.id] = company;
                }
            });
            if (callback) {
                callback();
            }
        });
    };

    /*
    说明： 根据 id 判读是否是独立子公司
    */
    Organization.isAutonomyCompany = function(id) {
        var company = Cache.company[id] || {};
        return company.type === common.CompanyType.AUTONOMY;
    };

    Organization.getCompanyAutonomysubcompany = function(parentId) {
        var list = [];
        $.each(Cache.company, function(id, company) {
            if (company.parent_id === parentId && company.type === common.CompanyType.AUTONOMY) {
                list.push(company);
            }
        });
        return list;
    };

    /*
    说明： 获取所有组织机构信息
    参数：
        params : 接口请求 query 参数 type: 0 staff，1 depart，2 company，不指定代表三种全选
    */
    Organization.getAll = function(params, callback) {
        if (typeof params === 'function') {
            callback = params;
            params = null;
        }
        Http.get('/organization', params, function(errorCode, result) {
            callback(result.data ? null : errorCode, result.data);
        }).fail(callback);
    };

    Organization.getLocalRoot = function() {
        var rootList = [];
        var cacheCompany = Cache.company;
        $.each(cacheCompany, function(coId, co) {
            if (utils.isEmpty(co.parent_id)) {
                rootList.push(co);
            }
        });
        return rootList;
    };

    Organization.getRoot = function(callback) {
        callback = callback || $.noop;
        var cache = Organization.getRoot.cache;
        if (!utils.isEmpty(cache)) {
            callback(null, cache);
            return;
        }
        Http.get('/organization/root', function(errorCode, result) {
            if (!result.data) {
                callback(errorCode);
                return;
            }
            /*
            获取根组织机构列表
                member_type 0:员工 1:部门 2:公司
            */
            var idList = result.data.filter(function(item) {
                return item.member_type === 2;
            }).map(function(item) {
                return item.member_uid;
            });
            Organization.getCompanyBatch(idList, function(error, companyList) {
                if (!companyList) {
                    callback(error);
                    return;
                }
                var list = companyList.map(function(item) {
                    return $.extend({}, item, {
                        type: 2
                    });
                });
                Organization.getRoot.cache = list;
                callback(null, companyList);
            });
        }).fail(callback);
    };

    /*
    说明： fix 获取根部门人数
    */
    Organization.getRootCompanyMemberCount = function() {
        Http.get('/companies/root/valid_member_count?state=0', function(errorCode, result) {
            if (result) {
                Cache.rootCompanyMemberCount = result.member_count;
            }
        });
    };

    Organization.getBranch = function(uid, params, callback) {
        if (typeof params === 'function') {
            callback = params;
            params = null;
        }
        Http.get('/organization/' + uid + '/members', params, function(errorCode, result) {
            if (!result.data) {
                callback(errorCode);
                return;
            }
            var data = result.data || [];
            var staffs = data.filter(function(org) {
                return org.type === common.OrgType.STAFF;
            });
            var depts = data.filter(function(org) {
                return org.type === common.OrgType.DEPT;
            });
            var deptIds = [];
            // 更新缓存中部门路径
            var hasVcharp3 = false;
            depts.forEach(function(org) {
                if (org.vchar_p3) hasVcharp3 = true;

                var pathIdString = org.path.map(function(item) {
                    return item.id;
                }).join(',');
                Cache.orgTree[org.id] = {
                    org: org,
                    id: org.id,
                    type: org.type,
                    parentId: org.parent_id,
                    path: pathIdString,
                    pathList: org.path
                };
                deptIds.push(org.id);
            });
            var companies = data.filter(function(org) {
                return org.type === common.OrgType.COMPANY;
            });
            companies.forEach(function(co) {
                co.logoUrl = Organization.getLocalCompany(co.id).logo_url;
            });
            var ret = {
                staffs: staffs,
                depts: depts,
                companies: companies,
                total_count: result.total_count,
                maxId: result.maxId,
                visible: result.visible,
                hideUserCount:result.hideUserCount,
            };
            if (staffs.length === 0) {
                callback(null, ret);
                return;
            }
            var idList = staffs.map(function(item) {
                return item.id;
            });

            userApi.getBatch(idList, function(error, userList) {
                if (userList) {
                    // ret.staffs = userList;
                    ret.staffs = userList.map(item => {
                      let staff = staffs.find(o => o.id == item.id);
                      if (staff) {
                        item.visible = staff.visible;
                      }
                      return item;
                    });
                }
                
                if (!hasVcharp3 && deptIds.length) {
                    var pArr = [];
                    deptIds.forEach(uid => {
                      var p = new Promise(function (resolve, reject) {
                        Http.get('/organization/' + uid + '/members?type=depart', function (err, res) {
                            if (res && res.data) {
                                res.data.forEach(function(dept) {
                                    if (Cache.orgTree[dept.id]) {
                                        Cache.orgTree[dept.id].org = dept;
                                    }
                                });
                            }
                            resolve(null, res);
                        }).fail(reject)
                        pArr.push(p);
                      });
                    })
                    Promise.all(pArr).then(function () {
                      callback(null, ret);
                    }).catch(function () {
                      callback(null, ret);
                    })
                } else {
                  callback(null, ret);
                }
            });
        }).fail(callback);
    };

    // get Path
    Organization.getOrgPath = function(uid, params, callback) {
        Http.get('/staffs/' + uid, params, function(errorCode, result) {
            if (errorCode) {
                return callback()
            }
            if (callback) {
                callback(errorCode, result)
            }
        })
    }

    Organization.getAllBranch = function(uid, params, callback) {
        if (typeof params === 'function') {
            callback = params;
            params = null;
        }
        Http.get('/organization/' + uid + '/all_members_two', params, function(errorCode, result) {
            if (!result.data) {
                callback(errorCode);
                return;
            }
            var data = result.data || [];
            var staffs = data.filter(function(org) {
                return org.type === common.OrgType.STAFF;
            });
            var depts = data.filter(function(org) {
                return org.type === common.OrgType.DEPT;
            });
            var companies = data.filter(function(org) {
                return org.type === common.OrgType.COMPANY;
            });
            var ret = {
                staffs: staffs,
                depts: depts,
                companies: companies
            };
            if (staffs.length === 0) {
                callback(null, ret);
                return;
            }
            var idList = staffs.map(function(item) {
                return item.id;
            });
            userApi.getBatch(idList, function(error, userList) {
                if (!userList) {
                    callback(error);
                    return;
                }
                ret.staffs = userList;
                callback(null, ret);
            });
        }).fail(callback);
    };

    Organization.getDept = function(deptId, callback, withoutBranch) {
        callback = callback || $.noop;
        var deptPromise = Http.get('/departments/' + deptId);
        if (withoutBranch) {
            deptPromise.then(function(deptResult) {
                var dept = formatDept(deptResult);
                callback(null, dept);
            }).fail(callback);
        } else {
            var branchesPromise = Http.get('/departments/' + deptId + '/branches');
            $.when(deptPromise, branchesPromise).done(function(deptResult, branchesResult) {
                var dept = formatDept(deptResult);
                var memberIds = branchesGetMemberId(branchesResult.data);
                userApi.getBatch(memberIds, function(errorCode, list) {
                    if (!list) {
                        callback(errorCode);
                        return;
                    }
                    dept.members = list;
                    dept.depts = branchesGetDept(branchesResult.data);
                    callback(null, dept);
                });
            }).fail(callback);
        }
    };

    Organization.getDeptNames = function(path, callback) {
        var list = path.split(',').map(function(item) {
            var dept = Cache.orgTree[item] || {};
            return {
                id: item,
                deptName: dept.deptName
            };
        });
        callback(null, list);
    };

    Organization.getLocalDept = function(deptId) {
        return Cache.orgTree[deptId] || {};
    };

    Organization.searchMembersInMyOrg = function(options, callback) {
        var auth = RongIM.instance.auth;
        var myorgArgs = {
            uid: auth.id
        };
        // workaround: 因后台接口bug，暂时去掉state参数
        ['orgtype', /*'state',*/ 'focustate'].forEach(function(k) {
            if (options[k] != null) myorgArgs[k] = options[k];
        });
        var searchArgs = {
            scope: 'name',
            // state: 0,
            in_all_jobs: 0
        };
        ['type', 'keyword', 'scope'].forEach(function(k) {
            if (options[k] != null) searchArgs[k] = options[k];
        });

        var searchResult = options.searchResult || {};
        request(
            '/departments/' + options.webapi, 'GET', myorgArgs
        ).then(function(orgs) {
            if (!orgs.data || orgs.data.length == 0) {
                callback();
                return;
            }

            var resultCount = orgs.data.length;

            function searchAllMembers(org, args) {
                request(
                    '/organization/' + org.id + '/all_members_two', 'GET', args
                ).then(function(result) {
                    if (result && result.data.length == 0 && args.in_all_jobs == 0) {
                        args.in_all_jobs = 1;
                        return searchAllMembers(org, args);
                    }

                    if (result && result.data.length > 0) {
                        result.data.forEach(function(item) {
                            var k = item.id;
                            if (searchResult[k] && searchResult[k].parent_id != item.parent_id) {
                                if (searchResult[k].mainDepart == item.mainDepart) {
                                    k = item.parent_id + '_' + item.id;
                                } else if (!searchResult[k].mainDepart && item.mainDepart) {
                                    // 主职部门替换非主职部门
                                    searchResult[k] = null;
                                }
                            }
                            if (searchResult[k] == null) searchResult[k] = item;
                        });
                    }

                    if (--resultCount == 0) {
                        callback(searchResult);
                    }
                });
            }

            orgs.data.forEach(function(org) {
                if (searchArgs.type == 'depart') {
                    [org.name, org.alias].some(function(scope) {
                        if (scope && scope.indexOf(searchArgs.keyword) > -1) {
                            searchResult[org.id] = org;
                            return true;
                        }
                    });
                }
                searchAllMembers(org, Object.assign({}, searchArgs));
            });
        });
    };

    Organization.searchInMyOrg = function(options, callback) {
        var self = this;
        var searchCount = 0;
        var searchResult = {};
        this.staffsSearchInorgs({
                keyword: options.keyword
            }, function(errorCode, result) {
                if (errorCode) {
                    return callback()
                }
                console.log("searchInMyOrg---->",result);
                return callback(result.data)
            })
            // [{
            //     webapi: 'myorg',
            //     // workaround: 因后台接口bug，暂时去掉state参数
            //     // state: 0
            // }, {
            //     webapi: 'myfocus',
            //     focustate: 0
            // }].forEach(function(apiArgs) {
            //     self.searchMembersInMyOrg(Object.assign(
            //         apiArgs, options, {searchResult: searchResult}
            //     ), function(result) {
            //         if (++searchCount == 2) {
            //             callback(Object.values(searchResult));
            //         }
            //     });
            // });
    }
    Organization.staffsSearchInorgs = function(params, callback) {
        request('/staffs/search/inOrgsNew', 'get', params, function(errorCode, result) {
            console.log("staffsSearchInorgs---->",result);
            if (errorCode) {
                return callback()
            }
            if (callback) {
                callback(errorCode, result)
            }
        })
    }
    Organization.searchStaff = function(params, callback) {
        callback = callback || $.noop;
        var deferred = $.Deferred();

        var keyword = params.keyword.replace('%', function(item) {
            return encodeURI(item);
        });
        // type 0: 根据姓名搜索,默认0 1:根据工号搜索 2:根据手机号搜索,暂不支持 3:根据邮箱搜索,暂不支持
        // 查询工号从 server 获取（本地无访客/员工全量数据）
        var fromServer = false;
        if (params.type === 1) {
            fromServer = true;
        }
        request('/staffs/search', 'post', {
            keywords: [keyword],
            type: params.type
        }, function(errorCode, result) {
            if (!result) {
                callback(errorCode);
                deferred.reject(errorCode);
                return;
            }
            result.forEach(function(item) {
                item.userType = item.user_type;
                item.isExecutive = item.is_executive;
                item.avatar = item.portrait_url;

            });
            callback(null, result);
            deferred.resolve(result);
        }, fromServer);
        return deferred.promise();
    };

    Organization.search = function(keyword, callback) {
        var params = {
            keyword: keyword,
            type: 0
        };
        return Organization.searchStaff(params, callback);
    };

    Organization.searchByStaffNo = function(keyword, callback) {
        var params = {
            keyword: keyword,
            type: 1
        };
        return Organization.searchStaff(params, callback);
    };

    Organization.searchDuty = function(keyword, callback) {
        keyword = keyword.replace('%', function(item) {
            return encodeURI(item);
        });
        Http.post('/misc/duty/search', {
            keywords: [keyword]
        }, function(errorCode, result) {
            callback(errorCode, result);
        }).fail(callback);
    };

    Organization.searchOrgs = function(keyword, callback) {
        keyword = keyword.replace('%', function(item) {
            return encodeURI(item);
        });
        Http.post('/departments/search', {
            keywords: [keyword]
        }, function(errorCode, result) {
            callback(errorCode, result);
        }).fail(callback);
    };

    Organization.searchCompanies = function(keyword, callback) {
        keyword = keyword.replace('%', function(item) {
            return encodeURI(item);
        });
        Http.post('/companies/search', {
            keywords: [keyword]
        }, function(errorCode, result) {
            if (result) {
                result.forEach(function(item) {
                    item.type = common.OrgType.COMPANY;
                    var companyDetail = Cache.company[item.id];
                    // 非独立子公司要显示公司详细 path
                    if (companyDetail.type === 0 && companyDetail.level !== 1) {
                        item.path = Cache.orgTree[item.id].pathList;
                    }
                });
            }
            callback(errorCode, result);
        }).fail(callback);
    };

    Organization.getMyX = function(adapter, uid, params, callback) {
        // workaround: 后端返回node_count有bug，必须设置params.vchar_p3 = 1
        var orgTypes = [2, 0, 1];
        if (params && params.orgtype != null && params.orgtype != '') {
            if (Array.isArray(params.orgtype)) {
                orgTypes = params.orgtype;
            } else {
                switch (typeof params.orgtype) {
                    case 'number':
                        orgTypes = [params.orgtype];
                        break;

                    case 'string':
                        orgTypes = params.orgtype.split(',');
                        break;
                }
            }
        }
        if (adapter.orgTypesFilter) {
            orgTypes = adapter.orgTypesFilter(orgTypes);
        }

        var context = this;
        var resultBuffer = [
            [],
            [],
            []
        ];
        var resultCount = 0;
        orgTypes.forEach(function(orgType, i) {
            var myorgArgs = Object.assign({}, params, {
                orgtype: orgType
            });
            context[adapter.invoke](uid, myorgArgs, function(result) {
                if (result.data) {
                    resultBuffer[i] = result.data;
                }
                if (++resultCount == orgTypes.length) {
                    if (adapter.resultFilter) {
                        adapter.resultFilter(resultBuffer, params, function(allItems) {
                            callback({
                                count: allItems.length,
                                data: allItems
                            });
                        });
                    } else {
                        var allItems = resultBuffer[0].concat(resultBuffer[1]).concat(resultBuffer[2]);
                        callback({
                            count: allItems.length,
                            data: allItems
                        });
                    }
                }
            });
        });
    }

    Organization.getMyOrganization = function(uid, params, callback) {
        return this.getMyX({
            invoke: "getMyOrganizationParams",
            orgTypesFilter: function(orgTypes) {
                // workaround: 后端只查单位时有bug，需要连同部门一起查
                if (orgTypes.length == 1 && orgTypes[0] == 2) return [''];
                return ['', '1'];
            },
            resultFilter: function(resultBuffer, params, cb) {
                // workaround: 后端只查单位时有bug，需要连同部门一起查
                resultBuffer[0] = resultBuffer[0].filter(function(org) {
                    return params.orgtype == 2 ? org.vchar_p3 == 2 : org.vchar_p3 != 1;
                });
                cb(resultBuffer[0].concat(resultBuffer[1]));
                /*
                function returnResult() {
                    if (params && params.orgtype != null && params.orgtype != '') {
                        if (params.orgtype == 2) return cb(resultBuffer[0]);
                        if (params.orgtype == 0) return cb(resultBuffer[1]);
                        if (params.orgtype == 1) return cb(resultBuffer[2]);
                    }
                    cb(resultBuffer[0].concat(resultBuffer[1]).concat(resultBuffer[2]));
                }

                Http.get('/staffs/' + uid, function(err, res) {
                    if (res) {
                        // resultBuffer[0] : 单位列表
                        // resultBuffer[1] : 部门列表
                        // res.orgs_info : 所属组织列表
                        // ownerMap : 所属组织索引
                        // orgMap : 所属上级组织索引
                        var ownerMap = {}, orgMap = {};
                        // 编制所属组织索引
                        res.orgs_info.forEach(function (org) {
                            ownerMap[org.id] = org;
                        });
                        resultBuffer[1].forEach(function (dept) {
                            if (ownerMap[dept.id]) {
                                // 编制所属上级组织索引
                                dept.path.forEach(function (org) {
                                    orgMap[org.id] = org;
                                });
                            }
                        });
                        // 筛选我的部门
                        resultBuffer[1] = resultBuffer[1].filter(function(org) {
                            return ownerMap[org.id] != null || orgMap[org.id] != null;
                        });
                        // 筛选我的单位
                        resultBuffer[0] = resultBuffer[0].filter(function(org) {
                            return orgMap[org.id] != null;
                        });
                    }
                    returnResult();
                }).fail(returnResult);
                */
            }
        }, uid, params, callback);
    }

    Organization.getMyfollow = function(uid, params, callback) {
        // return getOrgX('/departments/myfocus?uid=' + uid, params, callback);
        return this.getMyX({
            invoke: "getMyfollowParams",
            orgTypesFilter: function(orgTypes) {
                return [''];
            },
        }, uid, params, callback);
    }

    function sortOrgs(a, b) {
        function getOrgOrder(org) {
            var baseOrder = 1;
            if (org.vchar_p3 == 2) baseOrder = 0;
            if (org.vchar_p3 == 1) baseOrder = 2;
            return baseOrder * 1000 + (org.path ? org.path.length : 0);
        }

        return getOrgOrder(a) - getOrgOrder(b);
    }

    function presetParams(params) {
        // 删除vchar_p3=1字段
        if (params.orgtype == 1) params.vchar_p3 = 1;
        // workaround: 因后台接口bug，暂时去掉state参数
        if (params.state != null) delete params.state;
    }

    function getOrgX(url, params, callback, sorter) {
        presetParams(params);
        Http.get(url, params, function(errorCode, result) {
            if (!result.data) {
                callback(errorCode);
                return;
            }
            if (sorter) result.data.sort(sorter);
            return callback(result);
        }).fail(callback);
    }
    //获取通讯组列表
    Organization.getPinGroups = function(keyword, callback) {
            let paStr = "?keyword=" + keyword
            Http.get('/pins/pinGroups' + paStr, function(errorCode, result) {
                if (!result.data) {
                    callback(errorCode);
                    return;
                }
                if (result.count > 0) {
                    result.data.forEach((obj, index) => {
                        RongIM.dataModel.Group.getPinItems(obj.id, function(errorCode, res) {
                            let item = {};
                            var groupIds = [];
                            res.data.forEach(function(group) {
                                group.avatar = group.portrait_url;
                                group.admin_id = group.manager_id;
                                groupIds.push(group.id);
                                var organization = Organization.getLocalDept(group.organization_id);
                                if (organization.type === common.OrgType.COMPANY) {
                                    var co = Organization.getLocalCompany(group.organization_id) || {};
                                    organization.fullName = co.fullName;
                                }
                                group.organization = organization;
                            });
                            item.members = res.data;
                            item.member_count = res.count
                            item.member_id_list = res.data.map(res => res.id)
                            item.member_names = res.data.map(res => res.name)
                            item.member_brief = res.data.map(res => {
                                return {
                                    id: res.id,
                                    createDt: res.create_dt
                                }
                            })
                            item.member_avatars = res.data.map(res => res.portrait_url)
                            obj.member = item
                        })
                        if (index == result.count - 1) {
                            return callback(result);
                        }
                    })

                } else {
                    return callback(result);
                }


            }).fail(callback);

        }
        //我的组织
    Organization.getMyOrganizationParams = function(uid, params, callback) {
            getOrgX('/departments/myorg?uid=' + uid, params, callback);
        }
        //我的关注
    Organization.getMyfollowParams = function(uid, params, callback) {
            getOrgX('/departments/myfocus?uid=' + uid, params, callback);
        }
        //下级成员
    Organization.getMembers = function(orgid, params, callback) {
            getOrgX('/organization/' + orgid + '/members', params, callback);
        }
        //所有成员
    Organization.getAllMembers = function(orgid, params, callback) {
        getOrgX('/organization/' + orgid + '/all_members_two', params, callback);
    }

    function postFocus(url, params, callback) {
        Http.post(url, params, function(errorCode, result) {
            if (!errorCode || errorCode == 10000) {
                common.messageToast({
                    message: RongIM.locale.zh.blish.addFollowMessage
                });
                return callback();
            }

            if (errorCode == 10003) {
                common.messageToast({
                    type: 'error',
                    message: RongIM.locale.zh.blish.toast.serverRrrTips
                });
            } else if (errorCode == 10301) {
                common.messageToast({
                    type: 'error',
                    message: RongIM.locale.zh.blish.toast.invalidOrgId
                });
            } else if (errorCode == 10302) {
                common.messageToast({
                    type: 'error',
                    message: RongIM.locale.zh.blish.toast.invalidUserId
                });
            } else if (errorCode == 10303) {
                common.messageToast({
                    type: 'error',
                    message: RongIM.locale.zh.blish.toast.repeatTipe
                });
            } else if (errorCode == 10304) {
                common.messageToast({
                    type: 'error',
                    message: RongIM.locale.zh.blish.toast.noFollowTips
                });
            } else if (errorCode == 10305) {
                common.messageToast({
                    type: 'error',
                    message: RongIM.locale.zh.blish.toast.repeatFollowTips
                });
            } else if (errorCode == 10300) {

                common.messageToast({
                    message: RongIM.locale.zh.blish.toast.toExamineTips
                });
                return callback();
                // common.messageToast({
                //   type: 'error',
                //   message: RongIM.locale.zh.blish.toast.toExamineTips
                // });
            } else if (errorCode == 10309) {
                common.messageToast({
                    type: 'error',
                    message: RongIM.locale.zh.blish.toast.prohibitTips
                });
            } else {
                common.messageToast({
                    type: 'error',
                    message: RongIM.locale.zh.blish.toast.followErrTips
                });
            }
            callback(errorCode);
        }).fail(callback);
    }

    //申请关注
    Organization.applyFollow = function(orgid, params, callback) {
            postFocus('/organization/' + orgid + '/apply_focus', params, callback);
        }
        //取消关注
    Organization.cancelFollow = function(orgid, params, callback) {
            postFocus('/organization/' + orgid + '/cancel_focus', params, callback);
        }
        //根据通讯组id获取成员
    Organization.getMembersById = function(uid, callback) {
        let path = '/pins/pinGroup/' + uid + '/items?keyword'
        Http.get(path)
            .then(function(result) {
                return callback(null, result);
            }).fail(callback);
    };
    //根据通讯组id获取成员
    Organization.searchPinGroupItem = function(uid, keyword, callback) {
        let flag = uid ? '&&uid=' + uid : ""
        let path = '/pins/searchPinGroupItem?keyword=' + keyword + flag
        Http.get(path)
            .then(function(result) {
                return callback(null, result);
            }).fail(callback);
    };
    //设置通讯组
    Organization.setPinGroup = function(params, callback) {
        Http.put('/pins/setPinGroup', params, function(errorCode, result) {
            callback(errorCode, result);
        }).fail(callback);
    };
    //设置通讯组
    Organization.deletePinGroup = function(id, callback) {
        let url = '/pins/pinGroup/' + id
        Http.del(url, function(errorCode, result) {
            callback(errorCode, result);
        }).fail(callback);
    };
    //组织云搜索部门接口
    Organization.searchOrgList = function(id, params, callback) {
        let url = '/organization/' + id + '/searchOrgMembers'
        Http.get(url, params, function(errorCode, result) {
            callback(errorCode, result);
        }).fail(callback);
    };
    //组织云搜索人员接口
    Organization.searchStaffMembers = function(id, params, callback) {
        let url = '/organization/' + id + '/searchStaffMembers'
        Http.get(url, params, function(errorCode, result) {
            callback(errorCode, result);
        }).fail(callback);
    };
    //组织云搜索部门接口
    Organization.searchOrgs = function(id, params, callback) {
        let url = '/organization/' + id + '/searchOrgMembers'
        Http.get(url, params, function(errorCode, result) {
            callback(errorCode, result);
        }).fail(callback);
    };
    //1.根据关键字查询组织内（组织）信息
    Organization.searchOrgMembers = function(id, params) {
        let orgUrl = '/organization/' + id + '/searchOrgMembers'
        let userUrl = '/organization/' + id + '/searchStaffMembers'
        let orgResult = {}
        let userResult = {}
        var orgPromise = request(orgUrl, 'GET', params).then(res => {
            orgResult = res;
        });
        var userPromise = request(userUrl, 'GET', params).then(res => {
            userResult = res;
        });
        return $.when(orgPromise, userPromise).then(function() {
            return {
                orgResult: orgResult,
                userResult: userResult
            };
        });

    };
    // 申请联盟
    Organization.applyUnion = function (id, callback) {
        Http.post('/departments/applyUnion', { depart_uid: id }, (errorCode, result) => {
            callback(errorCode, result);
        }).fail(callback);
    };
    // 同意联盟
    Organization.updateUnionApply = function (id, callback) {
        Http.post('/departments/updateUnionApply', { depart_uid: id }, (errorCode, result) => {
            callback(errorCode, result);
        }).fail(callback);
    };
    // 获取新的联盟单位申请
    Organization.getNewUnionApply = function (callback) {
        Http.get('/departments/getNewUnionApply', (errorCode, result) => {
            callback(errorCode, result);
        }).fail(callback);
    };
    // 获取当前登录人的联盟单位
    Organization.getUserUnionDepart = function (callback) {
        Http.get('/departments/getUserUnionDepart', (errorCode, result) => {
            callback(errorCode, result);
        }).fail(callback);
    };
    RongIM.dataModel.Organization = Organization;
}(RongIM, {
    jQuery: jQuery
}));
