(function (RongIM, dependencies, components) {
    'use strict';

    var common = RongIM.common;
    var utils = RongIM.utils;
    var cache = utils.cache;
    var Http = RongIM.dataModel._Http;
    var server = RongIM.config.dataModel.server;

    components.getLogin = function (resolve, reject) {
        var im = RongIM.instance;
        var dataModel = im.dataModel;
        // 模块化屏蔽入口
        // 二维码登录
        var modules = im.config.modules;
        var enabledQrcodeLogin = modules.qrcodeLogin;
        var serverConfig = RongIM.serverConfig;
        var selected = 'password';
        if (enabledQrcodeLogin === false) {
            selected = 'qrcode';
        }

        // 注册
        var enabledSignup = serverConfig.registration.enable;
        // 忘记密码
        var forgetPassword = serverConfig.password.forgot_enable;

        var userApi = im.dataModel.User;
        var supportLocales = [];
        $.each(RongIM.locale, function (key, locale) {
            supportLocales.push({
                value: key,
                name: locale.name
            });
        });

        // var requriedPassword = utils.isEmpty(cache.get('login-params'));
        var options = {
            name: 'login',
            template: '#rong-template-login',
            data: function () {
                return {
                    busy: false,
                    language: im.config.locale,
                    supportLocales: supportLocales,
                    enabledQrcodeLogin: enabledQrcodeLogin,
                    enabledSignup: enabledSignup,
                    forgetPassword: forgetPassword,
                    selected: selected,
                    qrcodeTimeout: false,
                    qrcodeAccountLocked: true,
                    qrcodeLockedError: '帐号或密码多次错误，请30分钟后再试或点击忘记密码',
                    phone: cache.get('account-number'),
                    password: '',
                    verificationCode: '', // 验证码
                    zip: im.config.zip,
                    isRememberMe: false,
                    isOvertime: false,
                    isZkxicon: false,
                    captchaButtonBusy: false,
                    captchaButtonText: '',
                    captcha: '',
                    eye: false,
                    verifyId: ''
                };
            },
            components: {
                customSelect: components.customSelect
            },
            computed: {
                disabled: function () {
                    return this.selected === 'textlogin' ? utils.isEmpty(this.phone) || utils.isEmpty(this.captcha)  : utils.isEmpty(this.phone) || (utils.isEmpty(this.password) && utils.isEmpty(this.captcha)) || utils.isEmpty(this.verificationCode);
                },
                isFirst: function () {
                    return im.isFirst;
                }
            },
            watch: {
                language: function (lang) {
                    cache.set('locale', lang);
                    im.locale.product.productName = im.config.product.name[lang];
                    im.config.locale = lang;
                    document.title = im.locale.product.productName;
                    RongIMLib.RongIMEmoji.setConfig({ lang: im.config.locale });
                    RongIM.system.setLanguage(im.config.locale);
                },
                selected: function (value) {
                    var context = this;
                    var loginType = ''
                    if (value === 'qrcode') {
                        context.$nextTick(context.qrcodeLogin);
                        this.isZkxicon = true;
                        loginType = '3';
                    } else if (value === 'password') {
                        this.isZkxicon = false;
                        loginType = '1';
                        this.loadIdentifyCode()
                    } else {
                        this.isZkxicon = false;
                        loginType = '3';
                    }
                    modules.zkxLoginType = loginType;
                    utils.console.log(loginType + '--------')
                },
                phone: function () {
                    var context = this;
                    context.password = '';
                    context.isRememberMe = false;
                },
                password: function () {
                    cache.remove('login-params');
                },
                captcha: function () {
                    var context = this;
                    context.code = ''
                },
                isRememberMe: function (value) {
                    var context = this;
                    var loginParams = cache.get('login-params');
                    if (!value && loginParams) {
                        cache.remove('login-params');
                        context.password = '';
                    }
                }
            },
            mixins: [
                components.getValidate()
            ],
            directives: {
                'auto-focus': {
                    inserted: autoFocus
                }
            },
            created: function () {
                var context = this;
                document.body.style.backgroundColor = '#0085e1';
                var hasLoginInfo = !utils.isEmpty(cache.get('loginInfo'));
                if (hasLoginInfo) {
                    var loginInfo = cache.get('loginInfo') || {};
                    var newTime = (new Date()).getTime();
                    var oldTime = loginInfo.timestamp || '';
                    context.isRememberMe = loginInfo.isRememberMe || false;
                    context.password = context.isRememberMe ? utils.uncompileStr(loginInfo.password) : '';
                    if (oldTime !== '' && (newTime - oldTime) / (24 * 60 * 60 * 1000) >= 30) {
                        // 时间戳超过 30 天，需要重新输入密码
                        context.isOvertime = true;
                    }
                }
            },
            mounted: function () {
                var context = this;
                var params = this.$route.params;
                if (params.selected) {
                    this.selected = params.selected;
                }
                cache.remove('auth');
                im.$on('userBlocked', function () {
                    context.busy = false;
                });

                if (enabledQrcodeLogin) {
                    this.qrcodeLogin();
                }
                this.captchaButtonText = this.locale.sendCaptcha;
                this.loadIdentifyCode()
            },
            methods: {
                loadIdentifyCode: function() {
                    const context = this
                    context.verificationCode = ''
                    var xhr = new XMLHttpRequest();
                    xhr.open("GET", `${server}/user/validateCode?data=${new Date() + Math.floor(Math.random()*24)}`, true);
                    xhr.setRequestHeader('Content-Type', 'application/json');
                    xhr.send();
                    xhr.onreadystatechange = function () {
                        if (xhr.readyState == 4 && xhr.status == 200) {
                            context.verifyId = xhr.getResponseHeader('verifyId');
                            document.getElementById('identifyCode').src = xhr.responseText;
                        }
                    }
                },
                cahngeEye: function () {
                    this.eye = !this.eye;
                },
                qrcodeRefresh: function () {
                    this.qrcodeLogin();
                },
                qrcodeLogin: function () {
                    var context = this;
                    context.qrcodeTimeout = false;
                    context.qrcodeAccountLocked = false;
                    dataModel.User.qrcodeLogin(context.$refs.qrcode, function (errorCode, result) {
                        if (errorCode) {
                            RongIM.system.appLogger('error', '二维码登录失败 ' + JSON.stringify(errorCode));
                            if (errorCode === common.ErrorCode.INVALID_TOKEN) {
                                context.qrcodeTimeout = true;
                            } else if (errorCode === common.ErrorCode.ACCOUNT_IS_LOCKED) {
                                context.qrcodeAccountLocked = true;
                                result = result.result || {};
                                var message = common.getErrorMessage(errorCode);
                                var unlockTime = result.unlock_expired_time;
                                if (unlockTime) {
                                    var timeString = common.timestampToDisplayTime(unlockTime);
                                    message = utils.templateFormat(message, timeString);
                                }
                                context.qrcodeLockedError = message;
                            }
                            return;
                        }
                        im.$emit('imlogined');

                        RongIM.system.appLogger('info', '二维码登录成功 ' + RongIM.dataModel.getServerTime());
                        var staff = result.staff;
                        var auth = {
                            isExecutive: staff.isExecutive,
                            token: result.token,
                            id: staff.id,
                            code: staff.code,
                            companyId: staff.companyId,
                            deptId: staff.deptId,
                            isStaff: staff.user_type === 0,
                            orgsInfo: staff.orgsInfo,
                            display_mobile: staff.display_mobile,
                            xhManager: result.xhManager
                        };
                        var isTemp = true;
                        cache.set('auth', auth, isTemp);
                        var accountNumber = staff.mobile;
                        var accountConfig = RongIM.serverConfig.organization;
                        if (accountConfig.username_binding === 'staffNo') {
                            accountNumber = staff.staff_no;
                        }
                        cache.set('account-number', accountNumber);
                        // 首次多端同时登陆显示文件助手 其他端登录状态 login_status
                        cache.set('login_status', result.login_status);
                        im.auth = auth;
                        im.cacheAuth = auth;
                        im.$router.push({ name: 'conversation' });
                        im.checkLock();
                        im.isFirstSyncdata = RongIM.firstSyncdata.get(auth.id);
                        if (im.isFirstSyncdata) {
                            im.syncdataLoad.show = true;
                        }
                        im.syncdataLoad.state = 'loading';
                        im.syncdataLoad.progress = 0;
                        im.syncdataCallback = function (error) {
                            if (error) {
                                im.syncdataLoad.state = 'failed';
                                return;
                            }
                            RongIM.firstSyncdata.set(auth.id);
                            im.syncdataLoad.state = 'success';
                            im.connect();
                            im.loginedGetBasedata();
                        };
                        RongIM.Database.init(RongIM.serverConfig.im.app_key, im.auth.id, function () {
                            RongIM.syncdata.all(auth.isStaff, im.syncdataCallback, function (p) {
                                im.syncdataLoad.progress = Number(p.toFixed(2));
                            });
                        });
                    });
                },
                passwordLogin: function () {
                    var context = this;
                    var params = {
                        phone: context.phone,
                        password: context.password,
                        zip: context.zip,
                        isRememberMe: context.isRememberMe,
                        verificationCode: context.verificationCode,
                        verifyId: context.verifyId
                    };
                    if (context.isOvertime) {
                        // 超过 30 天密码置空，重新输入
                        context.password = '';
                        context.isRememberMe = false;
                        cache.remove('loginInfo');
                        context.isOvertime = false;
                        var message = RongIM.instance.locale.errorCode['password-overtime'];
                        Vue.set(context.errors, 'password', message);
                        return;
                    }
                    passwordLogin(this, params, RongIM.instance);
                },
                textLogin: function () {
                    var context = this;
                    var params = {
                        phone: context.phone,
                        password: context.password,
                        zip: context.zip,
                        isRememberMe: context.isRememberMe
                    };
                    if (context.isOvertime) {
                        // 超过 30 天密码置空，重新输入
                        context.password = '';
                        context.isRememberMe = false;
                        cache.remove('loginInfo');
                        context.isOvertime = false;
                        var message = RongIM.instance.locale.errorCode['password-overtime'];
                        Vue.set(context.errors, 'password', message);
                        return;
                    }
                    textLogin(this, params, RongIM.instance);
                },
                sendCaptcha: function () {
                    sendCaptcha(this);
                },
                sendCode: function () {
                    return sendCode(this, userApi);
                },
            }
        };
        utils.asyncComponent(options, resolve, reject);
    };

    function autoFocus(el) {
        if (utils.isEmpty(el.value) && !autoFocus.done) {
            el.focus();
            autoFocus.done = true;
        }
    }

    function passwordLogin(context, params, im) {
        if (!context.valid() || context.busy) {
            return;
        }
        context.busy = true;
        im.login(params)
            .then(function () {
                RongIM.system.appLogger('info', '使用帐号密码方式登录成功!');
                cache.set('account-number', context.phone);
            })
            .fail(function (errorCode, response) {
                var lockAccoutCleardata = (im.serverConfig.lockaccount || {}).clear_local_data_enable;
                var message = common.getErrorMessage(errorCode) || '';
                if (errorCode) {
                    if (response && response.result) {
                        var result = response.result;
                        if (result.unlock_expired_time) {
                            // 账号已被锁定
                            if (lockAccoutCleardata) {
                                RongIM.cleanStorage();
                            }
                            var timeString = common.timestampToDisplayTime(result.unlock_expired_time);
                            message = utils.templateFormat(message, timeString);
                        } else if (result.retry_count) {
                            // 剩余尝试次数
                            if (result.retry_count === 1 && lockAccoutCleardata) {
                                message = context.locale.clearStorageWarn;
                            } else {
                                message = common.getErrorMessage(errorCode + '-' + result.retry_count);
                            }
                        }
                    }
                }
                RongIM.system.appLogger('error', '使用帐号密码方式登录失败! Error: ' + JSON.stringify(message));
                if (errorCode && errorCode === 10163) {
                    Vue.set(context.errors, 'verificationCode', message);
                } else {
                    Vue.set(context.errors, 'password', message);
                }
                context.password = '';
                cache.remove('login-params');
                context.loadIdentifyCode()
            }).always(function () {
                context.busy = false;
            });
    }

    function textLogin(context, params, im) {
        if (!context.valid() || context.busy) {
            return;
        }
        var userApi = im.dataModel.User;
        context.busy = true;
        checkCode(context, userApi)
            .then(function () {
                setTimeout(function () {
                    im.login(params)
                        .then(function () {
                            RongIM.system.appLogger('info', '使用帐号密码方式登录成功!');
                            cache.set('account-number', context.phone);
                        })
                        .fail(function (errorCode, response) {
                            var lockAccoutCleardata = (im.serverConfig.lockaccount || {}).clear_local_data_enable;
                            var message = common.getErrorMessage(errorCode) || '';
                            if (errorCode) {
                                if (response && response.result) {
                                    var result = response.result;
                                    if (result.unlock_expired_time) {
                                        // 账号已被锁定
                                        if (lockAccoutCleardata) {
                                            RongIM.cleanStorage();
                                        }
                                        var timeString = common.timestampToDisplayTime(result.unlock_expired_time);
                                        message = utils.templateFormat(message, timeString);
                                    } else if (result.retry_count) {
                                        // 剩余尝试次数
                                        if (result.retry_count === 1 && lockAccoutCleardata) {
                                            message = context.locale.clearStorageWarn;
                                        } else {
                                            message = common.getErrorMessage(errorCode + '-' + result.retry_count);
                                        }
                                    }
                                }
                            }
                            RongIM.system.appLogger('error', '使用帐号密码方式登录失败! Error: ' + JSON.stringify(message));
                            Vue.set(context.errors, 'password', message);
                            context.password = '';
                            cache.remove('login-params');
                        }).always(function () {
                            context.busy = false;
                        });
                }, 200)
            })
            .fail(function (errorCode) {
                context.$set(context.errors, 'captcha', common.getErrorMessage(errorCode));
                context.busy = false;
            });


    }

    function sendCaptcha(context) {
        if (!context.valid('[name=phone]')) {
            return;
        }

        context.captchaButtonBusy = true;
        context.sendCode()
            .then(function () {
                var captchaButtonTextBackup = context.captchaButtonText;
                var count = 59;
                var timer = setInterval(function () {
                    if (count > 0) {
                        count = count < 10 ? ('0' + count) : count;
                        context.captchaButtonText = context.localeFormat(context.locale.sentCaptcha, count);
                        count--;
                    } else {
                        context.captchaButtonText = captchaButtonTextBackup;
                        context.captchaButtonBusy = false;
                        clearInterval(timer);
                    }
                }, 1000);
            })
            .fail(function () {
                context.captchaButtonBusy = false;
            })
            .always(function () {
                sendCaptcha.done = true;
            });
    }

    function sendCode(context, userApi) {
        var defer = $.Deferred();
        var params = {
            zip: context.zip,
            phone: context.phone
        };
        userApi.zkxsendCode('send_code', params, function (errorCode) {
            if (errorCode) {
                context.$set(context.errors, 'captcha', common.getErrorMessage(errorCode));
                defer.reject(errorCode);
            } else {
                defer.resolve();
            }
        });
        return defer.promise();
    }

    function checkCode(context, userApi) {
        var defer = $.Deferred();
        var params = {
            zip: context.zip,
            phone: context.phone,
            code: context.captcha
        };
        userApi.checkCode(params, function (errorCode, result) {
            if (errorCode) {
                defer.reject(errorCode);
            } else {
                defer.resolve(result);
            }
        });
        return defer.promise();
    }


}(RongIM, {
    jQuery: jQuery
}, RongIM.components));
