(function (RongIM, dependencies, components) {
'use strict';

var common = RongIM.common;
var utils = RongIM.utils;
var dialog = RongIM.dialog;
var moment = dependencies.moment;
var approveState = {
    // 请及时审批 0 非系统状态,用于控制显示
    REMIND: 0,
    // 审批中 1
    PENDING: 1,
    // 审批通过 2
    PASSED: 2,
    // 审批拒绝 3
    REFUSED: 3
};

components.getApprovalMessage = function (resolve, reject) {
    var im = RongIM.instance;
    var options = {
        name: 'approval-message',
        props: ['message'],
        template: '#rong-template-approval',
        computed: {
            user: function () {
                return this.message.user;
            },
            content: function () {
                var content = this.message.content;
                content.id = content.userId;
                content.avatar = content.imageUri;
                return content;
            },
            statusText: function () {
                return this.locale[this.getStatus(this.content.status)];
            }
        },
        components: {
            avatar: components.getAvatar
        },
        created: function () {
            var content = this.message.content;
            // 是否审批者
            var isApprover = content.userId !== im.auth.id;
            if (content.status === approveState.PENDING && isApprover) {
                this.message.content.status = approveState.REMIND;
            }
        },
        methods: {
            getUsername: common.getUsername,
            userProfile: dialog.user,
            dateFormat: function (timestamp, format) {
                return moment(timestamp).format(format);
            },
            getStatus: function (status) {
                return common.ApproveState[status].toLowerCase();
            },
            openUrl: function () {
                var url = this.message.content.extra;
                var queryStr = url.substr(url.indexOf('?'));
                var query = getQuery(queryStr);
                // 发起人Id
                var userId = this.message.content.userId;
                var approveId = query.approveId;
                if (approveId) {
                    dialog.approvalDetail({
                        id: approveId,
                        userId: userId
                    });
                }
                // console.error('openUrl',url);
                // dialog.approvalDetail({});
            }
        }
    };
    utils.asyncComponent(options, resolve, reject);
};

function getQuery(str) {
    var query = {};
    // TODO: 这里使用 ? server 传输有问题
    str.split('?').forEach(function (item) {
        var arr = item.split('=');
        query[arr[0]] = arr[1];
    });
    return query;
}
}(RongIM, {
    moment: moment
}, RongIM.components));
