/*
说明：名片消息
功能：
    1. 消息列表中的名片消息
    2. 历史消息中的名片消息
*/
(function (RongIM, components) {
'use strict';

var common = RongIM.common;
var utils = RongIM.utils;
var dialog = RongIM.dialog;

components.getCardMessage = function (resolve, reject) {
    var im = RongIM.instance;
    var friendApi = im.dataModel.Friend;
    var options = {
        name: 'card-message',
        props: ['message'],
        template: '#rong-template-card',
        computed: {
            user: function () {
                return this.message.user;
            },
            content: function () {
                var content = this.message.content;
                content.id = content.userId;
                content.avatar = content.portraitUri || content.avatar;
                return content;
            }
        },
        components: {
            avatar: components.getAvatar
        },
        methods: {
            getUsername: common.getUsername,
            userProfile: function (userId) {
                friendApi.getFileHelper(function (error, helper) {
                    if (userId === helper.id) {
                        dialog.getFileHelper(helper);
                    } else {
                        dialog.user(userId);
                    }
                });
            }
        }
    };
    utils.asyncComponent(options, resolve, reject);
};
}(RongIM, RongIM.components));
