(function (RongIM, dependencies, components) {
'use strict';

var utils = RongIM.utils;
var common = RongIM.common;
var Base64Util = utils.Base64;
var $ = dependencies.jQuery;
var fileApi = RongIM.dataModel.File;
// var drag = RongIM.drag;

/* var revokeBlobUrl = function(file) {
    var URL = window.URL || window.webkitURL;
    return URL ? URL.revokeObjectURL(file) : "";
}; */
components.getImageMessage = function (resolve, reject) {
    var options = {
        name: 'image-message',
        props: ['message', 'isHistory'],
        template: '#rong-template-image',
        data: function () {
            return {
                style: {
                    height: '180px'
                },
                sentStatus: utils.sentStatus,
                uploadStatus: utils.uploadStatus,
                size: {},
                imageUri: ''
            };
        },
        computed: {
            isGif: function () {
                var regEx = /^(http||https).*(gif)$/;
                var imageUri = this.message.content.imageUri;
                return regEx.test(imageUri);
            },
            base64: function () {
                var imageMsg = this.message.content;
                var content = imageMsg.content;
                return Base64Util.concat(content);
            },
            isUploading: function () {
                var uploadStatus = this.message.uploadStatus;
                var uploading = uploadStatus === utils.uploadStatus.UPLOADING;
                var progress = this.message.progress > 0;
                return uploading && progress;
            },
            path: function () {
                var percent = (this.message.progress || 0) / 100;
                if (percent === 1) {
                    percent = 0.99;
                }
                var r = 10;
                var degrees = percent * 360;
                var rad = degrees * (Math.PI / 180);
                var x = (Math.sin(rad) * r).toFixed(2);
                var y = -(Math.cos(rad) * r).toFixed(2);
                var lenghty = window.Number(degrees > 180);
                var path = ['M', 0, -r, 'A', r, r, 0, lenghty, 1, x, y];
                path = path.join(' ');
                return path;
            }
        },
        methods: {
            showImage: function () {
                this.$emit('showImage', this.message);
            },
            updateThumbnailHeight: function (event) {
                var $img = $(event.target);
                var width = $img.width();
                var height = $img.height();
                this.style = {
                    width: width + 'px',
                    height: height + 'px'
                };
                if (this.isHistory) {
                    if (width < height) {
                        $img.css({
                            width: '100%'
                        });
                    } else {
                        $img.css({
                            height: '100%'
                        });
                    }
                }
            },
            largeImageLoaded: function (event) {
                var $img = $(event.target);
                var width = $img.width();
                var height = $img.height();
                this.size = { width: width, height: height };
                if (width < height) {
                    $img.css({
                        width: this.style.width,
                        height: 'auto'
                    });
                } else {
                    $img.css({
                        width: 'auto',
                        height: this.style.height
                    });
                }
                $img.css('opacity', 1);
            }
        },
        created: function () {
            var context = this;
            fileApi.getImageDownloadToken(function (token) {
                var imageUri = context.message.content.imageUri;
                if (!imageUri) {
                    return;
                }
                if (imageUri.indexOf('?') !== -1) {
                    imageUri += '&token=' + token;
                } else {
                    imageUri += '?token=' + token;
                }
                context.imageUri = common.trans2Localfile(imageUri, 'media');
            });
        }
    };
    utils.asyncComponent(options, resolve, reject);
};
}(RongIM, {
    jQuery: jQuery
}, RongIM.components));
