(function (RongIM, components) {
'use strict';

var common = RongIM.common;
var utils = RongIM.utils;
var dataModel = RongIM.dataModel;

components.getRecallCommandMessage = function (resolve, reject) {
    var im = RongIM.instance;
    var options = {
        name: 'recall-command-message',
        props: ['message', 'groupId', 'isBanned'],
        template: '#rong-template-recall-command',
        data: function () {
            return {
                canEdit: false,
                timer: 0
            };
        },
        mounted: function () {
            var context = this;
            var value = dataModel.Message.getRecallContent(context.message.messageId);
            if (utils.isEmpty(value)) {
                return;
            }
            var timeout = im.config.recallEditTimeout - (Date.now() - value.recallTime);
            if (timeout > 0) {
                context.canEdit = true;
                context.timer = setTimeout(function () {
                    context.canEdit = false;
                }, timeout);
            }
        },
        destroyed: function () {
            clearTimeout(this.timer);
        },
        methods: {
            getRecallCommand: function () {
                return getRecallCommand(this.message, RongIM.instance.auth, this);
            },
            showRecallEdit: function (item) {
                var value = dataModel.Message.getRecallContent(item.messageId);
                if (utils.isEmpty(value)) {
                    return false;
                }
                return value.recallTime > Date.now() - im.config.recallEditTimeout;
            },
            recallEdit: function (item) {
                var value = dataModel.Message.getRecallContent(item.messageId);
                im.$emit('editrecalled', value);
            }
        }
    };
    utils.asyncComponent(options, resolve, reject);
};
/*
说明： 显示撤回消息
       自己撤回的消息显示 "你撤回了一条消息"
       其他人撤回消息显示 "xxx 撤回了一条消息"
*/
function getRecallCommand(message, auth, context) {
    var locale = context.locale;
    var name = common.getGroupUsername(message.user, context.groupId);
    var result = context.localeFormat(locale.message.recallOther, name);
    if (message.content && message.content.isAdmin) {
        // return locale.message.recallAdmin;
        // 禁用管理员撤回与删除用户消息的提示
        return;
    }
    var isMe = message.senderUserId === auth.id;
    if (isMe) {
        result = locale.message.recallSelf;
    }
    return result;
}
}(RongIM, RongIM.components));
