(function (RongIM, components) {
    'use strict';

    var common = RongIM.common;
    var utils = RongIM.utils;
    var dialog = RongIM.dialog;
    var dataModel = RongIM.dataModel;
    var messageApi = dataModel.Message
    var server = RongIM.dataModel.config.dataModel.server;

    components.getRichContentMessage = function (resolve, reject) {
        var options = {
            name: 'rich-content-message',
            props: ['message', 'collect', 'sendCollect'],
            template: '#rong-template-rich-content',
            data: function () {
                return {
                    showUrl: '',
                    group: {
                        id: '',
                        member_avatars: [],
                        member_names: [],
                        member_id_list: []
                    },
                    requestParams:{}
                };
            },
            computed: {
                isJieLong: function () {
                    return this.message.content.extra
                },
                isAgreeGroup:function (params) {
                    if (this.message.content.url.indexOf('contactsGroup/groupChatVal') !== -1) {
                        return true
                    }
                    return false
                },
                user: function () {
                    return this.message.content.user || this.message.user;
                },
                content: function () {
                    var content = $.extend({}, this.message.content);
                    content.id = content.userId;
                    content.avatar = content.imageUri;
                    content.content = utils.encodeHtmlStr(content.content);
                    return content;
                },
                contentUrl: function () {
                    var url = this.message.content.extra ? this.message.content.imageUri : this.message.content.url;
                    var loginInfo = utils.cache.get('loginInfo');
                    var zkxToken = decodeURIComponent(loginInfo.zkxToken);
                    if (url && url.match(/\/taskcenter\//i) != null && loginInfo.RCESESSIONID) {
                        let urlParts = url.split('#');
                        url = urlParts[0] + (
                                urlParts[0].indexOf('?') > 0 ? '&' : '?'
                            ) + "sessionid=" + encodeURIComponent(loginInfo.RCESESSIONID) +
                            "&uid=RY" + loginInfo.zkxEmpId + (
                                urlParts[1] ? ('#' + urlParts[1]) : ''
                            );
                    }
                    return RongIM.config.loginServer + '/sign-bridge.html' +
                        '?target=' + encodeURIComponent(url) +
                        '&empId=' + (loginInfo.zkxEmpId || '') +
                        '&token=' + encodeURIComponent(zkxToken + ';path=/');
                    // return common.encodeUrl(url);
                }
            },
            components: {
                imageLoader: components.getImageLoader,
                avatar: components.getAvatar
            },
            methods: {
                getUsername: common.getUsername,
                userProfile: dialog.user,
                GroupInfo(groupId) {
                    let context = this
                    console.log("groupId", groupId);
                    // groupApi.groupInfo(groupId, function (res) {
                    //     if (!res) {
                    //         return
                    //     }
                    //     console.log("res",res);
                    //     // context.groupsInfo = res
                    //     // var eidlist = [];
                    //     // context.groupsInfo.members.forEach(e => {
                    //     //     eidlist.push(e.id)
                    //     //     if (e.id == context.userInfoUid) {
                    //     //         if (e.jq_status == 3) {
                    //     //             console.log(111);
                    //     //             return context.isshowagree = true
                    //     //         } else if (e.jq_status == 1) {
                    //     //             console.log(22);
                    //     //             return context.isshowagree = false
                    //     //         }
                    //     //     }
                    //     // })
                    //     // if (eidlist.indexOf(context.userInfoUid) == -1) {
                    //     //     console.log(333);
                    //     //     return context.isshowagree = true
                    //     // }
                    // })
                    var httpRequest = new XMLHttpRequest();
                    httpRequest.open('GET', server+'/groups/' + groupId, true);
                    httpRequest.send();
                    httpRequest.onreadystatechange = function () {
                        if (httpRequest.readyState == 4 && httpRequest.status == 200) {
                            var json = httpRequest.responseText;//获取到json字符串，还需解析
                            context.groupsInfo = JSON.parse(json).result;
                            context.group.id = context.groupsInfo.id
                            context.group.avatar = context.groupsInfo.portrait_url;
                            context.group.admin_id = context.groupsInfo.manager_id;
                            context.group.member_id_list = context.groupsInfo.members.map(function (member) {
                                return member.id;
                            });
                            context.group.member_brief = context.groupsInfo.members.map(function (member) {
                                return {
                                    id: member.id,
                                    createDt: member.create_dt
                                };
                            });
                            var xhr = new XMLHttpRequest();
                            xhr.open("POST",  server+'/groups/batch/members', true);
                            xhr.setRequestHeader('Content-Type', 'application/json');
                            xhr.send(JSON.stringify({
                                ids: [context.group.id]
                            }));
                            xhr.onreadystatechange = function () {
                                if (xhr.readyState == 4 && xhr.status == 200) {
                                    var json = xhr.responseText;//获取到json字符串，还需解析
                                    let result = JSON.parse(json).result;
                                    console.log("post", result);
                                    var groupMemberInfo = ((result[0] || {}).member_infos || []);
                                    context.group.member_names = groupMemberInfo.map(function (userItem) {
                                        return userItem.name;
                                    });
                                    context.group.member_avatars = groupMemberInfo.map(function (userItem) {
                                        return userItem.portrait_url;
                                    });
                                }
                            }
                            // groupApi.batchMembers([context.group.id]).then(function (result) {
                            //     console.log("batchMembers--------->", result);
                            //     var groupMemberInfo = ((result[0] || {}).member_infos || []);
                            //     context.group.member_names = groupMemberInfo.map(function (userItem) {
                            //         return userItem.name;
                            //     });
                            //     context.group.member_avatars = groupMemberInfo.map(function (userItem) {
                            //         return userItem.portrait_url;
                            //     });
                            // });
                            console.log(context.group);
                            var eidlist = [];
                            context.groupsInfo.members.forEach(e => {
                                eidlist.push(e.id)
                                if (e.id == context.userInfoUid) {
                                    if (e.jq_status == 3) {
                                        return context.isshowagree = true
                                    } else if (e.jq_status == 1) {
                                        return context.isshowagree = false
                                    }
                                }
                            })
                            if (eidlist.indexOf(context.userInfoUid) == -1) {
                                return context.isshowagree = true
                            }
                        }
                    };
                },
                getRequestParams(url) {
                    if (url.indexOf("?") !== -1) {
                        let str = url.substr(url.indexOf("?") + 1); //截取?后面的内容作为字符串
                        let strs = str.split("&"); //将字符串内容以&分隔为一个数组
                        for (let i = 0; i < strs.length; i++) {
                            this.requestParams[strs[i].split("=")[0]] = decodeURI(strs[i].split("=")[1]); // 将数组元素中'='左边的内容作为对象的属性名，'='右边的内容作为对象对应属性的属性值  
                        }
                    }
                    this.GroupInfo(this.requestParams.groupId)
                    console.log(this.requestParams);
                },
                openAgreeGroup:function () {
                    let that = this
                    dialog.agreeGroup({
                        message: that.message
                    }, function (message) {
                        if (message.isDel) {
                            
                            that.$emit("remove", that.message)
                        } else {
                            that.$emit("sendRichContentMessage", message)
                        }


                    });
                },
                openJieLong: function () {
                    let that = this
                    dialog.buildChain({
                        isEdit: true,
                        message: that.message
                    }, function (message) {
                        if (message.isDel) {
                            
                            that.$emit("remove", that.message)
                        } else {
                            that.$emit("sendRichContentMessage", message)
                        }


                    });
                }
            },
            created: function () {
                console.log(this.message)
                this.getRequestParams(this.message.content.url)
                var context = this;
                var url = common.encodeUrl(this.content.imageUri);
                if (!url) {
                    return;
                }
                context.showUrl = common.trans2Localfile(url, 'richcontent-message');
               
            }
        };
        utils.asyncComponent(options, resolve, reject);
    };

}(RongIM, RongIM.components));