(function (RongIM, dependencies, components) {
    'use strict';
    
    var utils = RongIM.utils;
    var common = RongIM.common;
    
    function transUrl(url) {
        return common.trans2Localfile(url, 'icons');
    }
    
    /*
    说明：头像组件，用于显示头像，包括用户头像、群组头像、文件助手头像等
    */
    
    components.newPaging = function (resolve, reject) {
        var im = RongIM.instance;
        var dataModel = im.dataModel;
        var userApi = dataModel.User;
        var options = {
            name: 'new-paging',
            template: '#new-paging',
            props: {
                // 分页配置
                'page-config': {
                    type: Object, 
                    require: true, 
                    default() {
                        return {
                            pageSize: 10,     //一页的数据条数
                            pageNo: 0,        //当前页的索引
                            total: 0,         //总的数据条数
                            pageTotal: 0      //总的页数
                        }
                    }
                }
            },
            data: function () {
                return {
                    //默认显示
                    showPageNo:3,
                    currentPage:0,
                    goNum: 1
                };
            },
            created: function () {
                this.currentPage = this.pageConfig.pageNo || 0
            },
            computed: {
                //计算总页数，如果传了pageTotal,直接取pageTotal的值，如果传了total，那么根据pageSize去计算
                pageTotal(){
                    const config = this.pageConfig
                    if(config.pageTotal){
                        return config.pageTotal
                    }else {
                        if(config.pageSize && config.total){
                            return Math.ceil(config.total/config.pageSize)
                        }else {
                            return 0
                        }
                    }
                }
            },
            mounted: function () {
                
            },
            methods: {
              goPage(){
                if(this.goNum <= this.pageTotal && this.goNum > 0){
                  this.currentPage = Number(this.goNum);
                  this.$emit('changeCurrentPage',this.currentPage)
                }
              },
                prePage(){
                    this.currentPage -= 1
                    this.$emit('changeCurrentPage',this.currentPage)
                },
                nextPage(){
                    this.currentPage += 1
                    this.$emit('changeCurrentPage',this.currentPage)
                },
                changeCurrentPage(i){
                    this.currentPage = i
                    this.$emit('changeCurrentPage',this.currentPage)
                }
            },
            destroyed: function () {
                // 组件销毁后，取消监听
                if (this.userChanged) userApi.unwatch(this.userChanged);
                if (this.memberChanged) userApi.unwatch(this.memberChanged);
            }
        };
        utils.asyncComponent(options, resolve, reject);
    };
    }(RongIM, null, RongIM.components));
    