(function (RongIM, dependencies, components) {
    'use strict';

    components.publicHome = function (resolve, reject) {
        var utils = RongIM.utils;
        var cache = utils.cache;
        var dataModel = RongIM.dataModel;
        var config = RongIM.config;
        var im = RongIM.instance;
        var options = {
            name: 'publicHome',
            template: 'templates/pub-home.html',
            data: function () {
                return {
                    zkxEmpId: '',
                    sessionid: '',
                    zkxToken: '',
                    getCasTicket_ticket: '',
                    staffId: '',
                    signBridgeUrl: ''
                };
            },
            mounted: function () {
                this.signBridgeUrl = this.$route.params.bridgeUrl;
                this.updateToken();
                window.addEventListener('message', this.receiveMessage);
            },

            beforeDestroy: function () {
                window.removeEventListener('message', this.receiveMessage);
            },

            computed: {
                isWorkApps: function () {
                    return im.$route.path.indexOf('/workApps') > -1;
                },
                isZhkx: function () {
                    return im.$route.path.indexOf('/zhkx') > -1;
                },
                preloadPath: function () {
                    return 'file://' + RongDesktop.workAppsPreloadPath;
                },
                loginToken: function () {
                    return decodeURIComponent(this.zkxToken);
                },
                src: function () {
                    if (this.signBridgeUrl) {
                        return this.signBridgeUrl;
                    }

                    if (!this.zkxToken) return '';

                    if (this.isWorkApps) {
                        return './modules/work/' + (
                            (this.os.indexOf('web') > -1) ? 'index' : 'desktop'
                        ) + '.html?' + utils.getQuerystr({
                            userId: im.auth.id,
                            language: im.config.locale,
                            targetId: im.$route.params.targetId || '',
                            empId: this.zkxEmpId || '',
                            staffId: this.staffId || '',
                            sessionid: this.sessionid || '',
                            zkxToken: this.zkxToken,
                            getCasTicket_ticket: this.getCasTicket_ticket
                        });
                    }

                    if (this.isZhkx) {
                        return this.bridgeUrl(config.zhkxUrl);
                    }
                    return this.bridgeUrl(config.pubHomeUrl);
                },
                os: function () {
                    return utils.getPlatform();
                }
            },
            methods: {
                bridgeUrl: function (pageUrl) {
                    if (pageUrl.match(/\/taskcenter\//i) != null && this.sessionid) {
                        let urlParts = pageUrl.split('#');
                        pageUrl = urlParts[0] + (
                            urlParts[0].indexOf('?') > 0 ? '&' : '?'
                        ) + "sessionid=" + encodeURIComponent(this.sessionid) +
                            "&uid=RY" + this.zkxEmpId + (
                                urlParts[1] ? ('#' + urlParts[1]) : ''
                            );
                    }
                    return config.loginServer + '/sign-bridge.html' +
                        '?target=' + encodeURIComponent(pageUrl) +
                        '&empId=' + (this.zkxEmpId || '') +
                        '&token=' + encodeURIComponent(this.loginToken + ';path=/');
                },
                injectToken: function () {
                    var webview = this.$refs.myview;
                    if (webview && webview.getWebContents) {
                        var context = this;
                        // webview.addEventListener('dom-ready', () => {
                        //     webview.openDevTools()
                        // })
                        webview.addEventListener('new-window', function (event) {
                            var url = event.url;
                            if (url.startsWith('http:') || url.startsWith('https:')) {
                                // 因内容页采用post协议提交，强制替换为首页
                                /*if (url.indexOf('df.cast.org.cn:8088') > -1) {
                                    url = 'http://df.cast.org.cn:8088/portal/r/w?cmd=com.awspaas.user.apps.educatapp_turnToPCDoor';
                                }*/
                                RongIM.system.openByBrowser(context.bridgeUrl(url));
                            }
                        });
                        var ses = webview.getWebContents().session;
                        var token = this.loginToken.split('=');
                        ses.cookies.remove(config.pubHomeUrl, 'JSESSIONID', function () { });
                        ses.cookies.set({
                            url: config.loginServer,
                            name: token[0],
                            value: token[1],
                            path: '/'
                        }, function (err) { });
                        ses.cookies.flushStore(function () { });
                        webview.addEventListener('console-message', function (event) {
                            // console.log(event);
                            console.info({
                                level: event.level,
                                message: event.message,
                                sourceId: event.sourceId,
                                line: event.line
                            });
                        });
                    }
                },
                updateToken: function () {
                    var loginInfo = cache.get('loginInfo');
                    this.zkxEmpId = loginInfo.zkxEmpId;
                    this.sessionid = loginInfo.RCESESSIONID;
                    this.staffId = loginInfo.staffId;
                    var context = this;
                    console.log("loginInfo", loginInfo);
                    dataModel.User.refreshZkxToken(loginInfo.phone, function (err, res) {
                        if (res && res.st) {
                            context.zkxToken = loginInfo.zkxToken = res.st;
                            cache.set('loginInfo', loginInfo);
                            context.injectToken();
                        }
                    });
                    // dataModel.User.getCasTicket(loginInfo.staffId, 'http://xh.cast.org.cn/default/coframe/auth/login/login.jsp', function (err, res) {
                    //     if (res && res.ticket) {
                    //         context.getCasTicket_ticket = res.ticket
                    //     }
                    // })
                },

                receiveMessage: function (event) {
                    console.log('receiveMessage ==> ', event);
                    var origin = event.origin,
                        origins = ['https://xh.cast.org.cn', 'http://111.203.146.54:8080']

                    if (origins.indexOf(origin) == -1) return;

                    var msg = JSON.parse(event.data);
                    if (msg.msgType == 'share') {
                        this.handleShare(msg.msgContent);
                    }
                },

                handleShare: function (data) {
                    var msg = {
                        title: data.title,
                        content: data.content,
                        imageUri: data.imageUrl,
                        url: data.url,
                        messageName: 'RichContentMessage',
                    };
                    RongIM.dialog.forwardDialog({ content: msg }, "forward");
                }
            }
        };
        utils.asyncComponent(options, resolve, reject);
    };

}(RongIM, null, RongIM.components));