/*
说明：设置 - 内容页(帐号)
功能：
    1. 显示个人信息
    2. 退出登录
    3. 外部联系人修改姓名
*/
(function (RongIM, components) {
'use strict';

var common = RongIM.common;
var utils = RongIM.utils;

// 60s 验证码计时器
var countDownInterval;

components.getSettingAccount = function (resolve, reject) {
    var im = RongIM.instance;
    var dataModel = im.dataModel;
    var userApi = dataModel.User;
    var options = {
        name: 'setting-account',
        template: '#rong-template-account',
        computed: {
            account: function () {
                return im.loginUser;
            },
            // 是否是外部联系人
            isStaff: function () {
                return im.loginUser.type === common.UserType.STAFF;
            },
            myName: function () {
                return this.username || im.loginUser.name;
            }
        },
        watch: {
            usernameEditable: function (val) {
                if (val && !this.username) {
                    this.username = im.loginUser.name;
                }
            }
        },
        data: function () {
            return {
                username: '',
                userphone: '',
                usercode: '',
                newPhone: '',
                phonePass: false,
                codePass: false,
                // 是否是修改手机号模式
                userphoneEditable: false,
                // 是否是验证码模式
                userCodeEditable: false,
                // 是否可编辑用户名
                usernameEditable: false,
                countDown: 0,
                // 错误提示集合
                error: {
                    phone: '',
                    code: ''
                }
            };
        },
        components: {
            avatar: components.getAvatar
        },
        directives: {
            focus: {
                inserted: function (el) {
                    el.focus();
                }
            }
        },
        deactivated: function () {
            this.usernameEditable = false;
            this.userphoneEditable = false;
        },
        methods: {
            format: function (mobile) {
                return mobile.replace(/(\d{3})(\d{4})(\d{4})/, '$1 $2 $3');
            },
            logout: function () {
                  // debugger
                  var keys = document.cookie.match(/[^ =;]+(?=\=)/g);
                  if (keys) {
                      for (var i = keys.length; i--;)
                          document.cookie = keys[i] + '=0;expires=' + new Date(0).toUTCString()
                  }
                var context = this;
                common.messagebox({
                    // type: 'confirm',
                    title: context.locale.quitTitle,
                    message: context.locale.quitMessage,
                    callback: function () {
                        
                        context.$emit('close');
                        im.logout();
                    }
                });
                      
            },
            // 重置用户名
            // 添加延迟调用，防止点击关闭之前触发blur事件，提交更改；
            setUsername: function () {
                var context = this;
                setTimeout(function () {
                    // 阻止esc退出之后触发设置
                    if (!context.usernameEditable) return;

                    var flag = false;
                    var name = context.username;
                    var userId = context.account.id;
                    var regExp = /^([a-zA-z]|[0-9]|[\u4e00-\u9fa5])$/;

                    flag = name.split('').some(function (item) {
                        var islegal = regExp.test(item);
                        return !islegal;
                    });
                    if (!name.length || flag) {
                        common.messageToast({
                            message: context.locale.components.settingAccount.transfiniteMessage,
                            type: 'error'
                        });
                        return;
                    }
                    // TODO  setUsername 根据后端接口所需参数修改

                    userApi.setUsername(userId, name, function (errorCode) {
                        if (errorCode) {
                            context.toastError(errorCode);
                            return;
                        }
                        Vue.set(context.account, 'name', context.username);
                        context.usernameEditable = false;
                        // 修改后
                    });
                }, 100);
            },
            // 取消重置用户名
            cancelUsername: function () {
                var context = this;
                context.usernameEditable = false;
                context.username = im.loginUser.name;
            },
            // 取消修改手机号
            cancelUserphone: function () {
                var context = this;

                context.userphoneEditable = false;
                context.userphone = '';
                context.phonePass = false;
                context.setPass('code', '');
                context.setPass('phone', '');
            },
            // 取消输入验证码
            cancelUsercode: function () {
                var context = this;

                context.userCodeEditable = false;
                context.usercode = '';
                context.setPass('code', '');
                context.clearPass('phone');
            },
            // 提示16个字符以内
            inputUserName: function (e) {
                var context = this;
                var val = e.target.value;
                if (val.length >= 16) {
                    common.messageToast({
                        message: context.locale.components.settingAccount.errorMessage,
                        type: 'error'
                    });
                }
            },
            // 展示修改手机号
            openSetPhone: function () {
                this.userphoneEditable = true;
                this.userCodeEditable = false;
            },
            // input获取焦点
            focus: function () {
                this.setPass('phone', '');
                this.setPass('code', '');
            },
            // 清空pass
            clearPass: function (key) {
                this[key + 'Pass'] = true;
                this.error[key] = '';
            },
            // 设置pass
            setPass: function (key, err) {
                this[key + 'Pass'] = false;
                this.error[key] = err;
            },
            // 手机号校验
            inputPhone: function(e) {
                var context = this;
                var val = e.target.value;
                var regExp =  /^(13[0-9]|14[01456879]|15[0-35-9]|16[2567]|17[0-8]|18[0-9]|19[0-35-9])\d{8}$/;
                if(val == context.account.mobile) {
                    context.setPass('phone', context.locale.components.settingAccount.setPhoneText)
                }else if(regExp.test(val)) {
                    context.clearPass('phone');
                } else if(val == '') {
                    context.setPass('phone', context.locale.components.settingAccount.phoneNull)
                } else {
                    context.setPass('phone', context.locale.components.settingAccount.errorPhoneMessage)
                }
            },
            // 重新发送验证码
            anewSendCode: function() {
                var context = this;

                // context.clearPass('code');
                context.sendCode();
            },
            // 发送验证码
            sendCode: function() {
                var context = this;
                
                setTimeout(function () {
                    var flag = false;
                    var phone = context.userphone;
                    var userId = context.account.id;
                    var regExp =   /^(13[0-9]|14[01456879]|15[0-35-9]|16[2567]|17[0-8]|18[0-9]|19[0-35-9])\d{8}$/;

                    flag = phone.split('').some(function (item) {
                        var islegal = regExp.test(phone);
                        return !islegal;
                    });
                    if (!phone.length || flag) {
                        common.messageToast({
                            message: context.locale.components.settingAccount.errorPhoneMessage,
                            type: 'error'
                        });
                        return;
                    }
                    // TODO  setUsername 根据后端接口所需参数修改

                    userApi.changePhone_send_code(phone, userId, function (errorCode) {
                        if (errorCode) {
                            context.toastError(errorCode);
                            return;
                        }

                        context.startCountDownInterval();
                        context.clearPass('phone');

                        context.userphoneEditable = true;
                        context.userCodeEditable = true;
                    });
                }, 100);
            },
            // 验证码校验
            inputCode: function(e) {
                var context = this;
                var val = e.target.value;

                if(val.length == 0) {
                    context.setPass('code', context.locale.components.settingAccount.errorNullCodeMessage);
                } else {
                    context.clearPass('code');
                }
            },
            // 修改用户手机号请求
            changPhone: function() {
                var context = this;
                
                setTimeout(function () {
                    // 阻止esc退出之后触发设置
                    if (!context.codePass) return;

                    var flag = false;
                    var code = context.usercode;
                    var phone = context.userphone;
                    var userId = context.account.id;

                    if (!phone.length) {
                        common.messageToast({
                            message: context.locale.components.settingAccount.errorNullCodeMessage,
                            type: 'error'
                        });
                        return;
                    }
                    // TODO  setUsername 根据后端接口所需参数修改

                    userApi.change_phone(userId, phone, code, function (errorCode) {
                        if (errorCode) {
                            context.toastError(errorCode);
                            return;
                        }
                        common.messageToast({
                            message: context.locale.components.settingAccount.successPhoneMessage
                        });

                        Vue.set(context.account, 'mobile', phone);

                        context.startCountDownInterval();
                        context.clearPass('code');

                        context.usercode = '';
                        context.userphone = '';
                        context.userphoneEditable = false;
                        context.userCodeEditable = false;
                    });
                }, 100);
            },

            // 关闭验证码计时器
            closeCountDownInterval: function() {
                countDownInterval && clearInterval(countDownInterval);
                countDownInterval = undefined;

                this.newPhone = '';
                this.countDown = 0;
            },
            // 启动验证码计时器
            startCountDownInterval: function() {
                var context = this;

                context.closeCountDownInterval();
                context.countDown = 60;
                context.newPhone = context.userphone;
                countDownInterval = setInterval(() => {
                    if(context.countDown > 0) {
                        context.countDown --
                    }
                    else if(context.countDown <= 0) {
                        context.closeCountDownInterval();
                    }
                }, 1000);
            }
        }
    };
    utils.asyncComponent(options, resolve, reject);
};
}(RongIM, RongIM.components));
