/*
说明：设置 - 主框架
功能：
    1. 切换设置页显示内容
*/
(function (RongIM, components) {
    'use strict';

    var common = RongIM.common;

    RongIM.dialog.setting = function (path) {
        var im = RongIM.instance;
        var options = {
            name: 'setting',
            template: '#rong-template-setting-layout',
            data: function () {
                return {
                    show: true,
                    currentView: path && typeof path == 'string' ? path : 'account',
                    externalPageUrl: '',
                    dialogSize: {},
                    fullOrCancelScreen: 'full-screen',
                    product: im.locale.product || {}
                };
            },
            components: {
                account: components.getSettingAccount,
                password: components.getSettingPassword,
                system: components.getSettingSystem,
                about: components.getSettingAbout,
                email: components.getSettingEmail,
                phone: components.getSettingPhone,
                help: components.getSettingHelp,
                postInfo: components.getSettingPostInfo,
            },
            computed: {
                showAbout: function () {
                    return RongIM.system.platform !== 'darwin';
                }
            },
            methods: {
                openDevtool: function () {
                    RongIM.browserWindow.toggleDevTools();
                },
                setCurrentView: function (name) {
                    console.log(name)
                    this.currentView = name;
                    this.externalPageUrl = '';
                    //this.dialogSize = {};
                },
                setExternalPage: function (name) {
                    var externalPageName = {
                        help: 'liucheng',
                        contacts: 'linkus'
                    }
                    this.currentView = name;
                    this.externalPageUrl = 'http://111.203.146.94/help/' + externalPageName[name] + '.html';
                    /*this.dialogSize = {
                        width: '80%',
                        height: '80%'
                    };*/
                },
                close: function () {
                    this.show = false;
                },
                fullOrCancelScreenFun: function () {
                    this.fullOrCancelScreen = this.fullOrCancelScreen === 'full-screen' ? 'cancel-full-screen' : 'full-screen'
                    this.dialogSize = this.fullOrCancelScreen === 'full-screen' ? {} : {
                        width: '100%',
                        height: '94%'
                    }
                }
            }
        };

        common.mountDialog(options, function (dialog) {
            im.$watch('$route', function () {
                dialog.show = false;
            });
        });
    };
}(RongIM, RongIM.components));
