/*
说明：设置 - 内容页(修改密码)
功能：
    1. 修改密码
*/
(function (RongIM, components) {
'use strict';

var common = RongIM.common;
var utils = RongIM.utils;

components.getSettingPassword = function (resolve, reject) {
    var im = RongIM.instance;
    var dataModel = im.dataModel;
    var options = {
        name: 'setting-password',
        template: '#rong-template-password',
        data: function () {
            return {
                busy: false,
                oldPassword: null,
                newPassword: null,
                confirmPassword: null
            };
        },
        computed: {
            disabled: function () {
                return utils.isEmpty(this.oldPassword)
                    || utils.isEmpty(this.newPassword)
                    || utils.isEmpty(this.confirmPassword);
            }
        },
        mixins: [
            components.getValidate()
        ],
        methods: {
            submit: function () {
                var context = this;
                if (!context.valid() || context.busy) {
                    return;
                }
                var userApi = dataModel.User;
                var params = {
                    newPassword: context.newPassword,
                    oldPassword: context.oldPassword
                };
                if (context.newPassword === context.oldPassword) {
                    context.$set(context.errors, 'newPassword', context.locale.errorCode['new-password-same-old-password']);
                    return;
                }
                context.busy = true;
                // 2019-06-12 密码加密传输 userApi.changePassword 改为 securityChangePassword
                userApi.changePassword(params, function (errorCode) {
                    context.busy = false;
                    if (errorCode) {
                        var errDes = common.getErrorMessage(errorCode);
                        // 同一个错误码 在设置密码时 提示信息不一样
                        if (errorCode === 10101) {
                            errDes = context.locale.errorCode['old-password-error'];
                        }
                        context.$set(context.errors, 'oldPassword', errDes);
                    }
                });
            }
        }
    };
    utils.asyncComponent(options, resolve, reject);
};
}(RongIM, RongIM.components));
