/*
说明：设置 - 内容页(系统)
功能：
    1. 查看版本信息
    2. 查看版本功能介绍
*/
(function (RongIM, components, RongWork) {
    'use strict';

    var utils = RongIM.utils;
    var cache = utils.cache;
    var browserWindow = RongIM.browserWindow;

    components.getSettingPostInfo = function (resolve, reject) {
        var im = RongIM.instance;
        var options = {
            name: 'setting-postInfo',
            template: '#rong-template-postInfo',
            data: function () {
                return {

                };
            },
            mounted() {
                const context = this
                //http://111.203.146.54:8080/default/taskcenter/index.html#/zgkx/queryFromPage/index
                // openExternal(
                //     'https://xh.cast.org.cn/default/taskcenter/index.html#/zgkx/queryFromPage/index',
                //     true
                // );
                Vue.nextTick(function () {
                    if (context.$refs.postInfo) {
                        var browser = context.$refs.postInfo;
                        initBrowser(browser, {}, context, context.bridgeUrl(`https://xh.cast.org.cn/default/taskcenter/index.html#/zgkx/queryFromPage/index`));
                    }
                });
                // const loginInfo = cache.get('loginInfo')
                // browserWindow.openPSArticle(context.bridgeUrl(`https://xh.cast.org.cn/default/taskcenter/index.html#/zgkx/queryFromPage/index`))
            },
            methods: {
                reload: function () {
                    var postInfo = this.$refs.postInfo;
                    postInfo.reload();
                },
                openPage() {
                    browserWindow.openPSArticle('https://xh.cast.org.cn/default/taskcenter/index.html#/zgkx/queryFromPage/index')
                },
                bridgeUrl: function (pageUrl) {
                    const loginInfo = cache.get('loginInfo')
                    let token = decodeURIComponent(loginInfo.zkxToken) + ';path=/';
                    return 'https://sso.cast.org.cn/sign-bridge.html' +
                        '?target=' + encodeURIComponent(pageUrl) +
                        '&empId=' + '' +
                        '&token=' + encodeURIComponent(token);
                },
            }
        };
        utils.asyncComponent(options, resolve, reject);
    };
    function initBrowser(browser, query, context, url) {
        var loginInfo = RongIM.utils.cache.get('loginInfo');
        query = RongIM.utils.getQuerystr({
            zkxToken: loginInfo.zkxToken,
            empId: loginInfo.zkxEmpId || '',
            sessionid: loginInfo.RCESESSIONID || '',
        });
        if (browser.getWebContents && query.zkxToken) {
            var ses = browser.getWebContents().session;
            var token = decodeURIComponent(query.zkxToken).split('=');
            ses.cookies.remove(query.url, 'JSESSIONID', function () { });
            ses.cookies.set({
                url: RPSA.loginServer,
                name: token[0],
                value: token[1],
                path: '/'
            }, function (err) { });
            ses.cookies.flushStore(function () { });
        }
        browser.src = url;
        browser.addEventListener('did-navigate', function () {
            context.canGoBack = browser.canGoBack();
        });
        browser.addEventListener('new-window', function (event) {
            var url = event.url;
            if (url.startsWith('http:') || url.startsWith('https:')) {
                browserWindow.openLocaleBrowser(context.bridgeUrl(url, query));
            }
        });
    }
}(RongIM, RongIM.components));

