/*
说明：设置 - 内容页(系统)
功能：
    1. 设置系统消息提示
    2. 设置语言
*/
(function (RongIM, components) {
'use strict';

var utils = RongIM.utils;
var cache = utils.cache;
var common = RongIM.common;
var Http = RongIM.dataModel._Http;
var CacheAuth = RongIM.dataModel._Cache;
components.getSettingSystem = function (resolve, reject) {
    var im = RongIM.instance;
    var orgApi = im.dataModel.Organization;
    var userApi = im.dataModel.User;
    var groupApi = im.dataModel.Group;
    var messageKey = 'sysMessage';
    var supportLocales = [];
    $.each(RongIM.locale, function (key, locale) {
        supportLocales.push({
            value: key,
            name: locale.name
        });
    });
    var options = {
        name: 'setting-system',
        template: '#rong-template-system',
        data: function () {
            return {
                enable_care:CacheAuth.auth.enable_care == 1? true : false,
                downloadPath: '',
                openInvita:'',
                userInfo:'',
                playSound: !!cache.get(messageKey),
                // shortCut: !!cache.get('sysShortcut'),
                language: im.config.locale,
                supportLocales: supportLocales,
                product: im.locale.product || {},
                companies: [],
                selectedCompanyId: '',
                autoStartText: '',
                autoStart: RongIM.system.getAutoLaunch(),
                showPreview: !!cache.get('showPreview'),
                isPC: !RongIM.system.platform.startsWith('web'),
                isMac: RongIM.system.platform.startsWith('darwin'),
                isWindows: RongIM.system.platform === 'win32',
                isWindowsWeb: RongIM.system.platform === 'web-win32',
                isMacWeb: RongIM.system.platform === 'web-darwin'
            };
        },
        components: {
            customSelect: components.customSelect
        },
        watch: {
            enable_care:function(newval){
                console.log(newval,44444444)
                this.openEnableCare(newval);

            },
            openInvita: function (newVal) {
                this.OpenInvita();
            },
            playSound: function (newVal) {
                cache.set(messageKey, newVal);
            },
            language: function (lang) {
                cache.set('locale', lang);
                im.locale.product.productName = im.config.product.name[lang];
                im.config.locale = lang;
                document.title = im.locale.product.productName;
                RongIMLib.RongIMEmoji.setConfig({ lang: im.config.locale });
                RongIM.system.setLanguage(im.config.locale);
                eventBus.$emit('langChange', lang);
            },
            selectedCompanyId: function (newVal) {
                var oldCompanyId = im.auth.companyId;
                if (!newVal || newVal === oldCompanyId) {
                    return;
                }
                var context = this;
                userApi.updateMajorCompany(newVal, function (errorCode) {
                    if (errorCode) {
                        common.toastError(errorCode);
                        // 恢复原值
                        context.selectedCompanyId = oldCompanyId;
                        return;
                    }
                    // clone 对象写缓存，auth.companyId 被值变更被监听，故先 copy 写缓存后重新赋值
                    var clone = JSON.parse(JSON.stringify(im.auth));
                    clone.companyId = newVal;
                    cache.set('auth', clone, true);
                    im.auth.companyId = newVal;
                });
            },
            autoStart: function (newVal) {
                RongIM.system.setAutoLaunch(newVal);
            },
            showPreview: function (newVal) {
                cache.set('showPreview', newVal);
            },
            locale: function () {
                this.autoStartText = this.localeFormat(this.locale.autoStart, im.config.product.name[im.config.locale]);
            }
            // shortCut: function(newVal){
            //     cache.set('sysShortcut', newVal);
            // }
        },
        mounted: function () {
            var orgsInfo = im.auth.orgsInfo;
            this.userInfo = im.auth.id
            console.log("userInfo=====>",this.userInfo);
            this.batchFromServer(im.auth.id)
            this.companies = getOrgsInfoCompanies(orgsInfo, orgApi);
            this.selectedCompanyId = im.auth.companyId;
            this.autoStartText = this.localeFormat(this.locale.autoStart, im.config.product.name[im.config.locale]);
            // this.autoStart = RongIM.system.getAutoLaunch();
            console.log(RongIM.downloader.getSaveFolder())
            console.log(RongIM);
            if (RongIM.downloader && RongIM.downloader.getSaveFolder) {
                this.downloadPath = RongIM.downloader.getSaveFolder();
            }
        },
        methods: {
            batchFromServer(id){
                let that = this ;
                userApi.batchFromServer(id,function (err,res) {
                    that.openInvita = (res.data[0].invita_state==1?true:false)                    // console.log(111,that.openInvita);
                  })
            },
            OpenInvita:function () {
                let params = (this.openInvita?1:0);
                groupApi.OpenInvita(this.userInfo,params,function (res) {
                    if (res.code !== 10000) {
                        return
                    }
                })
            },
            openEnableCare:function(newval){
                var params = { uid:CacheAuth.auth.id, careStatus:newval ? 1 : 0 }
                Http.post(`/user/enable_care`, params, function (errorCode, result) {
                    if (result){
                        CacheAuth.auth.enable_care = newval ? 1 : 0 
                        if (newval) {
                            document.documentElement.style.setProperty('--font-size','18px')
                            document.documentElement.style.setProperty('--height-big','80px')

                        } else {
                            document.documentElement.style.setProperty('--font-size','14px')
                            document.documentElement.style.setProperty('--height-big','50px')

                        }
                    }
                })
            },
            sysMessage: function () {
                cache.set(messageKey, this.playSound);
            },
            showFileDialog: function() {
                if (RongIM.downloader && RongIM.downloader.setSaveFolder) {
                    var that = this;
                    RongIM.downloader.setSaveFolder(function (path) {
                        that.downloadPath = path;
                    });
                }
            },
        }
    };
    utils.asyncComponent(options, resolve, reject);
};

function getOrgsInfoCompanies(orgsInfo, orgApi) {
    var companies = [];
    orgsInfo = orgsInfo || [];
    var tempCache = {};
    orgsInfo.forEach(function (orgInfo) {
        // 判断第二级是否是独立子公司，是则从独立子公司开始计算
        var company = orgInfo.path[0] || {};
        var subcompany = orgInfo.path[1];
        var isAutomy = subcompany && orgApi.isAutonomyCompany(subcompany.id);
        if (isAutomy) {
            company = subcompany;
        }
        var existed = tempCache[company.id];
        if (!existed) {
            tempCache[company.id] = true;
            companies.push({
                id: company.id,
                name: company.name
            });
        }
    });
    return companies;
}
}(RongIM, RongIM.components));
