(function (RongIM, dependencies, components) {
'use strict';

var utils = RongIM.utils;

components.getSyncdataLoading = function (resolve, reject) {
    var options = {
        name: 'syncdata-loading',
        template: '#rong-template-syncdata-loading',
        props: ['per', 'state'],
        data: function () {
            return {
                count: null,
                btnRefresh: '刷新',
                successOpacity: 1,
                showFail: false,
                pieSuccess: false
            };
        },
        watch: {
            state: function (newVal, oldVal) {
                if (newVal === oldVal) {
                    return;
                }
                this.showFail = false;
                this.successOpacity = 1;
                if (newVal === 'success') {
                    this.success();
                }
                if (newVal === 'failed') {
                    this.showFail = true;
                }
            }
        },
        computed: {
            getProcess: function () {
                return Number((this.per * 100).toFixed(2)) + '%';                                                                                                                                                                                                                                                                                                                                                                                   
            },
            showTips: function () {
                var context = this;
                if (context.showFail) {
                    return context.locale.failed;
                }
                var tips = context.locale.process;
                if (context.per === 1) {
                    tips = context.locale.completed;
                }
                return tips;
            },
            pathRight: function () {
                var percent = this.per;
                if (percent === 1) {
                    percent = 0.9999;
                }
                var r = 91;
                var degrees = percent * 360;
                var rad = degrees * (Math.PI / 180);
                var x = (Math.sin(rad) * r).toFixed(2);
                var y = -(Math.cos(rad) * r).toFixed(2);
                var lenghty = window.Number(degrees > 180);
                var path = ['M', 0, -r, 'A', r, r, 0, 0, 1, x, y];
                if (lenghty) {
                    path = ['M', 0, -r, 'A', r, r, 0, 0, 1, 0, r];
                }
                path = path.join(' ');
                return path;
            },
            pathLeft: function () {
                var percent = this.per;
                if (percent === 1) {
                    percent = 0.9999;
                }
                var r = 91;
                var degrees = percent * 360;
                var rad = degrees * (Math.PI / 180);
                var x = (Math.sin(rad) * r).toFixed(2);
                var y = -(Math.cos(rad) * r).toFixed(2);
                var lenghty = window.Number(degrees > 180);
                var path = ['M', 0, r, 'A', r, r, 0, 0, 1, x, y];
                if (!lenghty) {
                    path = ['M', 0, r, 'A', r, r, 0, 0, 1, 0, r];
                }
                path = path.join(' ');
                return path;
            },
            touch: function () {
                var percent = this.per;
                if (percent === 1) {
                    percent = 0.9999;
                }
                var r = 90;
                var degrees = percent * 360;
                var rad = degrees * (Math.PI / 180);
                var x = (Math.sin(rad) * r).toFixed(2);
                var y = -(Math.cos(rad) * r).toFixed(2);
                return {
                    x: x,
                    y: y
                };
            }
        },
        mounted: function () {
            if (this.state === 'success') {
                this.success();
            }
        },
        methods: {
            success: function () {
                var context = this;
                setTimeout(function () {
                    var interval = setInterval(function () {
                        context.successOpacity -= 0.1;
                        if (context.successOpacity <= 0) {
                            clearInterval(interval);
                            context.$emit('finished');
                        }
                    }, 100);
                }, 500);
            },
            retryHandle: function () {
                this.$emit('retry');
            }
        }
    };
    utils.asyncComponent(options, resolve, reject);
};
}(RongIM, {
    jQuery: jQuery
}, RongIM.components));
