(function (RongIM, dependencies, components) {
    'use strict';
    console.log("kxy-right");
    var utils = RongIM.utils;
    var dialog = RongIM.dialog;
    var common = RongIM.common;
    var $ = dependencies.jQuery;
    var pageNum = RongIM.config.profile.pageNum;
    var cache = utils.cache;
    var debounceSearch = utils.debounce(search, 300);
    components.kxyRight = function (resolve, reject) {
        var im = RongIM.instance;
        var publicTreeView = RongIM.treeView;
        var orgApi = im.dataModel.Organization;
        var options = {
            name: 'kxy-right',
            template: '#kxy-right',
            data: function () {
                return {
                    auth: im.auth,
                    deptName: '',
                    company: {},
                    breadcrumb: [],
                    allMembers: [],
                    allDepts: [],
                    allCompanies: [],
                    loadingNextPage: false,
                    lastIndex: 0,
                    allList: [],
                    itemParams: null,
                    applyList: {},
                    myOrgList: {},
                    count: 0,
                    showDepts: false,
                    isShowLoad: true,
                    keyword: '', //搜索条件
                    searchText: '', //搜索条件临时存放
                    orgIdOld: this.itemParams, //orgId临时存放（用于返回搜索结果）
                    isSearch: false, //是否搜索组织云
                    searchOrg: [],
                    showAll: true,
                    showOrgs: false,
                    showUsers: false,
                    tabList: [{
                        id: 1,
                        name: '全部'
                    }, {
                        id: 2,
                        name: '联系人'
                    }, {
                        id: 3,
                        name: '部门'
                    }],
                    tabActive: 1,
                    minTimestamp_org: 0,
                    minTimestamp_user: 0,
                    allDeptsCount: 0,
                    allMemberCount: 0,
                    showSearchRecord: false,
                    inputIsFocus: false,
                    recordList: [],
                    itemParamsNew: {},
                    showBack: false,
                    showSearch: false,
                    isSearchEmpty: false,
                    hasMore_user: true,
                    hasMore_org: true,
                    isBackSearch: false,
                    breadcrumbOld: [],
                    timer: null,
                    page: 1,
                    size: pageNum,
                    hasMore: true,
                    maxId: 0,
                    useNewDeptTemp: false, // 使用新部门模板
                    open:false,   //是否打开折叠展示
                    maxIdStaff:0,
                    maxIdOrg:0
                };
            },
            props: {
                itemdata: {
                    type: Object,
                    default: () => {}
                },
                eventtarger: {
                    type: Object,
                    default: () => {}
                },
                cancelfollowitemdata: {
                    type: Object,
                    default: () => {}
                },
                offsetX: Number
            },
            created() {
                this.itemParams = this.itemdata;
                // this.init(this.itemParams)
            },
            computed: {
                coId: function () {
                    var coId = this.itemParams.id;
                    return coId;
                },
                orgId: function () {
                    var coId = this.itemParams.id;
                    var orgId = this.itemParams.id;
                    return orgId || coId;
                },
                type: function () {
                    var coType = common.OrgType.COMPANY;
                    var orgType = +this.itemParams.type;
                    return orgType || coType;
                },
                members: function () {
                    if (this.isSearch) {
                        return this.allMembers;
                    }
                    if (this.allMembers.length < this.lastIndex) {
                        return this.allMembers;
                    }
                    return this.allMembers.slice(0, this.lastIndex);
                },
                depts: function () {
                    var length = this.allMembers.length + this.allDepts.length;
                    if (this.lastIndex < this.allMembers.length) {
                        return [];
                    }
                    if (this.lastIndex > this.allMembers.length && this.lastIndex < length) {
                        return this.allDepts.slice(0, this.lastIndex - this.allMembers.length);
                    }
                    return this.allDepts;
                },
                setDepts: function () {
                    let that = this;
                    let arr = that.inspectIsFollow(that.depts);
                    return arr;
                },
                companies: function () {
                    var _length = this.allMembers.length + this.allDepts.length;
                    if (this.lastIndex < _length) {
                        return [];
                    }
                    return this.allCompanies.slice(0, this.lastIndex - _length);
                },
                showEmpty: function () {
                    if (!this.isSearch || this.isShowLoad) {
                        return false;
                    }
                    if (this.tabActive == 1 && this.allMemberCount == 0 && this.allDeptsCount == 0) {
                        return true
                    } else if (this.tabActive == 2 && this.allMemberCount == 0) {
                        return true
                    } else if (this.tabActive == 3 && this.allDeptsCount == 0) {
                        return true
                    } else {
                        return false
                    }

                },
                memberSearchResult() {
                    let members = this.members;
                    return this.showAll ? members.filter((obj,num) => num < 5) : members;
                },
                deptSearchResult() {
                    let allDepts = this.allDepts;
                    return this.showAll ? allDepts.filter((obj,num) => num < 5) : allDepts
                }
            },
            mounted: function () {
                var context = this;
                // initData(context, orgApi);

                context.deptWatch = function () {
                    // getDept(context, orgApi);
                };
                orgApi.watch(context.deptWatch);
            },
            watch: {
                cancelfollowitemdata: function (newVal) {
                    this.applyList[newVal.id] = undefined;
                },
                keyword: function (v) {
                    if (v) {
                        this.searchText = v;
                        debounceSearch(this)
                    } else {
                        // if (!this.isSearch) {
                        //     return;
                        // }
                        if (!this.showBack) this.clear();
                    }
                    this.hasMore_user = true;
                    this.hasMore_org = true;
                    this.maxIdStaff = 0;
                    this.maxIdOrg = 0;
                }
            },
            methods: {
                gofold(index){
                    console.log(index);
                    if (document.getElementById(index).style.display=='none') {
                        document.getElementById(index).style.display='block'
                    }
                    else{
                        document.getElementById(index).style.display='none'
                    }
                },
                inspectIsFollow(followList) {
                    let that = this;

                    let newArr = followList.map((element, index) => {
                        if (that.applyList[element.id] != undefined && element.vchar_p3 < 3) {
                            this.$set(element, "isFollow", 0)
                        } else if (element.vchar_p3 < 3 && (that.myOrgList[element.id] == undefined)) {
                            this.$set(element, "isFollow", 2)
                        }
                        return element
                    });
                    return newArr
                },
                init(newVal) {
                    this.showSearch = true
                    this.itemParams = newVal;
                    this.itemParamsNew = newVal;
                    if (newVal.rootType == 'KXY') {
                        this.keyword = ''
                        this.isSearch = false
                        // initData 中将调用 this.getApplyList() 
                        initData(this, orgApi);
                    }
                },
                userProfile: dialog.user,
                getUsername: common.getUsername,
                getRoute: getRoute,
                getTypeName: common.getGroupType,
                departIconClass: function (item) {
                    return (item.vchar_p3 == 1) ? 'rong-dept-blue-icon' : 'rong-dept-icon';
                },
                getDutyName: function (item) {
                    if (this.isSearch) {
                        if (item.mainDepart == 1) {
                            return item.duty_name
                        }
                        if (item.vchar_p3) {
                            let obj = item.vchar_p3.split(',').filter(obj => obj.indexOf(item.parent_id) > -1)
                            if (obj.length > 0) {
                                return obj[0].split(':')[1]
                            }
                        }

                    }
                    return (item.extDuties && this.orgId) ? item.extDuties[this.orgId] : item.dutyName;
                },
                showPath: function (item) {
                    if (this.isSearch && item.path) {
                        if (item.mainDepart == 1 && item.duty_name != "") {
                            return true
                        }
                        if (item.vchar_p3) {
                            let obj = item.vchar_p3.split(',')[0]
                            if (obj.split(':')[1] != '') {
                                return true;
                            }
                        }
                    }
                    return false
                },
                memberCount: function (item) {
                    var staffCount = item.staff_count || item.member_count;
                    var format = (staffCount == 1) ? this.locale.contact.personSingle : this.locale.contact.person;
                    return this.localeFormat(format, staffCount);
                },
                isAutonomyCompany: function (item) {
                    return orgApi.isAutonomyCompany(item.id);
                },
                loadMore: function () {
                    loadMore(this, orgApi);
                },
                itemOrg(item) {

                    var context = this;
                    context.itemParams = item;
                    context.keyword = ''
                    if (context.isSearch) {
                        context.showBack = true;
                    }
                    // if (context.isSearch) {
                    //     context.showBack = true;
                    // } else {
                    //     context.showBack = false;
                    // }
                    context.isSearch = false;
                    initData(context, orgApi);
                    context.deptWatch = function () {
                        // getDept(context, orgApi);
                    };
                    orgApi.watch(context.deptWatch);
                },
                //取消关注
                cancelFollow(item, index) {
                    let tree = $('#fixTree');
                    let nodeid = $("." + item.id).attr('data-nodeid');
                    let node = tree.treeview('getNode', nodeid);
                    let that = this,
                        params = {
                            uid: RongIM.instance.auth.id,
                            alias: this.itemdata.text
                        };
                    orgApi.cancelFollow(item.id, params, function (err) {
                        if (!err) {
                            item.isFollow = 2;
                            that.getApplyList()
                            that.getMyFollow1();
                            // that.$emit('cancelfollowitem', node);
                            common.messageToast({
                                type: 'success',
                                message: "取消关注成功！"
                            });
                        }
                    })
                },

                //关注
                itemFollow(item, index) {
                    if (item.isFollow != 2) return;
                    let that = this;

                    dialog.followReason(item, (tips, content) => {
                        if (tips == 'clean') return false;

                        if (content.alias == '') {
                            common.messageToast({
                                type: 'error',
                                message: RongIM.locale.zh.blish.addFollowTips
                            });
                            return false;
                        }

                        if (that.applyList[item.id] == undefined && tips == 'determine' && content.alias != '') {
                            let params = {
                                uid: RongIM.instance.auth.id,
                                alias: content.alias || '',
                                remark: content.remark || ''
                            };

                            orgApi.applyFollow(item.id, params, err => {
                                if (!err) {
                                    item.isFollow = 0;
                                    that.getApplyList();
                                    that.getMyFollow1(item);
                                    that.setDepts = this.inspectIsFollow(that.setDepts)
                                    that.applyList[item.id] = item;
                                }
                            })
                        }
                        // setTimeout(function () {
                        //     that.count = 0;
                        // }, 3000)
                    })
                },
                //获取关注的list
                getApplyList() {
                    if (!this.itemParams || this.applyList[this.itemParams.id] == undefined) {
                        let that = this,
                            params = {
                                focustate: '0,1'
                            };
                        orgApi.getMyfollow(RongIM.instance.auth.id, params, function (result) {
                            that.applyList = {};
                            result.data.forEach((element, index) => {
                                that.applyList[element.id] = element;
                            })
                        });
                    }
                    if (!this.itemParams || this.myOrgList[this.itemParams.id] == undefined) {
                        this.getMyOrganization()
                    }
                },
                getMyOrganization() {
                    let that = this,
                        arr = [];
                    orgApi.getMyOrganization(RongIM.instance.auth.id, {}, function (results) {
                        if (results.count > 0) {
                            that.myOrgList = {};
                            results.data.forEach((element, index) => {
                                that.myOrgList[element.id] = element;
                            })
                        }
                    })
                },
                //获取我的关注,添加到我的关注节点
                getMyFollow1(item, callback) {
                    let tree = $('#fixTree');
                    orgApi.getMyfollow(RongIM.instance.auth.id, {
                        focustate: '0'
                    }, function (result) {
                        if (result.count > 0) {
                            let node = tree.treeview('getNode', $('.BM1101').attr('data-nodeid'));
                            // let node = tree.treeview('getNode', $('.BM1101').attr('data-nodeid'));
                            // let node = tree.treeview('getNode', $('.BM1101').attr('data-nodeid'));
                            // let node = tree.treeview('getNode', $('.BM1101').attr('data-nodeid'));
                            let arr = result.data.map(i => publicTreeView.addItemNodes(i, "myFollow", "left"));
                            if (arr.length == 1) { //初次render()
                                if (!node.nodes && node.root) {
                                    tree.treeview("addNode", [node.nodeId, {
                                        node: arr,
                                        silent: true
                                    }, $('.BM1101'), node, true]);
                                }
                                tree.treeview("buildRemoveNode", [node.nodes, false])
                                tree.treeview("deleteChildrenNode", [node.nodes[0].nodeId, {
                                    node: arr,
                                    silent: true
                                }]);
                                tree.treeview("addNode", [node.nodeId, {
                                    node: arr,
                                    silent: true
                                }, $('.BM1101'), node, true]);
                            } else {
                                tree.treeview("buildRemoveNode", [node.nodes, false])
                                tree.treeview("deleteChildrenNode", [node.nodes[0].nodeId, {
                                    node: arr,
                                    silent: true
                                }]);
                                tree.treeview("addNode", [node.nodeId, {
                                    node: node.nodes,
                                    silent: true
                                }, $('.BM1101'), node]);
                                const zuzhi = []
                                const bumen = []
                                const gongzuozu = []
                                arr.forEach(item=>{
                                    switch(item.vchar_p3){
                                        case '0':
                                            bumen.push(item);
                                            break;
                                        case '1':
                                            gongzuozu.push(item);
                                            break;
                                        default:
                                            zuzhi.push(item);
                                            break;
                                    }
                                })
                                tree.treeview("addNode", [node.nodes[0].nodeId, {
                                    node: zuzhi,
                                    silent: true
                                }, $('.followOrganization'), node.nodes[0]]);
                                tree.treeview("addNode", [node.nodes[1].nodeId, {
                                    node: bumen,
                                    silent: true
                                }, $('.followDept'), node.nodes[1]]);
                                tree.treeview("addNode", [node.nodes[2].nodeId, {
                                    node: gongzuozu,
                                    silent: true
                                }, $('.followWorkingGroup'), node.nodes[2]]);
                            }
                        }
                    })
                },
                // 申请联盟
                applyUnion(item) {
                    orgApi.applyUnion(item.id, (err, res) => {
                        if (err) return;
                        common.messageToast({
                            type: 'success',
                            message: "发送申请成功"
                        });
                    });
                },
                clearSearch: function () {
                    this.isSearch = false;
                    this.keyword = '';
                },
                clear: function () {
                    this.keyword = '';
                    this.itemParams = this.itemdata;
                    initData(this, orgApi)
                    // this.isSearch = false
                    this.isBackSearch = false
                },
                // search: function () {
                //     
                //     search(this)
                // },

                searchOrgMembers: function () {
                    let that = this;
                    let id = that.orgId
                    if (that.isBackSearch) {
                        id = that.orgIdOld;
                    }
                    let params = {
                        size:20,
                        maxId:0,
                        keyword: that.searchText,
                        start: 0,
                        // limit: 15,
                    }

                    that.isShowLoad = true
                    orgApi.searchOrgMembers(id, params).then(res => {
                        if (!this.keyword) return; 
                        that.isSearch = true;
                        that.allMembers = []
                        that.allDepts = []
                        that.allMemberCount = 0
                        that.allDeptsCount = 0
                        that.isShowLoad = false;
                        that.showBack = false;
                        if (!that.isSearch) {
                            return;
                        }
                        if (that.isSearch && !that.isBackSearch) {
                            that.orgIdOld = that.orgId
                        }
                        // that.isBackSearch = true
                        that.allMembers = unique(that.allMembers.concat(res.userResult.data));
                        console.log(res);
                        // 按照首字母排序
                        that.allMembers = that.allMembers.sort(
                            function compareFunction(param1, param2) {
                                return param1.name.localeCompare(param2.name, "zh");
                            }
                        )
                        that.maxIdStaff = res.userResult.maxId
                        that.allMemberCount = res.userResult.total_count
                        that.allDepts = unique(that.allDepts.concat(res.orgResult.data));
                        that.allDepts = that.allDepts.sort(
                            function compareFunction(param1, param2) {
                                return param1.name.localeCompare(param2.name, "zh");
                            }
                        )
                        that.maxIdOrg = res.orgResult.maxId
                        that.allDeptsCount = res.orgResult.total_count
                        if (that.allMemberCount == 0 && that.allDeptsCount == 0) {
                            that.isSearchEmpty = true
                        } else {
                            that.isSearchEmpty = false
                        }
                        // 存储搜索是面包屑
                        that.breadcrumbOld = that.breadcrumb;
                    })
                },
                gotoTab: function (id) {
                    this.tabActive = id;
                    if (id == 1) {
                        this.goAll()

                    } else if (id == 2) {
                        this.gotoUsers()
                    } else {
                        this.gotoOrgs()
                    }
                },
                goAll: function () {
                    this.showAll = true;
                    this.showUsers = false;
                    this.showOrgs = false
                },
                gotoUsers: function () {
                    this.showAll = false;
                    this.showUsers = true;
                    this.showOrgs = false;
                    if(this.members.length == 0){
                        this.isSearchEmpty = true
                    }else{
                        this.isSearchEmpty = false
                    }

                },
                gotoOrgs: function () {
                    this.showAll = false;
                    this.showOrgs = true;
                    this.showUsers = false;
                    if(this.allDepts.length == 0){
                        this.isSearchEmpty = true
                    }else{
                        this.isSearchEmpty = false
                    }
                },
                getName: function (name) {
                    var title = common.textMessageFormat(name);
                    return common.highlight(title, this.keyword);
                },
                getMobile: function (mobile) {
                    if (mobile != this.keyword) {
                        return;
                    }
                    var title = common.textMessageFormat(mobile);
                    return this.locale.user.mobile + ":" + common.highlight(title, this.keyword);
                },
                setRecord: function () {
                    setRecord(this);
                },
                searchRecord: function (record) {
                    this.keyword = record;
                    this.showSearchRecord = false;
                },
                inputFocus: function () {

                    getRecord(this);
                    this.showSearchRecord = true;
                    this.inputIsFocus = true;
                    var context = this;
                    var hide = function ($event) {
                        if ($($event.target).is('.rong-search-item') || $($event.target).is('.rong-field-search') || $($event.target).is('.rong-record-icon') || $($event.target).is('.rong-record-name')) {
                            return;
                        }
                        // context.showSearchRecord = false;
                        $(document).off('mousedown', hide);
                    };
                    $('body').on('mousedown', hide);
                },
                inputBlur: function () {
                    this.inputIsFocus = false;
                    this.showSearchRecord = false;
                    this.setRecord();
                },
                inputDel: function () {
                    if (this.keyword != '') {
                        return;
                    } else {
                        this.isSearch = false;
                    }
                },
                // 返回搜索结果
                backToSearch: function () {
                    this.keyword = this.searchText;
                    this.showBack = false
                    this.isBackSearch = true
                    this.breadcrumb = this.breadcrumbOld
                    debounceSearch(this)

                },

            },
            components: {
                avatar: components.getAvatar,
                // reason: components.followReason
            },
            destroy: function () {
                this.isSearch = false
                orgApi.unwatch(this.deptWatch);
            }
        };
        utils.asyncComponent(options, resolve, reject);
    }

    function search(context) {
        // context.allMembers = []
        // context.allDepts = []
        // context.allMemberCount = 0
        // context.allDeptsCount = 0
        context.showSearchRecord = false
        context.searchOrgMembers(context)

    }
    // 数组去重
    function unique(arr) {
        const res = new Map();
        return arr.filter((arr) => !res.has(arr.id) && res.set(arr.id, 1));
    }
    // 获取搜索历史
    function getRecord(context) {
        var recordList = cache.get('record-zzy') ? (cache.get('record-zzy')[context.auth.id] || []) : [];
        context.recordList = recordList;
    }

    // 设置搜索历史
    function setRecord(context) {

        var keyword = context.keyword.replace(/\s+/g, '');
        if (!keyword) {
            return;
        }
        var recordList = context.recordList;
        recordList = recordList.filter(function (item) {
            return item !== keyword;
        });
        recordList.unshift(keyword);
        recordList = recordList.slice(0, 5);
        context.recordList = recordList;

        var recordObject = cache.get('record-zzy') || {};
        recordObject[context.auth.id] = recordList;
        cache.set('record-zzy', recordObject);
    }

    function getOrgBranch(uid, params, orgApi, callback, context) {
        orgApi.getBranch(uid, {
            state: 0,
            ...params
        }, function (errorCode, result) {
            if (errorCode) {
                common.toastError(errorCode);
                return;
            }
            callback(result);
        });
    }
    /*
    说明：路由改变时，组件加载时，根据路由参数，组织机构 id 和类型 (orgId, type) 初始化页面数据
        context.members = [];       成员列表
        context.depts = [];         部门列表
        context.companies = [];     公司列表
        context.breadcrumb = [];    面包屑导航
        context.company = {};       当前公司，如果在独立子公司下则显示独立子公司
        context.deptName = '';      当前部门名称
    */
    function initData(context, orgApi) {

        var orgId = context.orgId;
        context.allMembers = [];
        context.allMemberCount = 0
        context.allDeptsCount = 0
        context.allDepts = [];
        context.allCompanies = [];
        context.breadcrumb = [];
        context.readcrumbOld = []
        context.company = {};
        context.deptName = '';
        context.showDepts = false;
        context.getApplyList();
        context.page = 1;
        context.size = pageNum;
        context.hasMore = true;
        context.maxId = 0;
        context.useNewDeptTemp = false;
        getOrgData(context, orgId, orgApi);
    }

    function getOrgData(context, orgId, orgApi, cb, loadMore) {
        let params = {
            page: context.page,
            // size: context.size,
            size: 100, //临时解决oa排序异常问题
            maxId: context.maxId
        };
        console.log("111",params.size);
        // 获取当前组织机构的直属子节点
        getOrgBranch(orgId, params, orgApi, function (data) {
            console.log("data==>", data);
            if (!context.useNewDeptTemp) {
                if (data.depts.length) {
                    context.useNewDeptTemp = data.depts.some(item => item.depart_cascade === 1);
                }
            }
            if (context.useNewDeptTemp) {
                data.depts.forEach(dept => {
                    context.inspectIsFollow(dept.cascaData);
                });
            }
            context.maxId = data.maxId;
            context.allMembers = context.allMembers.concat(data.staffs);
            context.allDepts = context.allDepts.concat(data.depts);
            context.showDepts = true;
            let companiesArr = data.companies.filter(function (co) {
                return !orgApi.isAutonomyCompany(co.id);
            });
            context.allCompanies = context.allCompanies.concat(companiesArr);
            var _callback = function () {
                // 获取所有list的总和
                context.allList = context.allMembers.concat(context.allDepts).concat(context.allCompanies);
                if (!loadMore) { 
                    context.lastIndex = context.allList.length > pageNum ? pageNum : context.allList.length;
                }
                context.hasMore = context.allList.length < data.total_count;
                cb && cb();
            };
            /*
            获取部门 path 和公司信息 如果有 独立子部门直接显示独立子部门
            */
            var orgTree = orgApi.getLocalDept(orgId);
            if (orgTree.org) {
                orgTree.pathList.push({
                    id: orgTree.org.id,
                    name: orgTree.org.name,
                    type: orgTree.org.type
                })
            }
            var pathList = orgTree.pathList || [];
            var autonomy = pathList[1];
            if (autonomy && orgApi.isAutonomyCompany(autonomy.id)) {
                pathList.shift();
            }
            // 根据类型 type 获取公司或部门信息
            if (context.type === common.OrgType.COMPANY) {
                orgApi.getCompanyById(orgId, function (err, company) {
                    if (orgApi.isAutonomyCompany(orgId)) {
                        pathList = [];
                        context.company = company;
                    } else {
                        context.company = pathList[0] || company;
                    }
                    context.deptName = company.name;
                    _callback();
                });
            } else if (context.type === common.OrgType.DEPT) {
                context.company = pathList[0] || {
                    name: ''
                };
                orgApi.getDept(orgId, function (errorCode, dept) {
                    context.deptName = dept.deptName;
                    _callback();
                }, true);
            }
            context.breadcrumb = unique(pathList);
            if (context.showBack) {
                context.breadcrumb.push(context.itemParams)
            }

            if (context.depts.length == 0 && context.members.length == 0 && context.allDepts.length == 0) {
                context.isShowLoad = true
            } else {
                context.isShowLoad = false
            }
            // context.keyword = ''
            // if (context.depts.length > 0 || context.members.length > 0) {
            //     context.isShowLoad = false
            // }
            if (data.hideUserCount > 0) {
                common.messageToast({
                    type: 'success',
                    message: "当前机构下有用户设置为未公开",
                    position:'bottom'
                });
            }
        }, context);
    }

    function unique(arr1) {
        const res = new Map();
        return arr1.filter((a) => !res.has(a.id) && res.set(a.id, 1))
    }

    function getRoute(item) {
        var coId = this.coId;
        return {
            name: 'organization',
            params: {
                coId: coId,
                orgId: item.id,
                type: item.type
            }
        };
    }

    function isScrollToBottom() {
        var $el = $('.rong-contact-content');
        if (!$el) return false;
        var bottom = $el.css('padding-bottom');
        if (!bottom) return false;
        bottom = parseFloat(bottom.split('px')[0]);
        //滚动高度
        var scrollTop = $el[0].scrollTop;
        //div高度
        var height = $el.height();
        //内容
        var scrollHeight = $el[0].scrollHeight;
        console.log(scrollTop)
        console.log(height)
        console.log(scrollHeight)
        console.log(bottom)
        console.log("***********************************")
        return scrollTop + height >= scrollHeight - bottom - 100;
    }

    function searchStaffMembers(context, orgApi, callback) {
        if (!context.hasMore_user) {
            return;
        }
        let params = {
            size:20,
            maxId:context.maxIdStaff,
            keyword: context.searchText,
            start: context.minTimestamp_user,
            limit: 15,
        }
        orgApi.searchStaffMembers(context.orgId, params, (errorCode, res) => {
            if (errorCode) {
                return;
            }
            context.loadingNextPage = false;
            context.$nextTick(() => {
                context.allMembers = context.allMembers.concat(res.data);
                // console.log(context.allMembers)
                context.maxIdStaff =res.maxId
                // context.allMemberCount = res.total_count
                context.hasMore_user = res.total_count > 0
                context.minTimestamp_user = context.allMembers.slice(-1)[0].create_dt;

            })
        })
    }
    function searchOrgs(context, orgApi, callback) {
        if (!context.hasMore_org) {
            return;
        }
        let params = {
            size:20,
            maxId:context.maxIdOrg,
            keyword: context.searchText,
            limit: 15,
        }
        context.loadingNextPage = false;
        orgApi.searchOrgs(context.orgId, params, (errorCode, res) => {
            if (errorCode) {
                return;
            }
            
            context.$nextTick(() => {
                context.allDepts = context.allDepts.concat(res.data);
                context.maxIdOrg= res.maxId;
                context.hasMore_org = res.total_count > 0

            })
        })
    }
    function loadMore(context, orgApi) {
        if (context.isSearch) {
            // 全部页面
            if (context.tabActive == 1) {
                return;
            }
            context.loadingNextPage = true;
            //联系人tab页面
            if (context.tabActive == 2) {
                var loadMore = function () {
                    context.$nextTick(function () {
                        if (isScrollToBottom()) searchStaffMembers(context, orgApi, loadMore);
                    });
                };
                searchStaffMembers(context, orgApi, loadMore);
            }
              //组织tab页面
            if (context.tabActive == 3) {
                var loadMore = function () {
                    context.$nextTick(function () {
                        if (isScrollToBottom()) searchOrgs(context, orgApi, loadMore);
                    });
                };
                searchOrgs(context, orgApi, loadMore);
            }
        } else {
            let {hasMore, loadingNextPage, orgId, page} = context;
            if (hasMore && !loadingNextPage) {
                page += 1;
                context.page = page;
                context.loadingNextPage = true;
                getOrgData(context, orgId, orgApi, function() {
                    var totalNum = context.allList.length;
                    var end = context.lastIndex + pageNum;
                    var adjust = function (index) {
                        return index > totalNum ? totalNum : index;
                    };
                    end = adjust(end);
                    context.lastIndex = end;
                    context.loadingNextPage = false;
                }, true)
            }
            
        }


    }
}(RongIM, {
    jQuery: jQuery
}, RongIM.components));