(function(RongIM, dependencies, components) {
    'use strict';
    console.log('left-list');
    var common = RongIM.common;
    var utils = RongIM.utils;
    var $ = dependencies.jQuery;
    var $tree = $('div#menuTree');
    // var orgExpand = false;
    // 缓存根节点信息切换时不重新获取
    var cacheRootList = null;
    /** 
     * 说明: 左侧树形列表组件
     */
    components.leftList = function(resolve, reject) {
        var im = RongIM.instance;
        var dataModel = im.dataModel;
        var groupApi = dataModel.Group;
        var pinApi = dataModel.Pin;
        var userApi = dataModel.User;
        var dialog = RongIM.dialog;
        var publicTreeView = RongIM.treeView;
        console.log("publicTreeView",RongIM);
        window.showAddFriendDialog = function() {
            dialog.addFriend();
        }

        // 模块化屏蔽入口
        // 好友
        var modules = im.config.modules;
        var orgApi = dataModel.Organization;
        var options = {
            name: 'left-list',
            template: '#left-list',
            data: function() {
                return {
                    bound: {
                        width: {
                            min: 0,
                            max: 0
                        }
                    },
                    //初始化treeView树
                    initDataList: [],
                    //存储根节点类型:myOrganization我的组织 KXY科协云组织 myFollow我的关注
                    rootType: '',
                    //树形列表当前点击的item
                    itemParentNodes: null,
                    //通知treeView数据组合完成
                    showNodeType: false,
                    eventTarget: null,
                    indexArr: [],
                    count: 0,
                    chatGroupList: [],
                    newGroup: false, //是否有新的通讯组
                    xhManager: false // 是否学会管理员
                };
            },
            props: {
                cancelfollowitemdata: {
                    type: Object,
                    default: () => {}
                },
                //删除通讯组数据
                deletepingroupitem: {
                    type: Object,
                    default: () => {}
                },
            },
            watch: {
                cancelfollowitemdata: function(newVal) {
                    this.getMyFollowChange(newVal)
                },

                deletepingroupitem: {
                    handler(newVal, oldVal) {
                        if (newVal) {
                            this.getPinGroupChange(newVal)
                        }

                    },
                    immediate: true,
                    deep: true
                }
            },
            computed: {
                width: function() {
                    var node = im.resizeNode.rongList;
                    return node.width;
                },
            },
            components: {
                imageLoader: components.getImageLoader,
                search: components.getSearch,
                treeForm: components.treeForm
            },
            created: function() {
                this.getKXAllMembers()
            },
            mounted: function() {
                // if(this.$route.params && this.$route.params.source == 'search'){
                //     let n = 'pinGroup'
                //     var node = $('#fixTree').treeview('findNodes', ['^' + n + '$', 'g', 'id']);
                // }

                common.resizeNavNode(this, im);
            },
            methods: {
                // 获取当前登录人是否学会管理员
                getXhManager(cb) {
                    userApi.getXhManager((err, res) => {
                        if (err) return;
                        this.xhManager = Boolean(res.xhManager);
                        cb && cb();
                    });
                },

                /**初始化treeView数据 */
                initTreeData() {
                    // debugger
                    let myMailListTree = {},
                        myKxyTree = {},
                        myAllyTree = {},
                        treeViewData = publicTreeView.treeViewData;
                        
                        let myFollowTree = {}
                    Object.assign(myMailListTree, treeViewData.myMailListTree);
                    Object.assign(myKxyTree, treeViewData.myKxyTree);
                    Object.assign(myAllyTree, treeViewData.myAllyTree);
                    Object.assign(myFollowTree, treeViewData.myFollowTree);
                    myKxyTree.id = RongIM.instance.auth.companyId;
                    myKxyTree.text = myKxyTree.text + "(" + this.count + "人)";
                    myMailListTree.nodes = [
                        treeViewData.distributionGroupTree,
                        treeViewData.datSayGroupTree,
                        treeViewData.specialContactTree,
                        treeViewData.dayContactTree,
                        treeViewData.FileAssistantTree,
                        treeViewData.groupApplyTree,
                        treeViewData.newFriendApplyTree
                    ];
                    myFollowTree.nodes = [
                        treeViewData.followOrganization,
                        treeViewData.followDept,
                        treeViewData.followWorkingGroup
                    ]
                    myAllyTree.nodes = [treeViewData.allyListTree];
                    if (this.xhManager) {
                        myAllyTree.nodes.push(treeViewData.allyApplyTree);
                    }
                    let initTreeList = [
                        treeViewData.myOrgTree,
                        myFollowTree,
                        myMailListTree,
                        myKxyTree,
                    ];
                    this.initDataList = publicTreeView.setTreeViewJson(initTreeList);
                    this.$set(this.initDataList[1].nodes[0], 'nodes', []);
                    this.$set(this.initDataList[1].nodes[1], 'nodes', []);
                    this.$set(this.initDataList[1].nodes[2], 'nodes', []);
                    this.getMyOrganization(this.initDataList[0], 'myOrganization');
                    this.getMyFollow(this.initDataList[1], 'myFollow');
                    this.$set(this.initDataList[2].nodes[0], 'nodes', []);
                    this.$set(this.initDataList[3].nodes[0], 'nodes', []);

                },
                /**中科协总人数 */
                getKXAllMembers() {
                    let that = this;
                    orgApi.getBranch(RongIM.instance.auth.companyId, {
                        state: 0
                    }, function(errorCode, result) {
                        if (errorCode) {
                            common.toastError(errorCode);
                            return errorCode;
                        }
                        if (result.depts.length > 0) {
                            that.count = result.depts.reduce((total, currentValue, currentIndex, arr) => {
                                return total + Number(currentValue.member_count);
                            }, 0);
                        }

                        that.getXhManager(() => {
                            that.initTreeData()
                        });
                    })
                },
                /**
                 * 子组件通知当前点击的每一项
                 * @param {Object} item 当前点击项
                 * @param {Function} callback 回调函数
                 */
                itemActive(item, target, callback) {
                    let that = this;
                    that.indexArr = [];
                    that.eventTarget = target;
                    that.$emit('item-nodes-active', item, target);
                    switch (item.rootType) {
                        case ('myOrganization'):
                            if (item.nodes && item.nodes.length == 0) {
                                that.getMyOrganizationMembers(item, callback);
                            } else {
                                callback(item.nodes)
                            }
                            break;
                        case 'myFollow':
                            if (item.nodes && item.nodes.length == 0) {
                                if ('followWorkingGroup,followDept,followOrganization'.indexOf(item.id) !== -1) {
                                    callback(item.nodes)
                                } else {
                                    that.getMyFollowChild(item, callback);
                                }
                            } else {
                                callback(item.nodes)
                            }
                            break;
                        case 'myMailList':
                            callback(item.nodes)
                            break;
                        case 'distributionGroup':
                            if ((item.nodes && item.nodes.length == 0) || that.newGroup) {
                                that.getMyMailList(item, callback)
                            } else {
                                callback(item.nodes)
                            }
                            break;
                        case 'myAlly':
                            if (item.state.expanded) {
                                that.getXhManager(() => {
                                    let treeViewData = publicTreeView.treeViewData;
                                    let arr = [treeViewData.allyListTree];
                                    arr[0].nodes = [];
                                    if (this.xhManager) arr.push(treeViewData.allyApplyTree);
                                    callback(arr);
                                });
                            } else {
                                callback(item.nodes);
                            }
                            break;
                        case 'allyList':
                            if (item.nodes && item.nodes.length == 0) {
                                that.getAllyList(item, callback)
                            } else {
                                callback(item.nodes)
                            }
                            break;
                    }
                },
                // 获取联盟单位列表
                getAllyList(i, callback) {
                    orgApi.getUserUnionDepart((err, res) => {
                        if (err) {
                            callback();
                            return;
                        }
                        let data = res.data.map(item => {
                            return {
                                ...item,
                                id: item.depart_uid,
                                name: item.depart_name,
                            };
                        });
                        let arr = data.map(item => publicTreeView.addItemNodes(item, i.rootType, "left"));
                        if (callback) callback(arr);
                    });

                },
                /**获取我的通讯录-----通讯录列表*/
                getMyMailList(i, callback) {
                    let that = this;
                    return orgApi.getPinGroups('', res => {
                        if (!res.total_count) return;
                        that.chatGroupList = res.data.map(obj => {
                            return {
                                ...obj,
                                name: obj.name + '(' + obj.count + '人)',
                                root: false
                            }
                        });
                        if (that.chatGroupList.length > 0) {
                            let arr = that.chatGroupList.map(item => publicTreeView.addItemNodes(item, i.rootType, "left"));
                            // if (arr.length) this.$set(this.initDataList[2].nodes[0], 'nodes', []);
                            that.newGroup = false
                            if (callback) callback(arr);
                        }

                    })
                },
                /**获取我的组织第一层列表*/
                getMyOrganization() {
                    orgApi.getMyOrganization(RongIM.instance.auth.id, {}, res => {
                        if (!res.count) return;
                        let arr = res.data.map(item => publicTreeView.addItemNodes(item, "myOrganization", "left"));

                        this.$set(this.initDataList[0], 'nodes', arr);
                        // $('#fixTree').treeview('checkNode', [ 1, { silent: true } ]);
                    })
                },

                //获取我的关注
                getMyFollow() {
                    orgApi.getMyfollow(RongIM.instance.auth.id, {
                        focustate: '0'
                    }, result => {
                        if (!result.count) return;
                        let arr = result.data.map(item => publicTreeView.addItemNodes(item, "myFollow", "left"));
                        console.log(this.initDataList[1],'this.initDataList[1]')
                        arr.forEach(item=>{
                            switch(item.vchar_p3){
                                case '0':
                                    this.initDataList[1].nodes[1].nodes.push(item);
                                    break;
                                case '1':
                                    this.initDataList[1].nodes[2].nodes.push(item);
                                    break;
                                default:
                                    this.initDataList[1].nodes[0].nodes.push(item);
                                    break;
                            }
                        })
                        // if (arr.length) this.$set(this.initDataList[1].nodes[0], 'nodes', arr)
                        // if (arr.length) this.$set(this.initDataList[1], 'nodes', arr)
                    })
                },

                //获取我的关注
                getMyFollowChange(item) {
                    // 没渲染 刷新我的关注数据
                    if (!item.nodeId || !item.parentId) {
                        this.getMyFollow(this.initDataList[1], 'myFollow');
                        return;
                    }

                    let tree = $('#fixTree');
                    let itemNodeParent = tree.treeview('getParent', item.nodeId);

                    orgApi.getMyfollow(RongIM.instance.auth.id, {
                        focustate: '0'
                    }, result => {

                        if (!result.count) {
                            tree.treeview("buildRemoveNode", [itemNodeParent.nodes, false])
                            tree.treeview("deleteChildrenNode", [itemNodeParent.nodes[0].nodeId, {
                                node: [],
                                silent: true
                            }, true]);
                            return;
                        }

                        let arr = result.data.map(i => publicTreeView.addItemNodes(i, "myFollow", "left"));
                        tree.treeview("buildRemoveNode", [itemNodeParent.nodes, false]);
                        tree.treeview("deleteChildrenNode", [itemNodeParent.nodes[0].nodeId, {
                            node: arr,
                            silent: true
                        }, false]);
                        tree.treeview("addNode", [itemNodeParent.nodeId, {
                            node: arr,
                            silent: true
                        }, $('.BM1101'), itemNodeParent]);
                    })
                },
                //通讯组变化回调函数
                getPinGroupChange(item) {
                    let that = this
                    let tree = $('#fixTree');
                    let itemNodeParent = tree.treeview('getParent', item.nodeId);
                    // 没渲染 刷新我的关注数据
                    orgApi.getPinGroups('', result => {
                        if (!result.count) {
                            tree.treeview("buildRemoveNode", [itemNodeParent.nodes, false])
                            tree.treeview("deleteChildrenNode", [itemNodeParent.nodes[0].nodeId, {
                                node: [],
                                silent: true
                            }, true]);
                            return;
                        }
                        that.chatGroupList = result.data.map(obj => {
                            return {
                                ...obj,
                                name: obj.name + '(' + obj.count + '人)',
                                root: false
                            }
                        });

                        let arr = that.chatGroupList.map(i => publicTreeView.addItemNodes(i, "distributionGroup", "left"));
                        tree.treeview("buildRemoveNode", [itemNodeParent.nodes, false]);
                        tree.treeview("deleteChildrenNode", [itemNodeParent.nodes[0].nodeId, {
                            node: arr,
                            silent: true
                        }, false]);
                        tree.treeview("addNode", [itemNodeParent.nodeId, {
                            node: arr,
                            silent: true
                        }, $('.pinGroup'), itemNodeParent]);
                        if (item.rootType == 'distributionGroup') {
                            result.data.forEach(obj => {
                                let flag = $("li[class*='" + obj.id + "']")
                                    // 置顶
                                if (obj.mainly && flag) {
                                    flag[0].style.background = '#F4F3F3'
                                    var child = document.createElement('div');
                                    child.className = 'mainly-dot'
                                    console.log(flag[0])
                                    flag[0].appendChild(child);
                                }
                            })
                        }

                    })
                },

                //获取我的关注子级
                getMyFollowChild(item, callback) {
                    let params = {
                        type: 'depart',
                        state: 0
                    };
                    // if (item && item.vchar_p3) {
                    //     params.orgtype = item.vchar_p3 == 1 ? '1' : '0,1,3';
                    // };

                    orgApi.getMembers(item.id, params, result => {
                        // if (!result.count) return;
                        let company = result.data.map(i => publicTreeView.addItemNodes(i, item.rootType, "left"));
                        if (callback) callback(company);
                    })
                },

                /**
                 * 获取组织成员数据
                 * @param {Object} item 当前点击项
                 * @param {Function} callback 回调函数
                 */
                getMyOrganizationMembers(item, callback) {
                    let params = {
                        type: 'depart',
                        state: 0,
                        // orgtype:'0,1,3'
                    };
                    // 因创建不规范，orgtype更改为0 1 3 解决不显示部门的问题
                    // if (item && item.vchar_p3 != null) {
                    //     params.orgtype = item.vchar_p3 == 1 ? '1' : '0,1,3';
                    // }

                    orgApi.getMembers(item.id, params, result => {
                        // if (!result.count) return;

                        let arr = result.data.map(i => publicTreeView.addItemNodes(i, "myOrganization", "left"));
                        item.nodes = arr;
                        if (callback) callback(arr);
                    })
                },

                memberCount: function(item) {
                    var staffCount = item.staff_count || item.member_count;
                    var format = (staffCount == 1) ? this.locale.contact.personSingle : this.locale.contact.person;
                    return this.localeFormat(format, staffCount);
                },

                getResizeDirection: function() {
                    var direction = common.getResizeDirection({
                        range: this.width,
                        bound: this.bound.width,
                        directions: ['left', 'right']
                    });
                    im.resizeDirection.temp = direction;
                    return direction;
                },
                addGroup(result) {
                    let that = this
                    let tree = $('#fixTree');
                    let itemNodeParent = tree.treeview('getNode', $('.pinGroup').attr('data-nodeid'));
                    // 没渲染 刷新我的关注数据
                    orgApi.getPinGroups('', result => {
                        if (!result.count) return;
                        that.chatGroupList = result.data.map(obj => {
                            return {
                                ...obj,
                                name: obj.name + '(' + obj.count + '人)',
                                root: false
                            }
                        });

                        if (!result.count) {
                            tree.treeview("buildRemoveNode", [itemNodeParent.nodes, false])
                            tree.treeview("deleteChildrenNode", [itemNodeParent.nodes[0].nodeId, {
                                node: [],
                                silent: true
                            }, true]);
                            return;
                        }
                        let arr = that.chatGroupList.map(i => publicTreeView.addItemNodes(i, "distributionGroup", "left"));

                        tree.treeview("buildRemoveNode", [itemNodeParent.nodes, false]);
                        if (itemNodeParent.nodes && itemNodeParent.nodes.length > 0) {
                            tree.treeview("deleteChildrenNode", [itemNodeParent.nodes[0].nodeId, {
                                node: arr,
                                silent: true
                            }, false]);
                        }
                        tree.treeview("addNode", [itemNodeParent.nodeId, {
                            node: arr,
                            silent: true
                        }, $('.pinGroup'), itemNodeParent]);
                        that.chatGroupList.forEach(obj => {
                            let flag = $("li[class*='" + obj.id + "']")
                                // 置顶
                            if (obj.mainly && flag) {
                                flag[0].style.background = '#F4F3F3'
                                var child = document.createElement('div');
                                child.className = 'mainly-dot'
                                console.log(flag[0])
                                flag[0].appendChild(child);
                            }
                        })

                    })
                },
                searchPinGroup(item) {
                    this.$refs.child.exampleTreeView(this.initDataList, item)
                },

            },

            destroyed: function() {
                // orgExpand = null;
                cacheRootList = null;
                groupApi.unwatch(this.setApproveUnread);
            }
        };

        utils.asyncComponent(options, resolve, reject);
    }

}(RongIM, {
    jQuery: jQuery
}, RongIM.components));