(function (RongIM, dependencies, components) {
  'use strict';
  
  var common = RongIM.common;
  var utils = RongIM.utils;
  var dialog = RongIM.dialog;
  var $ = dependencies.jQuery;
  
  components.getNewApprove = function(resolve, reject) {
      var im = RongIM.instance;
      var dataModel = im.dataModel;
      var groupApi = dataModel.Group;
      var options = {
          name: 'new-approve',
          template: '#new-approve',
          props: {
            offsetX: Number
          },
          data: function () {
              return {
                  isLoadDone: false,
                  approveList: []
              };
          },
          computed: {
              showEmptyGroup: function () {
                  return this.groups.length === 0;
              },
              hasApprove: function () {
                  return this.approveList.length > 0;
              }
          },
          mixins: [getContextMenu()],
          mounted: function () {
              clearApproveUnread(groupApi, im);
              initApproveList(this, groupApi);
              watchApproveDelete(im, this);
              watchVerifyNotifyMessage(this, im.dataModel.Group);
          },
          destroyed: function () {
              unWatchVerifyNotifyMessage(this, groupApi);
          },
          filters: {
              slice: function (name) {
                  if (!name) {
                      return name;
                  }
                  var isChinese = /^[^\x20-\xff]+$/.test(name);
                  return isChinese ? name.slice(-1) : name[0].toUpperCase();
              }
          },
          methods: {
              getReceiverStyle: function (approveInfo) {
                  var url = 'url(' + approveInfo.receiverPortraitUrl + ')';
                  return {
                      'background-image': url
                  };
              },
              getApproveStatus: function (approveInfo) {
                  var locale = this.locale.components;
                  locale = locale.approve;
                  var statusMapTitle = {
                      0: locale.wait,
                      1: locale.already,
                      2: locale.overdue,
                      3: locale.invalid
                  };
                  var status = approveInfo.receiver_status;
                  return statusMapTitle[status];
              },
              approve: function (data) {
                  var context = this;
                  approve(data, 1, groupApi, function (err) {
                      if (err) {
                          utils.console.log('approve err: ', err);
                          return;
                      }
                      initApproveList(context, groupApi);
                  });
              },
              showClearMenu: function () {
                  var context = this;
                  if (!context.hasApprove) {
                      return;
                  }
                  var locale = context.locale;
                  common.messagebox({
                      type: 'confirm',
                      title: locale.tips.msgboxTitle,
                      message: locale.tips.clearApprove,
                      submitText: locale.tips.msgboxSubmitText,
                      callback: function () {
                          clearApproveList(context, groupApi);
                      }
                  });
              },
              userProfile: dialog.user
          },
          components: {
              avatar: components.getAvatar
          }
      };
      utils.asyncComponent(options, resolve, reject);
  }
  
  function clearApproveList(context, groupApi) {
      groupApi.clearApprove(function () {
          context.approveList = [];
      });
  }
  
  function clearApproveUnread(groupApi, im) {
      var hasUnread = im.approveUnReadCount > 0;
      if (hasUnread) {
          groupApi.clearApproveUnRead(function () {
              im.approveUnReadCount = 0;
          });
      }
  }
  
  function watchApproveDelete(im, context) {
      im.$on('approveDelete', function (data) {
          var index = context.approveList.indexOf(data);
          context.approveList.splice(index, 1);
      });
  }
  
  function initApproveList(context, groupApi) {
      groupApi.getApproveList(function (errorCode, result) {
          context.isLoadDone = true;
          if (errorCode) {
              utils.console.log('get approve list error: ', errorCode);
              return;
          }
          result.forEach(function (approveInfo) {
              if (approveInfo.join_info) {
                  var joinInfo = JSON.parse(approveInfo.join_info);
                  if (joinInfo && +joinInfo.type === 0) {
                      approveInfo.inviter_name = groupApi.getMember(joinInfo.operatorId);
                      return;
                  }
              }
              approveInfo.inviter_name = approveInfo.requester_name;
          });
          context.approveList = result;
      });
  }
  
  function watchVerifyNotifyMessage(context, groupApi) {
      context.watchVerifyNotify = function (message) {
          var messageType = message.messageType;
          var isVerifyNotifyMessage = messageType === 'GroupVerifyNotifyMessage';
          if (isVerifyNotifyMessage) {
              initApproveList(context, groupApi);
          }
      };
      groupApi.watch(context.watchVerifyNotify);
  }
  
  function unWatchVerifyNotifyMessage(context, groupApi) {
      groupApi.unwatch(context.watchVerifyNotify);
  }
  
  function getContextMenu() {
      var im = RongIM.instance;
      var dataModel = im.dataModel;
      var groupApi = dataModel.Group;
      var options = {
          name: 'approve-contextmenu',
          template: 'templates/contact/approve-contextmenu.html',
          methods: {
              deleteApprove: function () {
                  var context = this;
                  var data = context.context.approve;
                  approve(data, 5, groupApi, function (err) {
                      context.$emit('close');
                      if (err) {
                          utils.console.log('delete err: ', err);
                          return;
                      }
                      im.$emit('deleteApprove', data);
                  });
              }
          }
      };
      return components.getContextMenu(options);
  }
  
  function approve(data, status, groupApi, callback) {
      var groupId = data.id;
      var userId = data.receiver_id;
      // 1是通过, 5是删除
      groupApi.approve(groupId, userId, status, function (err) {
          callback(err);
      });
  }
  
  // $.extend(true, components, {
  //     contact: {
  //         getApprove: getApprove
  //     }
  // });
  }(RongIM, {
      jQuery: jQuery
  }, RongIM.components));
  