(function(RongIM, dependencies, components) {
    'use strict';
    console.log(components)
    var utils = RongIM.utils;
    var common = RongIM.common;
    var utils = RongIM.utils;
    var dialog = RongIM.dialog;
    var common = RongIM.common;
    var im = RongIM.instance;
    // var $ = dependencies.jQuery;
    var pageNum = RongIM.config.profile.pageNum;
    console.log('tree-item');
    /**
     * 说明： 右侧item展示
     */

    components.item = function(resolve, reject) {
        var im = RongIM.instance;
        var dataModel = im.dataModel;
        var userApi = dataModel.User;
        var starApi = dataModel.Star;
        var friendApi = dataModel.Friend;
        var groupApi = dataModel.Group;
        var pinApi = dataModel.Pin;
        var orgApi = dataModel.Organization;
        var options = {
            name: 'item',
            template: '#item',
            props: {
                itemdata: {
                    type: Object,
                    default: () => {}
                },
                eventtarger: {
                    type: Object,
                    default: () => {}
                },
                offsetX: Number
            },
            data: function() {
                return {
                    pageConfigPageTotal: {
                        total: 21,
                        pageSize: 8,
                        pageNo: 1,
                        pageTotal: 1
                    },
                    itemList: [],
                    maxId: 0,
                    listPage: 1,
                    listSize: 50,
                    listFinished: false,
                    listLoading: false,
                    paramsData: null,
                    loadingNextPage: false,
                    lastIndex: 0,
                    allList: [],
                    gotMyFocus: false,
                    focused: {},
                    events: null,
                    // 当前展示list的类型：contacts 联系人、group 群组、default 默认
                    itemListType: "default",
                    user: im.dataModel.User,

                    //是否显示标题按钮
                    isShowTitlebtn: false,
                    // 设置头部导航显示隐藏得样式
                    headerClass: false,
                    isTxz: false, //是否为通讯组
                    showInfo: false, //显示详情
                    selectedContact: {}, //当前的通讯组对象
                    isEdit: false, //是否是编辑结束
                    endName: '', //编辑后显示的name
                    hasUser: true,
                    isCreateChat: false,
                };
            },
            computed: {

                isShowLoad() {
                    if (this.itemList && Array.isArray(this.itemList) && this.itemList.length > 0) {
                        return false
                    }
                    return true
                },

                /***标题栏配置 */
                configPageTitle() {
                    if (this.paramsData != null || this.itemList.length > 0) {
                        let item = this.paramsData;
                        let type = item.rootType;
                        let that = this;
                        let tree = $('#fixTree');
                        let itemNodeParent = tree.treeview('getParent', item.nodeId)
                            //标题配置
                        let configTitle = {
                            text: "",
                            btnContent: "",
                            type: "",
                            id: ""
                        };
                        if (type == 'distributionGroup' && item.id == 'pinGroup') {
                            configTitle.text = item.text;
                            configTitle.addReport = that.locale.btns.addReport
                            that.isShowTitlebtn = false;
                            that.isShowBtn = false;
                            that.isTxz = true;
                            return configTitle
                        }

                        if (type == "myOrganization" || (type == "myFollow" && item.root) || (type == "myFollow" && !item.root && that.focused[item.id] == undefined) || (type == "myMailList" && item.nodeType != "communicateGroup")) {
                            configTitle.text = item.text;
                            that.isShowTitlebtn = false;
                        }

                        // else {
                        if (type == "myFollow" && !item.root && that.focused[item.id] != undefined) {
                            configTitle.text = item.text;
                            configTitle.btnContent = that.locale.blish.cancelFollow;
                            configTitle.type = "cancelFollow";
                            configTitle.id = item.id;
                            that.isShowTitlebtn = Boolean(itemNodeParent.root);
                        } else if (type == "myMailList" && item.nodeType == "communicateGroup") {
                            configTitle.text = item.text;
                            configTitle.btnContent = that.locale.blish.createdGroup;
                            configTitle.type = "createdGroup";
                            that.isShowTitlebtn = true;
                        } else if (type == "distributionGroup") {
                            configTitle.text = item.text;
                            configTitle.btnContent = that.locale.blish.editGroup;
                            configTitle.addReport = that.locale.btns.addReport
                            configTitle.type = "editChat";
                            that.isShowTitlebtn = true;
                            that.isTxz = true;
                            if (this.itemList.length == 1) {
                                configTitle.createdChat = that.locale.btns.createChat
                                that.isCreateChat = true
                            } else {
                                configTitle.createdChat = that.locale.blish.createdChat;
                                that.isCreateChat = false
                            }

                            configTitle.createPins = that.locale.blish.createPins
                        }
                        // }
                        if (type == 'myOrganization' || type == "myFollow") {
                            configTitle.text = getFullPath(item);
                        }
                        return configTitle
                    }
                },

            },

            filters: {
                itemType(val) {
                    if (val.type == 0) {
                        return val;
                    }
                }
            },

            watch: {},

            created() {
                this.events = this.eventtarger;
            },

            mounted: function() {
                pinGroupSetWatch(this, pinApi, orgApi);
            },

            components: {
                avatar: components.getAvatar,
                paging: components.paging,
                contactDetail: components.getContactDetail,
                'tree-right-title': components.treeRightTitle
            },

            methods: {

                /** 标题栏点击按钮事件*/
                btnChange(param) {
                    this.headerClass = false;
                    if (param.type == "cancelFollow") {
                        this.cancelFollow(param)
                    } else if (param.type == "createdGroup") {
                        this.createdGroup()
                    } else if (param.type == 'editChat') {
                        this.getDetail(this.selectedContact)

                    }
                },
                createPin: function() {
                    dialog.addPin({
                        memberList: this.itemList.map(res => {
                            return {
                                ...res,
                                receiver_uid: res.id
                            }
                        })
                    }, (res) => {
                        this.$parent.addGroup()
                    });
                },
                //创建沟通群
                createdGroup() {
                    var userId = im.auth.id;
                    dataModel.User.getBatch([userId], function(errorCode, list) {
                        // dialog.blishGroup(null, list,true,'establish',true);
                        dialog.newDialogBox(null, list, "created");
                    });
                },

                //获取重要联系人
                getKeyContactsList(item) {
                    this.itemList = [];
                    starApi.getList((errorCode, list) => {
                        if (list && list.length && item.id == this.paramsData.id) {
                            this.itemListType = "contacts";
                            this.itemList = list;
                        }
                    })
                },

                //获取日常联系人
                getDailyContactList(item) {
                    friendApi.getList((errorCode, list) => {
                        if (list && list.length && item.id == this.paramsData.id) {
                            this.itemListType = "contacts";
                            this.itemList = list;
                        }
                    })
                },

                //获取群聊
                geCommunicateGroupList(item) {
                    groupApi.getList((errorCode, list) => {
                        if (list && list.length && item.id == this.paramsData.id) {
                            this.itemListType = "group";
                            this.itemList = list.filter(data => data.group_status == 0);
                        }
                    })
                },
                //.根据通讯组id获取成员
                getMembersById(item, ifDel) {
                    orgApi.getMembersById(item.id, (errorCode, result) => {
                        // this.itemList = []
                        if (errorCode) {
                            common.toastError(errorCode);
                            return errorCode;
                        }
                        if (result && result.data && item.id == this.paramsData.id) {
                            this.itemListType = "distributionGroup";
                            this.$nextTick(() => {
                                this.itemList = result.data
                                this.selectedContact.members = this.itemList
                                this.selectedContact.member_id_list = this.itemList.map(obj => obj.id)
                                this.selectedContact.member_names = this.itemList.map(obj => obj.name)
                            })

                            if (ifDel) {
                                this.isEdit = true
                                this.endName = this.paramsData.text.split('(')[0] + "(" + this.paramsData.members.length + "人)"
                                this.$emit('delete-pingroup', this.paramsData)
                            }

                        }

                    })

                },
                init(newVal, showType) {
                    this.hasUser = true;
                    this.paramsData = newVal;
                    this.isEdit = false
                    this.resetParams();
                    if (newVal.rootType == 'myFollow') this.headerClass = true;
                    switch (showType) {
                        case "myFollow": //我的关注
                            this.getFollowParams();
                        case "allyList":
                        case "myOrganization": //我的组织
                            if (!newVal.root) {
                                this.getItemList(newVal);
                            }
                            break;
                        case "distributionGroup": //通讯组

                            this.isShowTitlebtn = true;

                            this.selectedContact = newVal
                            if (newVal.id == 'pinGroup' || 'followDept,followOrganization,followWorkingGroup'.indexOf(newVal.id) !== -1 ) {
                                this.isShowTitlebtn = false;
                                return;
                            }
                            this.getMembersById(newVal);
                            break;
                        case "communicateGroup": //群聊
                            this.isShowTitlebtn = true;
                            this.geCommunicateGroupList(newVal);
                            break;
                        case "dailyContact": //日常联系人
                            this.getDailyContactList(newVal);
                            break;
                        case "KeyContacts": //重要联系人
                            this.getKeyContactsList(newVal);
                            break;
                        default:
                    }
                },
                //获取详情
                getDetail: function(item) {
                    groupApi.getPinGroupsDetailByid(item.id, (erroeCode, result) => {
                        if (erroeCode) {
                            return false;
                        }

                        this.selectedContact = utils.deepClone(result.data[0])
                        this.showInfo = true;
                    })
                },
                openConversation: function(item) {
                    var conversationApi = im.dataModel.Conversation;
                    openConversation(this, im.$router, conversationApi, item);
                },
                startConversation: function() {
                    let that = this;
                    var conversationApi = im.dataModel.Conversation;
                    if (that.isCreateChat) {
                        var params = {
                            conversationType: utils.conversationType.PRIVATE,
                            targetId: that.itemList[0].id
                        };
                        im.$router.push({
                            name: 'conversation',
                            params: params
                        });
                        conversationApi.add(params);
                    } else {
                        var userId = im.auth.id;
                        dataModel.User.getBatch([userId], function(errorCode, list) {
                            let users = list.concat(that.itemList)
                            dialog.newDialogBox(null, users, "created");
                        });
                    }


                },

                // 重置
                resetParams() {
                    this.itemList = [];
                    this.itemListType = "default";
                    this.isShowTitlebtn = false;
                    this.maxId = 0;
                    this.listPage = 1;
                    this.listFinished = false;
                },

                //获取我的关注列表
                getFollowParams(callback) {
                    let that = this,
                        params = {
                            focustate: '0'
                        },
                        obj = {};
                    orgApi.getMyfollow(RongIM.instance.auth.id, params, function(result) {
                        if (result && result.data) {
                            result.data.forEach(element => {
                                obj[element.id] = element;
                            });
                            that.focused = Object.assign({}, obj)
                        }
                        if (callback) callback();
                    })
                },

                getGroupType: common.getGroupType,
                getUsername: common.getUsername,
                getRoute: getRoute,
                getTypeName: common.getGroupType,

                userProfile(itemId, tips, visible) {
                    let that = this;
                    dialog.user(itemId, tips, null, null, function(val, id) {
                        if (val && that.itemdata.rootType == 'distributionGroup') {
                            that.itemList = that.itemList.filter(obj => obj.id != id)
                            that.isEdit = true
                            that.endName = that.paramsData.text.split('(')[0] + "(" + that.itemList.length + "人)"
                            that.$emit('delete-pingroup', that.paramsData, {}, 'delUser')
                                // that.getMembersById(that.itemdata,true)
                        }
                        if (that.paramsData.nodeType == "KeyContacts") {
                            that.resetParams();
                            that.getKeyContactsList(that.paramsData);
                        };
                    }, visible)
                },

                departIconClass: function(item) {
                    return (item.vcharp3 == 1 || item.type == 3) ? 'rong-dept-blue-icon' : 'rong-dept-icon';
                },

                getDutyName: function(item) {
                    // console.log(item);
                    let orgId = this.paramsData.id || null;
                    return (item.extDuties && orgId) ? item.extDuties[orgId] : item.dutyName;
                    // return item.dutyName;
                },
                getMainOrg: function(item) {
                    let mainOrg = ''
                    if (item && item.main_org && item.main_org.path && item.main_org.path.length > 0) {
                        item.main_org.path.forEach(obj => {
                            mainOrg += obj.name + '-'
                        })

                    }
                    return mainOrg.substr(0, mainOrg.length - 1)
                },
                memberCount: function(item) {
                    var staffCount = item.staff_count || item.member_count;
                    var format = (staffCount == 1) ? this.locale.contact.personSingle : this.locale.contact.person;
                    return this.localeFormat(format, staffCount);
                },

                loadMore: function() {
                    loadMore(this);
                },
                getExtDuties: function (strVal) {
                    if (strVal) {
                        var duties = {};
                        strVal.split(',').forEach(function(dutyItem) {
                            var dutyPair = dutyItem.trim().split(':');
                            if (dutyPair.length > 1) {
                                duties[dutyPair[0].trim()] = dutyPair[1].trim();
                            }
                        });
                        return duties;
                    }
                    return null;
                },
                getItemList(item) {
                    item = item || this.itemdata;

                    let that = this,
                        params = {
                            type: 'staff',
                            state: 0,
                            maxId: that.maxId,
                            page: that.listPage,
                            // size: that.listSize,
                            size:100,//临时解决oa排序问题
                            limit: that.pageConfigPageTotal.pageSize,
                            offset: that.pageConfigPageTotal.pageNo,
                            // orgtype:'0,1,3'
                        };

                    // if (item && item.vchar_p3 != null) {
                    //     params.orgtype = item.vchar_p3 == 1 ? '1' : '0,1,3';
                    // }
                    that.listLoading = true;
                    // orgApi.getAllMembers(item.id,params,function(result){
                    orgApi.getMembers(item.id, params, function(result) {
                        if (result.hideUserCount > 0) {
                            common.messageToast({
                                type: 'success',
                                message: "当前机构下有用户设置为未公开",
                                position:'bottom'
                            });
                        }
                        // if(result.data && result.data.length > 0){
                        //   that.pageConfigPageTotal.pageTotal = Math.ceil(result.total_count / that.pageConfigPageTotal.pageSize);
                        //   if(item.id == that.paramsData.id){
                        //     that.itemList = result.data;
                        //   }
                        // }
                        let idList = result.data.map(i => i.id);
                        userApi.getBatch(idList,  function (error,  userList)  {
                            if (item.id  ==  that.paramsData.id) {
                                that.pageConfigPageTotal.pageTotal  =  Math.ceil(result.total_count  /  that.pageConfigPageTotal.pageSize);
                                if  ( !userList )  { 
                                    that.itemList  =  result.data 
                                    return;
                                }
                                // that.itemList  =  userList; 
                                let arr = userList.map(item => {
                                  let staff = result.data.find(o => o.id === item.id);
                                  if (staff) {
                                    item.visible = staff.visible;
                                  }
                                  return item;
                                });
                                that.itemList = that.itemList.concat(arr);
                                result.data.forEach(e => {
                                    e["extDuties"]= that.getExtDuties(e.vchar_p3)
                                    that.itemList.forEach(element => {
                                        if (e.id == element.id ) {
                                            element.duty_name =e.duty_name
                                            element.extDuties =e.extDuties
                                            element.name =e.name
                                        }
                                    });
                                });
                                console.log(that.itemList);
                                that.maxId = result.maxId;
                                that.listFinished = that.itemList.length === result.total_count;
                                that.listLoading = false;
                            }
                        })
                    })
                },

                loadMoreList() {
                  if (this.listLoading || this.listFinished) return false;
                  this.listPage += 1;
                  this.getItemList();
                },

                onListScroll: (() => {
                  let last = 0;
                  return function (e) {
                    if (Date.now() - last < 100) return false;
                    last = Date.now();

                    let elem = e.target,
                      offsetHeight = elem.offsetHeight,
                      scrollTop = elem.scrollTop,
                      scrollHeight = elem.scrollHeight;

                    if (scrollHeight - (offsetHeight + scrollTop) < 100) {
                      this.loadMoreList();
                    }
                  };
                })(),

                //取消关注
                cancelFollow(param) {

                    let that = this,
                        params = {
                            uid: RongIM.instance.auth.id,
                            alias: this.itemdata.text
                        };

                    orgApi.cancelFollow(that.itemdata.id, params, function(err) {
                        if (!err) {
                            that.resetParams();
                            that.getFollowParams();
                            $("." + param.id).remove();
                            // that.$emit("refreshfollow",true);
                            that.$emit('cancelfollowitem', that.itemdata);

                            common.messageToast({
                                type: 'success',
                                message: "取消关注成功！"
                            });
                        }
                    })
                },
                //删除通讯组
                deletePinGroup() {
                    this.showInfo = false
                    this.hasUser = false
                    this.$emit('delete-pingroup', this.itemdata)

                },
                afterEnter: function() {
                    this.isClicking = false;
                    im.$emit('pinDetailLoadDone');
                },
                enterCancelled: function() {
                    this.isClicking = false;
                },
                closeDetail: function() {
                    this.showInfo = false;
                },
                //编辑后刷新页面
                changeGroup: function(val) {

                    this.isEdit = true;
                    this.endName = val;
                    this.getMembersById(this.paramsData)
                    this.itemdata.text = val
                    this.$emit('delete-pingroup', this.itemdata)
                },
                getGroupName() {
                    return getGroupName(this);
                },
                createReport() {
                    let that = this;
                    dialog.addContact({}, function(result) {
                        that.$emit('add-group', that.itemdata)
                    });
                }

            },
            destroyed: function(name) {
                orgApi.unwatch(this.deptWatch);
                pinApi.unwatch(this.pinGroupSetWatch);
            }
        };

        utils.asyncComponent(options, resolve, reject);

    };
    /*
  说明：获取群组名称
  参数：
    @param {object}           context       群组信息
  */
    function getGroupName(context) {
        var groupName;
        if (context.groupName) {
            groupName = context.paramsData.text;
        } else {
            var MAX_LENGTH = 16;
            var memberNames = context.itemList;
            memberNames = memberNames.slice(0, MAX_LENGTH).map(function(item) {
                return item.name;
            });
            var group = {
                member_names: memberNames
            };
            groupName = common.getGroupName(group);
        }
        return groupName;
    }
    /*
  说明：创建群组
  参数：
      @param {object}           context
      @param {object}           api       ·
  */
    function createGroup(context, api, im) {
        var groupApi = api.group;
        var conversationApi = api.conversation;
        if (context.busy) {
            return;
        }
        var memberIdList = context.itemList.map(function(item) {
            return item.id;
        });
        console.log(memberIdList)
        if (memberIdList.length === 2) {
            var targetId = memberIdList[1];
            var conversationType = utils.conversationType.PRIVATE;
            var params = {
                targetId: targetId,
                conversationType: conversationType
            };
            im.$router.push({
                name: 'conversation',
                params: params
            });
            conversationApi.add(params);
            return;
        }
        var groupNameLength = context.itemList.map(function(item) {
            return item.text;
        }).length;
        if (groupNameLength > 0 && groupNameLength < 2) {
            common.messageToast({
                type: 'error',
                // message: context.locale.groupNameErr
                message: "群名称不得少于两个字"
            });
            return;
        }

        var group = {
            // 0: 自建群, 1: 官方群
            type: 0,
            name: context.getGroupName(),
            member_ids: memberIdList
        };

        checkMemberLength(context, memberIdList, function() {
            context.busy = true;
            groupApi.create(group, function(errorCode, result) {
                context.busy = false;
                if (errorCode) {
                    RongIM.system.appLogger('error', '创建群组失败 ' + JSON.stringify(errorCode));
                    context.toastError(errorCode);
                    return;
                }
                context.show = false;
                var path = {
                    name: 'conversation',
                    params: {
                        targetId: result.id,
                        conversationType: utils.conversationType.GROUP
                    }
                };
                RongIM.system.appLogger('info', '创建群组成功 ' + result.id);
                context.hackReset = false;
                context.$nextTick(() => {
                    context.hackReset = true
                })
                if (context.isStorge) {
                    context.addDayGroup(result.id, groupApi)
                }
                im.$router.push(path);
                common.messageToast({
                    message: "创建群成功",
                    type: 'success'
                });
            });
        })
    }

    function checkMemberLength(context, memberIdList, cb) {
        if (memberIdList.length > 99) {
            common.messagebox({
                type: 'confirm',
                message: context.locale.message.confirmLargeGroup,
                callback: cb,
                hashchangeClose: false
            });
        } else {
            cb();
        }
    }

    function pinGroupSetWatch(context, pinApi, orgApi) {
        context.pinGroupSetWatch = function(message) {
            var isSetMessage = message.objectName === pinApi.MessageType.StaffPinGroupSet;

        };
        pinApi.watch(context.pinGroupSetWatch);
    }

    function getOrgBranch(uid, orgApi, callback) {
        orgApi.getBranch(uid, function(errorCode, result) {
            if (errorCode) {
                common.toastError(errorCode);
                return;
            }
            callback(result);
        });
    }

    /*
    说明：路由改变时，组件加载时，根据路由参数，组织机构 id 和类型 (orgId, type) 初始化页面数据
        context.members = [];       成员列表
        context.depts = [];         部门列表
        context.companies = [];     公司列表
        context.breadcrumb = [];    面包屑导航
        context.company = {};       当前公司，如果在独立子公司下则显示独立子公司
        context.deptName = '';      当前部门名称
    */

    function getRoute(item) {
        var coId = this.coId;
        return {
            name: 'organization',
            params: {
                coId: coId,
                orgId: item.id,
                type: item.type
            }
        };
    }

    function loadMore(context) {
        context.loadingNextPage = true;
        var totalNum = context.allList.length;
        var end = context.lastIndex + pageNum;
        var adjust = function(index) {
            return index > totalNum ? totalNum : index;
        };
        end = adjust(end);
        if (end === context.lastIndex) {
            context.loadingNextPage = false;
            return;
        }
        setTimeout(function() {
            context.lastIndex = end;
            context.loadingNextPage = false;
        }, 500);
    }

    function openConversation(context, router, conversationApi, item) {
        var params = {
            conversationType: utils.conversationType.GROUP,
            targetId: item.id,
            group: item.members
        };

        router.push({
            name: 'conversation',
            params: params
        });
    }

    function getFullPath(node) {
        let path = [];
        node.path.forEach(p => {
            if (p.type !== 2) path.push(p.name);
        });
        path.push(node.text);
        return path.join('/');
    } 


}(RongIM, null, RongIM.components));