//workCircle



(function(RongIM, dependencies, components) {
    'use strict';

    var common = RongIM.common;
    var utils = RongIM.utils;
    var $ = dependencies.jQuery;
    var cacheRootList = null;
    var layout = RongIM.config.layout;
    var rongMain = layout.main.margin;

    components.workCircle = function(resolve, reject) {
        var im = RongIM.instance;
        var dataModel = im.dataModel;
        var groupApi = dataModel.Group;
        var dialog = RongIM.dialog;
        var publicTreeView = RongIM.treeView;

        var orgApi = dataModel.Organization;

        var options = {
            name: 'work-circle',
            template: '#work-circle',
            components: {
                search: components.getSearch,
                leftList: components.leftList,
                treeForm: components.treeForm,
                kxyRight: components.kxyRight,
                friend: components.newGetFriends,
                newRequestFriend: components.newGetRequestFriend,
                newApprove: components.getNewApprove,
                treeItem: components.item,
                approve: components.getNewApprove
            },
            data: function() {
                return {
                    // tree 树结构数据
                    initDataList: [],
                    bound: {
                        width: {
                            min: 0,
                            max: 0
                        }
                    },
                    // 当前选中的节点信息
                    itemTree: null
                }
            },
            props: {},
            provide: function() {
                return { work: this }
            },
            computed: {

                isShowWelcome: function() {
                    if (this.itemTree && this.itemTree.root && this.itemTree.rootType == 'myMailList') {
                        return true
                    }
                    if (this.itemTree) {
                        return false
                    }
                    return true
                },

                showLoadLoading: function() {
                    if (this.initDataList.length) {
                        return false;
                    }
                    return true;
                },

                width: function() {
                    let node = im.resizeNode.rongList;
                    if (!node.width) return 300;
                    return node.width + 70;
                },

                componentType: function() {

                    if (this.itemTree && this.itemTree.root && this.itemTree.nodeType == 'KXY') {
                        return 'kxyRight'
                    }

                    if (this.itemTree && !this.itemTree.root) {
                        let typeArr = ['myFollow', 'myOrganization', 'KeyContacts', 'dailyContact', 'communicateGroup'];
                        if (typeArr.indexOf(this.itemTree.nodeType) != -1) return 'treeItem'
                    }

                    if (this.itemTree && !this.itemTree.root && this.itemTree.nodeType == 'fileAssistant') {
                        this.$refs.fileAssistant.start();
                        return 'fileAssistant'
                    }

                    if (this.itemTree && !this.itemTree.root && this.itemTree.nodeType == 'friendApply') {
                        return 'newRequestFriend'
                    }

                    if (this.itemTree && !this.itemTree.root && this.itemTree.nodeType == 'groupApply') {
                        return 'approve'
                    }

                    return ''
                }
            },
            created() {

                this.initTree()
            },

            mounted() {
                common.resizeNavNode(this, im);
            },

            methods: {

                // 初始化 tree 树结构数据
                initTree() {
                    let tree = publicTreeView.createdTreeJson([{ setId: 1 }, { setId: 2 }, {
                        setId: 3,
                        nodes: [{ setId: 5 }, { setId: 6 }, { setId: 7 }, { setId: 8 }, { setId: 9 }, { setId: 10 }]
                    }, {
                        setId: 4,
                        id: RongIM.instance.auth.companyId
                    }]);

                    this.getMyOrganization().then(res => {
                        if (res.length) tree[0].nodes = res;
                        return this.getMyFollow();

                    }).then(res => {
                        if (res.length) tree[1].nodes = res;
                        return this.getKXAllMembers();

                    }).then(res => {
                        tree[3].text = tree[3].text + '(' + res + '人)';
                        this.initDataList = tree;
                        console.log(this.initDataList)
                    }).catch(err => {
                        common.toastError(err);
                    })
                },

                // 初始化 我的组织
                getMyOrganization() {
                    return new Promise((resolve, reject) => {
                        orgApi.getMyOrganization(RongIM.instance.auth.id, {}, res => {
                            if (!res.count) {
                                resolve([]);
                            };

                            let arr = res.data.map(item =>
                                publicTreeView.init(this.configOption(item, "myOrganization", "myOrganization"))
                            );
                            resolve(arr)
                        })
                    })
                },

                // 初始化我的关注
                getMyFollow() {
                    return new Promise((resolve, reject) => {
                        orgApi.getMyfollow(RongIM.instance.auth.id, { focustate: '0' }, result => {
                            // console.log(result)
                            if (!result.count) {
                                resolve([])
                            }

                            let arr = result.data.map(item =>
                                publicTreeView.init(this.configOption(item, "myFollow", "myFollow"))
                            );
                            resolve(arr)
                        })
                    })
                },

                // 获取中科协总人数
                getKXAllMembers(tree) {
                    return new Promise((resolve, reject) => {
                        orgApi.getBranch(RongIM.instance.auth.companyId, { state: 0 }, (errorCode, result) => {
                            if (errorCode) {
                                reject(errorCode)
                            };

                            let count = 0;
                            if (result.depts.length) {
                                count = result.depts.reduce((total, currentValue, currentIndex, arr) => {
                                    return total + Number(currentValue.member_count);
                                }, 0);
                                resolve(count);
                            };
                        })
                    })
                },

                // 获取我的组织下的 组织节点
                getMyOrganizationMembers(item) {
                    let params = this.getRequestParams(item);
                    return new Promise((resolve, reject) => {
                        if (item.nodes && !item.nodes.length) {
                            orgApi.getMembers(item.id, params, result => {
                                if (result.count) {
                                    let arr = result.data.map(i => publicTreeView.init(this.configOption(i, item.rootType, item.nodeType)));
                                    resolve(arr)
                                }
                            })
                        } else {
                            resolve(item.nodes)
                        }
                    })
                },

                // 配置CreateMyTreeNode 类属性
                configOption(item, rootType, nodeType) {
                    let key = {
                            nodeType: nodeType || '',
                            rootType: rootType || '',
                            icon: item.vchar_p3 == 1 ? 'jianshe' : item.vchar_p3 == 2 ? 'company' : 'yingyong'
                        }
                        // return Object.assign( {}, key, { ...item } );
                    return Object.assign({}, key, item);
                },

                getRequestParams(item) {

                    let params = { type: 'depart', state: 0 };
                    // if (item && item.vchar_p3) {
                    //     params.orgtype = item.vchar_p3 == 1 ? '1' : '0,1,3';
                    // };

                    return params
                },

                // 处理点击tree节点后的操作
                seleTreeNode(item) {
                    this.itemTree = item;
                    if (item && item.root) return;

                    if (this.$refs.component && this.$refs.component.init && this.$refs.component.resetParams) {
                        this.$refs.component.resetParams();
                        this.$refs.component.init(item);
                    }
                },

                // 取消关注后刷新我的关注
                getMyFollowChange(item) {
                    let tree = $('#fixTree');
                    let itemNodeParent = tree.treeview('getParent', item.nodeId);

                    this.getMyFollow().then(res => {
                        // 没渲染 刷新我的关注数据
                        if (!item.nodeId || !item.parentId) {
                            this.initDataList[1].nodes = res;
                        }

                        if (res && res.length) {
                            tree.treeview("buildRemoveNode", [itemNodeParent.nodes, false]);
                            tree.treeview("deleteChildrenNode", [itemNodeParent.nodes[0].nodeId, { node: res, silent: true }, false]);
                            tree.treeview("addNode", [itemNodeParent.nodeId, { node: res, silent: true }, $('.BM1101'), itemNodeParent]);
                        }

                    }).catch(err => {
                        if (!err.count) {
                            tree.treeview("buildRemoveNode", [itemNodeParent.nodes, false])
                            tree.treeview("deleteChildrenNode", [itemNodeParent.nodes[0].nodeId, { node: [], silent: true }, true]);
                        }
                    })
                },


                getResizeDirection() {
                    let direction = common.getResizeDirection({
                        range: this.width - 70,
                        bound: this.bound.width,
                        directions: ['left', 'right']
                    });
                    im.resizeDirection.temp = direction;
                    return direction;
                }
            },

            destroyed() {
                cacheRootList = null;
                groupApi.unwatch(this.setApproveUnread);
            }
        };

        utils.asyncComponent(options, resolve, reject);

    }

}(RongIM, { jQuery: jQuery }, RongIM.components))