(function (RongIM, win, Fingerprint) {
'use strict';

function noop() {
}

function getVersion() {
    return '';
}

function playSight(message) {
    var url = message.content.sightUrl;
    if (!url) {
        return;
    }
    var w = win.open('sight.html');
    w.name = url;
}
var client = {
    regSearch: noop,
    unregSearch: noop,
    regLogout: noop,
    unregLogout: noop,
    regAccount: noop,
    unregAccount: noop,
    unregOpenCoversation: noop,
    regBalloon: noop,
    unregBalloon: noop,
    getVersion: getVersion,
    // showMessageBox: showMessageBox,
    userStatusTitle: 'Login_Status_Web',
    regDockClick: noop,
    unregDockClick: noop,
    playSight: playSight
};

function downloadHandle(url) {
    var a = document.createElement('A');
    a.href = url;
    a.download = url.substr(url.lastIndexOf('/') + 1);
    document.body.appendChild(a);
    a.click();
    document.body.removeChild(a);
}

function download(file) {
    var instance = {
        pause: noop,
        abort: noop,
        onError: noop,
        onReady: noop,
        onProgress: noop,
        // 注意：onComplete 在应用环节被重写了
        onComplete: noop,
        onCancel: noop
    };
    instance.start = instance.resume = instance.saveAs = instance.save = (function (url) {
        downloadHandle(url);
        if (this.onComplete) this.onComplete({});
    }).bind(instance, file.url);
    return instance;
}

var remoteWindowHandler = {
    extend: noop,
    restore: noop,
    extendWidth: noop,
    getWindowSize: noop,
    setMinWidth: noop,
    setDefaultMinWidth: noop
};

window.openExternal = function(url) {
    var a = document.createElement('A');
    a.target = '_blank';
    a.href = url;
    document.body.appendChild(a);
    a.click();
    document.body.removeChild(a);
}

var browserWindow = {
    max: noop,
    min: noop,
    restore: noop,
    close: noop,
    hide: noop,
    show: noop,
    flashFrame: noop,
    shakeWindow: noop,
    isFocused: noop,
    isVisible: noop,
    displayBalloon: noop,
    updateBadgeNumber: noop,
    remoteWindowHandler: remoteWindowHandler,
    toggleDevTools: noop,
    openPSArticle: openExternal,
    openVersions: function () {
        openExternal('./modules/appversion/index.html');
    },
    closeAll: function () {},
    enterPublic: function () {},
    sendPublicMessage: function () {},
    sendPublicNotify: function () {},
    openRemoteControl: noop,
    closeRemoteControl: noop,
    onRemoteControlAccept: noop,
    onRemoteControlReject: noop
};
// end region
var file = {
    checkExist: function () { return false; },
    open: noop,
    openDir: noop,
    getBlobs: function () { return null; },
    getPaths: function () { return ''; },
    getImgByPath: function () { return null; },
    getFiles: function () { return null; },
    zipFolders: noop,
    unzip: noop,
    delZip: noop,
    getFileStat: function () { return null; }
};
// @return 'web-darwin' or 'web-win32' or 'darwin' or 'win32'
function getPlatform() {
    var platform = navigator.platform.toLowerCase();
    if (platform.indexOf('mac') === 0) {
        platform = 'darwin';
    } else if (platform.indexOf('win') === 0) {
        platform = 'win32';
    } else if (platform.indexOf('linux') === 0) {
        platform = 'linux';
    }
    return 'web-' + platform;
}

function getDeviceId() {
    var fp = new Fingerprint({
        canvas: true,
        ie_activex: true,
        screen_resolution: true
    });
    return fp.get();
}

var system = {
    setShowVersion: noop,
    setLanguage: noop,
    clearCache: noop,
    relaunch: noop,
    exit: noop,
    logout: noop,
    setConnectStatus: noop,
    locale: navigator.language || navigator.systemLanguage,
    getDeviceId: getDeviceId,
    messageNotification: noop,
    dbPath: '',
    platform: getPlatform(),
    version: '',
    userDataPath: '',
    login: noop,
    setAutoLaunch: noop,
    getAutoLaunch: function () { return false; },
    reload: noop,
    reloadIgnoringCache: noop,
    openByBrowser: openExternal,
    appLogger: noop,
    processLogger: noop
};

function isAvailableData() {
    // Web 连接成功时才可操作数据
    var CONNECTED = 0;
    var status = RongIMClient.getInstance().getCurrentConnectionStatus();
    return status === CONNECTED;
}

var lib = {
    getDataProvider: function () {
        return null;
    },
    clearUnreadCountByTimestamp: function (params, callback) {
        RongIMClient.getInstance().clearUnreadCount(params.conversationType, params.targetId, {
            onSuccess: function () {
                callback();
            },
            onError: function (errorCode) {
                callback(errorCode);
            }
        });
    }
};
var screenshot = {
    start: noop,
    captureScreen: noop,
    // params(callback: function)
    setShortcut: noop,
    setHideWindow: noop,
    // params(enabled:boolean)
    setEnabled: noop
};

var getNavi = function (config, callback) {
    if (callback) {
        callback();
    }
};

var imageViewer = {
    openWin: function (options) {
        ImageViewer.dialog.viewerWeb(options);
    },
    close: noop,
    logout: noop,
    recall: function (messageUId) {
        var im = RongIM.instance;
        im.$emit('recallMsg', messageUId);
    }
};
var Intercepter = {
    find: function () {
        return null;
    },
    parseUrl: function () {
        return null;
    }
};
RongIM.Database = {
    init: function (appkey, key, callback) {
        if (callback) {
            callback();
        }
    },
    close: function (callback) {
        if (callback) {
            callback();
        }
    },
    clean: noop
};

RongIM.firstSyncdata = {
    get: function () {
        return false;
    },
    set: function () {}
};

RongIM.Intercepter = Intercepter;
RongIM.getNavi = getNavi;
RongIM.imageViewer = imageViewer;
RongIM.download = download;
RongIM.downloader = download;
RongIM.browserWindow = browserWindow;
RongIM.file = file;
RongIM.system = system;
RongIM.isAvailableData = isAvailableData;
RongIM.lib = lib;
RongIM.client = client;
RongIM.screenshot = screenshot;
RongIM.appVersion = null;

RongIM.downloader.getProgress = function () {
    return {};
};

RongIM.downloader.load = function (fileInfo) {
    return RongIM.downloader(fileInfo);
};
RongIM.downloader.getSaveFolder = function () {
    return {};
};
RongIM.remoteControl = {
    accept: noop,
    hangup: noop,
    join: noop
};

RongIM.cleanStorage = function () {
    win.localStorage.clear();
};

RongIM.upload = {
    setItem: noop,
    getItem: noop,
    removeItem: noop
};
}(RongIM, window, Fingerprint));
