(function (RongAppversion, dependencies) {
'use strict';

var utils = RongAppversion.utils;
var Vue = dependencies.Vue;

/*
纵向滚动条解决透明问题
update 数据变化时重新计算滚动条高度
*/
Vue.directive('rong-scroll-bar-y', {
    inserted: function (el) {
        var browserType = utils.getBrowser().type.toLowerCase();
        if (browserType !== 'chrome' && browserType !== 'safari') {
            return;
        }
        var $scrollContain = $(el);
        var $parent = $('<div></div>');
        $parent.css({
            height: '100%',
            position: 'relative'
        });
        $scrollContain.wrap($parent);
        var $scrollbar = $('<div class="rong-scroll-bar-y"><i></i></div>');
        if (browserType === 'safari') {
            $scrollbar.addClass('rong-scroll-bar-safari');
        }
        // $parent.append($scrollbar);
        $scrollContain.parent().append($scrollbar);
        $scrollContain.addClass('rong-scroll-content');
        var scrollContain = true;
        var timeoutContain;
        var scrollBar = true;
        var timeoutBar;

        var setupScrollHeight = function () {
            var $el = $(el).parent();
            $scrollbar.addClass('rong-scroll-bar-show');
            Vue.nextTick(function () {
                $el.find('.rong-scroll-bar-y>i').css({
                    display: 'block',
                    height: el.scrollHeight,
                    width: '7px'
                });
                setTimeout(function () {
                    if (scrollBar && scrollContain) {
                        $scrollbar.removeClass('rong-scroll-bar-show');
                    }
                }, 1500);
            });
        };
        var startScrollBar = function () {
            if (scrollBar) {
                setupScrollHeight();
                var top = $scrollbar.scrollTop();
                $scrollContain.scrollTop(top);
                scrollContain = false;
                clearTimeout(timeoutContain);
                timeoutContain = setTimeout(function () {
                    scrollContain = true;
                }, 500);
            }
        };
        var startScrollContain = function () {
            if (scrollContain) {
                setupScrollHeight();
                var top = $scrollContain.scrollTop();
                $scrollbar.scrollTop(top);
                scrollBar = false;
                clearTimeout(timeoutBar);
                timeoutBar = setTimeout(function () {
                    scrollBar = true;
                }, 500);
            }
        };

        $scrollbar.on('scroll', startScrollBar);
        $scrollContain.on('scroll', startScrollContain);
        // $scrollContain.hover(startScrollContain);
    },
    update: function (el) {
        var browserType = utils.getBrowser().type.toLowerCase();
        if (browserType !== 'chrome' && browserType !== 'safari') {
            return;
        }
        var $el = $(el).parent();
        Vue.nextTick(function () {
            $el.find('.rong-scroll-bar-y>i').css({
                display: 'block',
                height: el.scrollHeight,
                width: '7px'
            });
        });
    }
});

RongAppversion.common = {
};
}(window.RongAppversion, {
    jQuery: jQuery,
    Vue: Vue
}));
