(function (RongAppversion) {
'use strict';

var utils = RongAppversion.utils;
var platformsArr = {
    Windows: 'windows',
    macOS: 'macos'
};

function getPlatform() {
    var platform = utils.getPlatform();
    if (platform === 'web') {
        var isMac = /macintosh|mac os x/i.test(navigator.userAgent);
        return isMac ? 'macOS' : 'Windows';
    }
    return {
        windows: 'Windows',
        OSX: 'macOS'
    }[platform];
}

function getFullUrl(url) {
    return RongAppversion.config.server + url;
}

var ajax = function (options, callback) {
    var data = $.isEmptyObject(options.data) ? null : JSON.stringify(options.data);
    var arg = {
        url: getFullUrl(options.url),
        method: options.method,
        xhrFields: {
            withCredentials: true
        },
        headers: {
            'Content-Type': 'application/json;charset=UTF-8'
        },
        data: data,
        dataType: 'json'
    };
    return $.ajax(arg).then(function (rep) {
        var defer = $.Deferred();
        if (rep.code !== 10000) {
            callback(rep.code);
            defer.reject(rep.code);
        } else {
            callback(null, rep.result);
            callback.done = true;
            defer.resolve(rep.result);
        }
        return defer.promise();
    }).fail(function (rep) {
        if (!callback.done) callback(rep);
    });
};

var server = {
    getAppVersions: function (callback) {
        var platform = getPlatform();
        var url = '/appversion/all?platforms=' + platform;
        ajax({
            url: url
        }, function (errorCode, result) {
            if (errorCode) {
                callback(errorCode);
                return;
            }
            var list = result[platformsArr[platform]] || [];
            callback(null, list);
        });
    }
};

RongAppversion.serverApi = server;
}(window.RongAppversion));
