(function (RongIM, dependencies, components) {
    'use strict';

    var common = RongIM.common;
    var utils = RongIM.utils;
    var $ = dependencies.jQuery;
    var collectApi = RongIM.dataModel.Collect;
    var typeList = RongIM.dataModel.Collect.typeList;
    function getCollectList(resolve, reject) {
        var im = RongIM.instance;
        var options = {
            name: 'collectList',
            template: 'modules/collect/templates/collect.html',
            data: function () {
                return {
                    showAll: true,
                    collectList: [],
                    typeList: typeList
                };
            },
            computed: {
                showText: function () {
                    return this.typeList.indexOf('RC:TxtMsg') > -1;
                },
                showVoice: function () {
                    return this.typeList.indexOf('RC:VcMsg') > -1;
                },
                showPosition: function () {
                    return this.typeList.indexOf('RC:LBSMsg') > -1;
                },
                showFile: function () {
                    return this.typeList.indexOf('RC:FileMsg') > -1 || this.typeList.indexOf('LRC:fileMsg') > -1;
                },
                showVideo: function () {
                    return this.typeList.indexOf('RC:ImgMsg') > -1 || this.typeList.indexOf('RC:SightMsg') > -1;
                },
                showLink: function () {
                    return this.typeList.indexOf('RC:ImgTextMsg') > -1;
                }
            },
            watch: {
                $route: function (newVal, oldVal) {
                    if ((newVal.name === 'collect-all' || newVal.name === 'collect') && newVal.name !== oldVal.name) {
                        getList(this);
                    }
                }
            },
            components: {
                search: components.getCollectSearch
            },
            mounted: function () {
                var context = this;
                if (!typeList || typeList.length === 0) {
                    getList(context);
                }
                im.$on('typelistchange', function (item) {
                    context.typeList = item;
                    RongIM.dataModel.Collect.typeList = item;
                });
                im.$on('collectList', function () {
                    getList(context);
                });
            }
        };
        utils.asyncComponent(options, resolve, reject);
        function getList(context) {
            var params = {
                version: -1,
                scope: 'message'
            };
            collectApi.getList(params, function (errorcode, list) {
                if (errorcode) {
                    common.toastError(errorcode);
                    context.Busy = false;
                    return;
                }
                context.collectList = list;
                var arr = list.map(function (item) {
                    return item.objectName;
                });
                context.typeList = arr.filter(function (x, index, self) {
                    return self.indexOf(x) === index;
                });

                context.showAll = true;
                if (arr.length === 0) {
                    return;
                }
                var count = arr.reduce(function (allElements, ele) {
                    if (ele in allElements) {
                        allElements[ele] += 1;
                    } else {
                        allElements[ele] = 1;
                    }
                    return allElements;
                }, {});
                im.$on('collectlength', function (fn) {
                    fn(count, list);
                });
                RongIM.dataModel.Collect.typeList = context.typeList;
            });
        }
    }
    $.extend(true, components, {
        collect: {
            getCollectList: getCollectList
        }
    });
}(RongIM, {
    jQuery: jQuery
}, RongIM.components));
