(function (RongIM, dependencies, components) {
'use strict';

var utils = RongIM.utils;

components.getCollectSearch = function (resolve, reject) {
    var im = RongIM.instance;
    var collectApi = RongIM.dataModel.Collect;
    var timer = null;
    var options = {
        name: 'search',
        template: 'modules/collect/templates/search.html',
        data: function () {
            return {
                keyword: '',
                oldkeyword: ''
            };
        },
        created: function () {
        },
        watch: {
            $route: function () {
                this.clear();
                this.search();
            }
        },
        methods: {
            clear: function () {
                this.keyword = '';
                this.search();
            },
            search: function () {
                var context = this;
                clearTimeout(timer);
                timer = setTimeout(function () {
                    search(context);
                }, 500);
            }
        }
    };
    utils.asyncComponent(options, resolve, reject);
    function search(context) {
        if (context.keyword !== context.oldkeyword) {
            var params = {
                scope: 'message',
                keyword: context.keyword
            };
            var route = context.$route.params.id;
            if (route === 'text') {
                params.type = 'RC:TxtMsg';
            } else if (route === 'voice') {
                params.type = 'RC:VcMsg';
            } else if (route === 'position') {
                params.type = 'RC:LBSMsg';
            } else if (route === 'video') {
                params.type = ['RC:ImgMsg', 'RC:SightMsg'];
            } else if (route === 'file') {
                params.type = ['RC:FileMsg', 'LRC:fileMsg'];
            } else if (route === 'link') {
                params.type = 'RC:ImgTextMsg';
            }
            collectApi.search(params, function (errorcode, ids) {
                im.$emit('keywordsearch', ids, context.keyword);
            });
        }
        context.oldkeyword = context.keyword;
    }
};
}(RongIM, {
    jQuery: jQuery,
    Vue: Vue
}, RongIM.components));
