(function (RongIM, dependencies, components) {
'use strict';

var common = RongIM.common;
var utils = RongIM.utils;
var KEYCODE = utils.keyCode;
var dialog = RongIM.dialog;
// var $ = dependencies.jQuery;

RongIM.dialog.addFriend = function () {
    var im = RongIM.instance;
    var friendApi = im.dataModel.Friend;
    var orgApi = im.dataModel.Organization;
    var options = {
        name: 'add-friend',
        template: 'modules/friend/templates/add-friend.html',
        data: function () {
            return {
                externalFriend: true,
                show: true,
                mobile: '',
                contactName: '',
                contactRemark: '',
                user: null,
                userList: [],
                searchDone: false,
                isAuthStaff: im.auth.isStaff,
                isLoginUser: false,
                isFriend: false,
                isStaff: false
            };
        },
        components: {
            avatar: components.getAvatar
        },
        mixins: [
            components.getValidate()
        ],
        methods: getMethods(friendApi, orgApi, im.auth)
    };

    common.mountDialog(options, function (instance) {
        RongIM.debug.addFriend = instance;
    });
};

function getMethods(friendApi, orgApi, auth) {
    return {
        toastError: function (errorCode) {
            var el = null;
            if (this.$el) {
                el = this.$el.firstChild;
            }
            common.toastError(errorCode, el);
        },
        userProfile: dialog.userRequest,
        getUsername: common.getUsername,
        close: function () {
            this.show = false;
        },
        search: function () {
            search(this, friendApi, orgApi, auth);
        },
        addExternalFriend: function () {
            if (!this.contactName) {
                common.messageToast({
                    message: '请输入联系人姓名',
                });
                return;
            }
            var loginInfo = utils.cache.get('loginInfo');
            friendApi.addExternalFriend(this, loginInfo.phone);
        },
        addFriend: function (user) {
            var requestInfo = friendApi.getRequest(user.id);
            var isRequesting = requestInfo && requestInfo.state === common.FriendState.INVITEE;
            if (isRequesting) {
                acceptFriend(this, friendApi, requestInfo);
                return;
            }
            RongIM.dialog.verifyFriend(user);
            this.close();
        },
        keydown: function (event) {
            var context = this;
            var isEnter = (event.keyCode === KEYCODE.enter);
            if (isEnter) {
                search(context, friendApi, orgApi, auth);
            }
            context.searchDone = false;
            context.user = null;
            context.isLoginUser = false;
            context.isFriend = false;
        },
        userName: function (user) {
            var name = user.name;
            // *规则只针对访客登录搜索内部非好友
            if (!this.isAuthStaff && user.isStaff && !user.isFriend && !user.isLoginUser) {
                name = name.replace(/.$/g, '*');
            }
            return name;
        }
    };
}

function search(context, friendApi, orgApi, auth) {
    if (!context.valid()) {
        return;
    }
    context.searchDone = false;
    var promiseList = [];
    var staffList = [];
    var mobileDefer = $.Deferred();
    friendApi.search(context.mobile, function (errorCode, result) {
        // 手机号不符合规则会返回 10115 错误码，此处屏蔽
        // eslint-disable-next-line eqeqeq
        if (errorCode == '10115') {
            result = [];
        } else if (errorCode) {
            mobileDefer.reject();
            common.toastError(errorCode);
            return;
        }
        staffList = staffList.concat(result);
        mobileDefer.resolve();
    });
    promiseList.push(mobileDefer.promise());
    var staffnoDefer = $.Deferred();
    orgApi.searchByStaffNo(context.mobile, function (errorCode, result) {
        if (errorCode) {
            staffnoDefer.reject();
            common.toastError(errorCode);
            return;
        }
        staffList = staffList.concat(result);
        staffnoDefer.resolve();
    });
    promiseList.push(staffnoDefer.promise());
    var _callback = function () {
        context.searchDone = true;
        staffList.forEach(function (user) {
            if (user.id === auth.id) {
                user.isLoginUser = true;
            }
            var cacheFriend = friendApi.getCacheFriend(user.id);
            if (cacheFriend) {
                user.isFriend = true;
            }
            user.isStaff = (user.user_type === common.UserType.STAFF);
        });
        context.userList = staffList;
    };
    $.when.apply(null, promiseList).done(_callback).catch(function (errorCode) {
        // eslint-disable-next-line eqeqeq
        if (errorCode == '10115') {
            _callback();
        }
    });
}

function acceptFriend(context, friendApi, request) {
    friendApi.accept(request, function (errorCode, result) {
        if (errorCode) {
            if (errorCode === common.ErrorCode.RCEC_FRIEND_REQUEST_TIMEOUT) {
                request.state = -1;
            }
            context.toastError(errorCode);
            return;
        }
        utils.console.log('acceptFriend', result);
        request.state = common.FriendState.ACCEPT;
        context.close();
    });
}
}(RongIM, {
    // jQuery: jQuery
}, RongIM.components));
