(function (RongIM, dependencies, components) {
'use strict';

var utils = RongIM.utils;
var dialog = RongIM.dialog;
var common = RongIM.common;

function getFriends(resolve, reject) {
    var im = RongIM.instance;
    var friendApi = im.dataModel.Friend;
    var options = {
        name: 'friends',
        template: 'modules/friend/templates/friends.html',
        data: function () {
            return {
                isLoadDone: false,
                letter: '',
                list: [],
                fileHelper: null
            };
        },
        computed: {
            orderFriend: function () {
                return this.list;
            },
            navFriend: function () {
                var context = this;
                var friends = {};
                context.orderFriend.forEach(function (item) {
                    var firstLetter = context.getFirstLetter(item.name);
                    if (utils.isEmpty(friends[firstLetter])) {
                        friends[firstLetter] = item;
                    }
                });
                return friends;
            },
            showEmptyFriend: function () {
                return this.list.length === 0;
            }
        },
        directives: {
            scrollToLetter: function (el, binding) {
                var letter = $(el).data('letter');
                if (letter === binding.value) {
                    el.scrollIntoView();
                }
            }
        },
        mounted: function () {
            initList(this, friendApi);
        },
        methods: {
            getUsername: function (item) {
                return item ? (RongIM.dataModel._Cache.alias[item.id] || common.getUsername(item)) : '';
            },
            userProfile: dialog.user,
            getFirstLetter: function (name) {
                name = name && name.charAt(0);
                var pinyinObj = utils.convertToABC(name);
                var firstLetter = pinyinObj.first.toUpperCase();
                return firstLetter;
            },
            isNavFriend: function (friend) {
                var firstLetter = this.getFirstLetter(friend.name);
                var friendNav = this.navFriend[firstLetter];
                if (friendNav && friendNav.id === friend.id) {
                    return true;
                }
                return false;
            },
            scrollToFriend: function (letter) {
                this.letter = letter;
            },
            getFileHelper: dialog.getFileHelper
        },
        components: {
            avatar: components.getAvatar
        },
        destroyed: function () {
            cleanup(this, friendApi);
        }
    };
    utils.asyncComponent(options, resolve, reject);
}

function getFriendList(context, friendApi) {
    var list = friendApi.getCacheList();
    if ($.isEmptyObject(list)) {
        friendApi.getList(function (errorCode, dataArr) {
            context.list = dataArr;
            context.isLoadDone = true;
        });
    } else {
        context.list = list;
        context.isLoadDone = true;
    }
    friendApi.getFileHelper(function (error, helper) {
        context.fileHelper = helper;
    });
}

function addFriendWatch(context, friendApi) {
    context.friendWatch = function (result) {
        if (result.type === 'Request') {
            return;
        }
        context.list = result.list;
    };
    friendApi.watch(context.friendWatch);
}

function initList(context, friendApi) {
    getFriendList(context, friendApi);
    addFriendWatch(context, friendApi);
}

function cleanup(context, friendApi) {
    friendApi.unwatch(context.friendWatch);
}

$.extend(true, components, {
    contact: {
        getFriends: getFriends
    }
});
}(RongIM, {}, RongIM.components));
