(function (RongIM, dependencies, components) {
'use strict';

var common = RongIM.common;
var utils = RongIM.utils;
var $ = dependencies.jQuery;

function getFriend(resolve, reject) {
    var im = RongIM.instance;
    var dataModel = im.dataModel;
    var friendApi = dataModel.Friend;
    var userApi = dataModel.User;
    var options = {
        name: 'friend',
        template: 'modules/friend/templates/group-friend.html',
        data: function () {
            return {
                keyword: '',
                searchResult: [],
                members: []
            };
        },
        props: ['selected', 'defaultSelected', 'canNotSelected', 'hasFileHelper'],
        computed: {
            defaultIdList: function () {
                return (this.defaultSelected || []).map(function (item) {
                    return item.id;
                });
            },
            canNotSelectedIdList: function () {
                return (this.canNotSelected || []).map(function (item) {
                    return item.id;
                });
            },
            checkedAll: {
                get: function () {
                    return getCheckedAll(this);
                },
                set: function (value) {
                    setCheckedAll(this, value);
                }
            },
            indeterminate: function () {
                if (this.isCardSelect) {
                    return false;
                }
                return (typeof this.checkedAll) !== 'boolean';
            },
            checked: {
                get: function () {
                    var context = this;
                    return context.selected.filter(function (item) {
                        return !context.isGroup(item);
                    }).map(function (item) {
                        return item.id;
                    });
                },
                set: function (newMemberIds) {
                    var context = this;
                    userApi.get(newMemberIds, function (errorCode, newMembers) {
                        newMembers = [].concat(newMembers);
                        if (errorCode) {
                            context.toastError(errorCode);
                            return;
                        }
                        userApi.get(context.checked, function (UerrorCode, oldMembers) {
                            oldMembers = [].concat(oldMembers);
                            if (UerrorCode) {
                                context.toastError(UerrorCode);
                                return;
                            }
                            var addedList = common.without(newMembers, oldMembers);
                            if (addedList.length > 0) context.$emit('added', addedList);

                            var removedList = common.without(oldMembers, newMembers);
                            var listLen = removedList.length;
                            if (listLen > 0) context.$emit('removed', removedList);
                        });
                    });
                    if (context.keyword) context.clear();
                }
            },
            isCardSelect: function () {
                return this.$parent.$options.name === 'card';
            }
        },
        components: {
            avatar: components.getAvatar
        },
        watch: {
            keyword: function (keyword) {
                keywordChanged(this, keyword);
            }
        },
        created: function () {
            created(this, friendApi);
        },
        methods: {
            toastError: function (errorCode) {
                var el = null;
                if (this.$parent) {
                    el = this.$parent.$el.firstChild;
                }
                common.toastError(errorCode, el);
            },
            getUsername: function (item) {
                var name = common.getUsernameHighlight(item);
                return common.filterMark(name);
            },
            isDefault: function (item) {
                return this.defaultIdList.indexOf(item.id) >= 0;
            },
            showNotSelect: function (item) {
                var canNotSelected = this.canNotSelectedIdList.indexOf(item.id) > -1;
                return canNotSelected;
            },
            isDisabled: function (item) {
                var canNotSelected = this.canNotSelectedIdList.indexOf(item.id) > -1;
                return this.isDefault(item) || canNotSelected;
            },
            clear: function () {
                this.keyword = '';
            },
            isGroup: function (item) {
                // return item.conversationType === 3;
                return item.id.startsWith('group_');
            }
        }
    };
    utils.asyncComponent(options, resolve, reject);
}

function getCheckedAll(context) {
    var starChecked = [];
    var checkedIdList = context.checked;
    var validMember = context.searchResult.filter(function (item) {
        return context.canNotSelectedIdList.indexOf(item.id) === -1;
    });
    validMember.forEach(function (item) {
        var existed = checkedIdList.indexOf(item.id) >= 0;
        if (existed) starChecked.push(item);
    });
    var length = starChecked.length;
    var result;
    if (length > 0) {
        var isAll = length === validMember.length;
        result = isAll ? true : null;
    } else {
        result = false;
    }
    return result;
}

function setCheckedAll(context, value) {
    var validMember = context.searchResult.filter(function (item) {
        return context.canNotSelectedIdList.indexOf(item.id) === -1;
    });
    var memberIds = validMember.map(function (item) {
        return item.id;
    });
    if (value) {
        context.checked = [].concat(memberIds, context.checked);
    } else {
        context.checked = context.checked.filter(function (id) {
            return memberIds.indexOf(id) < 0;
        });
    }
}

function keywordChanged(context, keyword) {
    if (keyword.length === 0) {
        if (context.searchResult.length === 0) {
            context.searchResult = context.members;
        }
        // context.searchResult = context.members;
    } else {
        context.searchResult = [];
        var searchResult = [];
        context.members.forEach(function (item) {
            var nameRange = utils.searchStrRange(item.name, context.keyword);
            var aliasRange = utils.searchStrRange(item.alias, context.keyword);
            if (nameRange || aliasRange) {
                var result = $.extend({
                    range: nameRange,
                    aliasRange: aliasRange
                }, item);
                searchResult.push(result);
            }
        });
        common.sortUsers(searchResult);
        context.searchResult = searchResult;
    }
}

function created(context, friendApi) {
    friendApi.getList(function (errorCode, list) {
        if (errorCode) {
            context.toastError(errorCode);
            return;
        }
        common.sortUsers(list);
        context.members = [].concat(list);
        context.searchResult = list;
        if (context.hasFileHelper) {
            friendApi.getFileHelper(function (error, helper) {
                context.members.push(helper);
                context.searchResult = context.members;
            });
        }
    });
}

$.extend(true, components, {
    group: {
        getFriend: getFriend
    }
});
}(RongIM, {
    jQuery: jQuery
}, RongIM.components));
